/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.manaweaving;

import com.mna.api.blocks.IManaweaveNotifiable;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.blocks.tileentities.ManaweavingAltarTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.items.ItemInit;
import com.mna.items.manaweaving.ItemManaweaverWand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ManaweavingAltarBlock
extends WaterloggableBlock
implements EntityBlock,
IManaweaveNotifiable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape FOOT = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape PILLAR = Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0);
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape COMBINED_SHAPE = Shapes.m_83124_((VoxelShape)FOOT, (VoxelShape[])new VoxelShape[]{PILLAR, TOP});

    public ManaweavingAltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(3.0f).m_60955_(), false);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
    }

    public VoxelShape m_5940_(BlockState p_48816_, BlockGetter p_48817_, BlockPos p_48818_, CollisionContext p_48819_) {
        return COMBINED_SHAPE;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        ItemStack activeStack = player.m_21205_();
        if (activeStack.m_41720_() == ItemInit.RECIPE_COPY_BOOK.get()) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return InteractionResult.FAIL;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof ManaweavingAltarTile) {
            ManaweavingAltarTile te = (ManaweavingAltarTile)tileEntity;
            if (activeStack.m_41619_() && te.reCraft(player)) {
                return InteractionResult.SUCCESS;
            }
            if (activeStack.m_41720_() instanceof ItemManaweaverWand) {
                te.popPattern(player);
            } else if (player.m_6047_() || activeStack.m_41619_()) {
                ItemStack stack = te.popItem(player);
                if (!stack.m_41619_() && !player.m_36356_(stack)) {
                    player.m_36176_(stack, true);
                }
            } else if (!activeStack.m_41619_()) {
                ItemStack single = activeStack.m_41777_();
                single.m_41764_(1);
                if (te.pushItem(player, single) && !player.m_7500_()) {
                    activeStack.m_41774_(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ManaweavingAltarTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.MANAWEAVING_ALTAR.get() ? (lvl, pos, state1, be) -> ManaweavingAltarTile.Tick(lvl, pos, state1, (ManaweavingAltarTile)be) : null;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropInventory(worldIn, pos);
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof ManaweavingAltarTile) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileEntity));
        }
    }

    @Override
    public boolean notify(Level world, BlockPos pos, BlockState state, List<IManaweavePattern> patterns, @Nullable LivingEntity caster) {
        if (!world.f_46443_ && caster instanceof Player) {
            Player player = (Player)caster;
            ManaweavingAltarTile te = (ManaweavingAltarTile)world.m_7702_(pos);
            if (te != null && te.getAddedPatterns().size() < 6) {
                te.pushPattern(patterns.get(0), player);
                return true;
            }
        }
        return false;
    }
}

