/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.manaweaving;

import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.blocks.tileentities.ManaweaveProjectorTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.items.ItemInit;
import com.mna.items.manaweaving.ItemManaweavingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ManaweaveProjectorBlock
extends WaterloggableBlock
implements ICutoutBlock,
EntityBlock {
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.m_61631_((String)"fill_level", (int)0, (int)4);
    public static final BooleanProperty PROJECTING = BooleanProperty.m_61465_((String)"projecting");
    public static final int EMPTY = 0;
    public static final int QUARTER = 1;
    public static final int HALF = 2;
    public static final int THREE_QUARTERS = 3;
    public static final int FULL = 4;
    private static final VoxelShape FOOT = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape PILLAR = Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape COMBINED_SHAPE = Shapes.m_83110_((VoxelShape)FOOT, (VoxelShape)PILLAR);

    public ManaweaveProjectorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(3.0f).m_60955_(), false);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)PROJECTING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COMBINED_SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FILL_LEVEL, PROJECTING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ManaweaveProjectorTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.MANAWEAVE_PROJECTOR.get() ? (lvl, pos, state1, be) -> ManaweaveProjectorTile.Tick(lvl, pos, state1, (ManaweaveProjectorTile)be) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (!worldIn.f_46443_) {
            ItemStack stack = player.m_21120_(handIn);
            BlockEntity te = worldIn.m_7702_(pos);
            if (te != null && te instanceof ManaweaveProjectorTile) {
                if (stack.m_41720_() == ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get()) {
                    ResourceLocation rLoc = ((ItemManaweavingPattern)ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get()).getRecipe(stack, worldIn);
                    ((ManaweaveProjectorTile)te).setPattern(rLoc, player);
                    worldIn.m_7260_(pos, state, state, 2);
                } else {
                    ((ManaweaveProjectorTile)te).trySpawnManaweaveEntity(player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null && te instanceof ManaweaveProjectorTile) {
            float pct = ((ManaweaveProjectorTile)te).getMana() / 100.0f;
            return (int)(pct * 15.0f);
        }
        return 0;
    }
}

