/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.TransitoryTunnelTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TransitoryTunnelBlock
extends Block
implements IDontCreateBlockItem,
ITranslucentBlock,
EntityBlock {
    public static final IntegerProperty FACE_VISIBILITY_MASK = IntegerProperty.m_61631_((String)"face_visibility", (int)0, (int)63);

    public TransitoryTunnelBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280170_().m_60910_().m_60978_(0.0f).m_60955_().m_222994_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TransitoryTunnelTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : (lvl, pos, state1, be) -> TransitoryTunnelTile.ServerTick(lvl, pos, state1, (TransitoryTunnelTile)be);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        int check_mask = TransitoryTunnelBlock.getMaskForDirection(side);
        int state_mask = (Integer)state.m_61143_((Property)FACE_VISIBILITY_MASK);
        return (state_mask & check_mask) != 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACE_VISIBILITY_MASK});
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        int mask = TransitoryTunnelBlock.getStateBasedOnSurroundings(worldIn, pos);
        if ((Integer)state.m_61143_((Property)FACE_VISIBILITY_MASK) == mask) {
            return;
        }
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)FACE_VISIBILITY_MASK, (Comparable)Integer.valueOf(mask)), 3);
    }

    public static int getStateBasedOnSurroundings(Level world, BlockPos pos) {
        int mask = 0;
        for (Direction d : Direction.values()) {
            mask |= TransitoryTunnelBlock.calculateDirectionalMask(world, pos, d);
        }
        return mask;
    }

    private static int calculateDirectionalMask(Level world, BlockPos pos, Direction direction) {
        BlockState offsetState = world.m_8055_(pos.m_121955_(direction.m_122436_()));
        if (offsetState.m_60734_() != BlockInit.TRANSITORY_TUNNEL.get()) {
            return 0;
        }
        return TransitoryTunnelBlock.getMaskForDirection(direction);
    }

    private static int getMaskForDirection(Direction direction) {
        switch (direction) {
            default: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 4;
            }
            case WEST: {
                return 8;
            }
            case UP: {
                return 16;
            }
            case DOWN: 
        }
        return 32;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn.f_46443_ && rand.m_188501_() < 0.2f) {
            worldIn.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), (double)((float)pos.m_123341_() + rand.m_188501_()), (double)((float)pos.m_123342_() + rand.m_188501_()), (double)((float)pos.m_123343_() + rand.m_188501_()), 0.0, (double)0.1f, 0.0);
        }
    }
}

