/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.sound.SFX;
import com.mna.blocks.tileentities.CoffinTile;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.boss.WitherLich;
import com.mna.factions.Factions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CoffinBlock
extends BedBlock {
    public CoffinBlock() {
        super(DyeColor.BLACK, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_60978_(3.0f));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && (state = worldIn.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60734_() != this) {
            return InteractionResult.CONSUME;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null && te instanceof CoffinTile) {
            CoffinTile coffin = (CoffinTile)te;
            if (coffin.getRitualPlayer() == player) {
                if (!((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
                    this.applyColdDark(player, worldIn, state, pos);
                    coffin.setRitualPlayer(null);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            MutableBoolean canUse = new MutableBoolean(false);
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> canUse.setValue(p.getAlliedFaction() == Factions.UNDEAD));
            if (!canUse.booleanValue()) {
                player.m_213846_((Component)Component.m_237115_((String)"mna.faction.cant_use_generic"));
                return InteractionResult.FAIL;
            }
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        return InteractionResult.FAIL;
    }

    private void applyColdDark(Player player, Level world, BlockState coffin, BlockPos pos) {
        player.getPersistentData().m_128356_("coldDarkPos", pos.m_121878_());
        player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.COLD_DARK.get(), 200));
        Direction dir = coffin.getBedDirection((LevelReader)world, pos).m_122424_();
        BlockPos destBP = pos.m_121945_(dir.m_122428_()).m_5484_(dir, 2);
        BlockPos startBP = destBP.m_5484_(dir, 10);
        Vec3 adjustment = Vec3.f_82478_;
        switch (dir) {
            case WEST: {
                adjustment = new Vec3(0.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                adjustment = new Vec3(0.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                adjustment = new Vec3(1.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                adjustment = new Vec3(-1.0, 0.0, 0.0);
                break;
            }
        }
        Vec3 dest = new Vec3((double)((float)destBP.m_123341_() + 0.5f), (double)destBP.m_123342_() + 0.5, (double)((float)destBP.m_123343_() + 0.5f)).m_82549_(adjustment);
        Vec3 start = new Vec3((double)startBP.m_123341_(), (double)startBP.m_123342_(), (double)startBP.m_123343_()).m_82549_(adjustment);
        WitherLich lich = new WitherLich(world);
        lich.setFactionJoin(player, start, dest, 100);
        lich.m_6034_(start.f_82479_, start.f_82480_, start.f_82481_);
        world.m_7967_((Entity)lich);
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SFX.Event.Ritual.COLD_DARK, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float dist) {
        super.m_142072_(level, state, pos, entity, dist * 2.0f);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CoffinTile(pos, state);
    }
}

