/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.particles.parameters;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public class ParticleFloat {
    private final float value;

    public ParticleFloat(float scale) {
        this.value = scale;
    }

    public float value() {
        return this.value;
    }

    public String serialize() {
        return "" + this.value;
    }

    @Nullable
    public static ParticleFloat deserialize(String string) {
        if (string == null || string == "") {
            return null;
        }
        return new ParticleFloat(Float.parseFloat(string));
    }

    @Nullable
    public static ParticleFloat deserialize(FriendlyByteBuf packetBuffer) {
        if (packetBuffer.readBoolean()) {
            return new ParticleFloat(packetBuffer.readFloat());
        }
        return null;
    }

    public static void serialize(@Nullable ParticleFloat inst, FriendlyByteBuf packetBuffer) {
        if (inst != null) {
            packetBuffer.writeBoolean(true);
            packetBuffer.writeFloat(inst.value());
        } else {
            packetBuffer.writeBoolean(false);
        }
    }
}

