/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.construct.ai;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructTask;
import com.mna.api.entities.construct.ai.IMutexManager;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public abstract class ConstructAITask<T extends ConstructAITask<?>>
extends Goal {
    protected static final int MOVE_COOLDOWN = 20;
    public static final int SWING_BUFFER_TIME = 5;
    public static final int MELEE_ATTACK_TIME = 8;
    public static final int MELEE_ATTACK_DIST = 2;
    protected IConstruct<?> construct;
    protected IMutexManager mutexManager;
    protected Player owner;
    protected int exitCode = -1;
    protected boolean hasStarted = false;
    protected boolean isOneOff = false;
    protected UUID oneOffFollowTarget = null;
    protected int moveCooldown;
    protected int fleeCooldown;
    protected int teleportCooldown = 0;
    private BlockPos moveBlockTarget = null;
    private Entity moveEntityTarget = null;
    protected int attackCooldown = 0;
    private List<ConstructAITaskParameter> _parameters;
    private String id = null;
    protected final ResourceLocation guiIcon;
    private boolean isStart = false;
    private final HashMap<Integer, String> connections;

    public ConstructAITask(IConstruct<?> construct, ResourceLocation guiIcon) {
        this.construct = construct;
        this._parameters = this.instantiateParameters();
        this.connections = new HashMap();
        this.guiIcon = guiIcon;
    }

    public IConstruct<?> getConstruct() {
        return this.construct;
    }

    @Nullable
    public IMutexManager getMutexManager() {
        return this.mutexManager;
    }

    public final String getId() {
        return this.id;
    }

    public final boolean isStart() {
        return this.isStart;
    }

    public abstract ResourceLocation getType();

    public final boolean isOneOff() {
        return this.isOneOff;
    }

    public final UUID getOneOffFollowTarget() {
        return this.oneOffFollowTarget;
    }

    public final AbstractGolem getConstructAsEntity() {
        return this.getConstruct().asEntity();
    }

    public int getInteractTime(ConstructCapability capability, int baseline) {
        if (this.getConstruct() == null) {
            return 30;
        }
        ConstructMaterial material = this.getConstruct().getConstructData().getLowestMaterialCooldownMultiplierForCapability(capability);
        if (material == null) {
            return baseline;
        }
        return (int)Math.max(material.getCooldownMultiplierFor(capability) * (float)baseline, 5.0f);
    }

    public int getInteractTime(ConstructCapability capability) {
        return this.getInteractTime(capability, 50);
    }

    public ConstructCapability[] requiredCapabilities() {
        return new ConstructCapability[0];
    }

    public boolean allowSteeringMountedConstructsDuringTask() {
        return false;
    }

    public final String getConnectionForResultCode(int result) {
        return this.connections.getOrDefault(result, null);
    }

    protected Player createFakePlayer() {
        UUID ownerID = this.construct.getOwnerId();
        FakePlayer fakePlayer = null;
        fakePlayer = ownerID == null ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.construct.asEntity().m_9236_())) : FakePlayerFactory.get((ServerLevel)((ServerLevel)this.construct.asEntity().m_9236_()), (GameProfile)new GameProfile(ownerID, "[Construct Fake Player]"));
        fakePlayer.m_146884_(this.construct.asEntity().m_20182_());
        return fakePlayer;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public boolean areCapabilitiesMet() {
        return this.construct.getConstructData().areCapabilitiesEnabled(this.requiredCapabilities());
    }

    protected Optional<ConstructAITaskParameter> getParameter(String id) {
        return this.getParameters().stream().filter(p -> p.getId().equals(id)).findFirst();
    }

    public List<String> getConnectedIDs() {
        return this.connections.values().stream().toList();
    }

    public int getRequiredIntelligence() {
        return 1;
    }

    public boolean hasMoveTarget() {
        return this.moveBlockTarget != null || this.moveEntityTarget != null;
    }

    public BlockPos getMoveBlockTarget() {
        return this.moveBlockTarget;
    }

    public Entity getMoveEntityTarget() {
        return this.moveEntityTarget;
    }

    public final void setIdAndIsStart(String id, boolean isStart) {
        if (this.id == null) {
            this.id = id;
            this.isStart = isStart;
        }
    }

    public void setConstruct(IConstruct<?> construct) {
        this.construct = construct;
    }

    public void setMutexManager(IMutexManager mutexManager) {
        this.mutexManager = mutexManager;
    }

    public void clearMoveTarget() {
        this.moveBlockTarget = null;
        this.moveEntityTarget = null;
    }

    public void setMoveTarget(BlockPos pos) {
        this.moveBlockTarget = pos;
        this.moveEntityTarget = null;
        if (pos != null) {
            this.construct.getDiagnostics().setMovePos(Vec3.m_82512_((Vec3i)pos));
        } else {
            this.construct.getDiagnostics().setMovePos(null);
        }
    }

    public void setMoveTarget(Entity entity) {
        this.moveBlockTarget = null;
        this.moveEntityTarget = entity;
        if (entity != null) {
            this.construct.getDiagnostics().pushTaskUpdate(this.id, this.guiIcon, IConstructDiagnostics.Status.RUNNING, entity.m_19879_());
        } else {
            this.construct.getDiagnostics().pushTaskUpdate(this.id, this.guiIcon, IConstructDiagnostics.Status.RUNNING, -1);
        }
    }

    public final void setOneOff(Player followWhenDone) {
        this.isOneOff = true;
        this.oneOffFollowTarget = followWhenDone != null && followWhenDone.m_36316_() != null ? followWhenDone.m_36316_().getId() : null;
    }

    public abstract void inflateParameters();

    public void onTaskSet() {
        this.exitCode = -1;
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
    }

    public void m_8037_() {
        if (this.moveCooldown > 0) {
            --this.moveCooldown;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.fleeCooldown > 0) {
            --this.fleeCooldown;
        }
        if (this.owner != null && !this.owner.m_6084_()) {
            this.owner = null;
        }
    }

    public boolean m_8036_() {
        if (this.construct == null) {
            return false;
        }
        if (!this.areCapabilitiesMet()) {
            this.confuseConstructCapsMissing();
            this.forceFail();
            return false;
        }
        return true;
    }

    public boolean m_8045_() {
        return !this.isFinished();
    }

    public void m_8056_() {
        if (this.construct != null) {
            this.owner = this.construct.getOwner();
        }
        this.hasStarted = true;
        this.construct.getDiagnostics().pushTaskUpdate(this.id, this.guiIcon, IConstructDiagnostics.Status.RUNNING, -1);
    }

    public boolean isFinished() {
        return this.exitCode >= 0;
    }

    public boolean isSuccess() {
        return this.exitCode == 0;
    }

    public void m_8041_() {
        super.m_8041_();
        this.hasStarted = false;
        this.releaseMutexes();
        if (this.exitCode == 1) {
            this.construct.getDiagnostics().pushTaskUpdate(this.id, this.guiIcon, IConstructDiagnostics.Status.FAILURE, -1);
        } else {
            this.construct.getDiagnostics().pushTaskUpdate(this.id, this.guiIcon, IConstructDiagnostics.Status.SUCCESS, -1);
        }
    }

    protected boolean claimBlockMutex(BlockPos pos) {
        if (this.getMutexManager() != null) {
            return this.getMutexManager().claimMutex(pos, this.construct, this);
        }
        return true;
    }

    protected void releaseBlockMutex(BlockPos pos) {
        if (this.getMutexManager() != null) {
            this.getMutexManager().releaseMutex(pos, this.construct, this);
        }
    }

    protected boolean claimEntityMutex(Entity entity) {
        if (this.getMutexManager() != null) {
            return this.getMutexManager().claimMutex(entity, this.construct, this);
        }
        return true;
    }

    protected void releaseEntityMutex(Entity entity) {
        if (this.getMutexManager() != null) {
            this.getMutexManager().releaseMutex(entity, this.construct, this);
        }
    }

    public void releaseMutexes() {
        if (this.getMutexManager() != null) {
            this.getMutexManager().releaseAllMutexes(this.construct, this);
        }
    }

    protected void pushDiagnosticMessage(String message, boolean allowDuplicates) {
        this.construct.pushDiagnosticMessage(message, this.guiIcon, allowDuplicates);
    }

    protected void pushDiagnosticMessage(Component message, boolean allowDuplicates) {
        this.pushDiagnosticMessage(message.m_214077_().toString(), allowDuplicates);
    }

    public void pushDiagnosticMessage(Component message) {
        this.pushDiagnosticMessage(message, false);
    }

    public void pushDiagnosticMessage(String message) {
        this.pushDiagnosticMessage(message, false);
    }

    public final void confuseConstructCapsMissing() {
        String cap = Arrays.asList(this.requiredCapabilities()).stream().map(c -> c.toString()).collect(Collectors.joining(", "));
        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.capability_missing", cap));
        this.construct.setConfused(100);
    }

    public final void confuseConstructLowIntelligence() {
        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.low_intelligence", new Object[0]));
        this.construct.setConfused(100);
    }

    public void insertOrDiscardItem(ItemStack stack) {
        int i;
        AbstractGolem c = this.getConstructAsEntity();
        int limit = this.getConstruct().getCarrySize();
        InteractionHand[] hands = this.getConstruct().getCarryingHands();
        for (i = 0; i < hands.length; ++i) {
            ItemStack carried = c.m_21120_(hands[i]);
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)carried)) continue;
            if (carried.m_41613_() + stack.m_41613_() <= limit) {
                carried.m_41764_(carried.m_41613_() + stack.m_41613_());
                return;
            }
            if (carried.m_41613_() >= limit) continue;
            int remaining = limit - carried.m_41613_();
            carried.m_41764_(limit);
            stack.m_41764_(remaining);
        }
        hands = this.getConstruct().getEmptyHands();
        for (i = 0; i < hands.length; ++i) {
            if (stack.m_41613_() <= limit) {
                c.m_21008_(hands[i], stack);
                return;
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(limit);
            stack.m_41764_(stack.m_41613_() - limit);
            c.m_21008_(hands[i], copy);
        }
        if (!stack.m_41619_() && this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.ITEM_STORAGE)) {
            ManaAndArtificeMod.getInventoryHelper().mergeIntoInventory((IItemHandler)this.construct, stack);
        }
    }

    public void insertOrDropItem(ItemStack stack) {
        int i;
        AbstractGolem c = this.getConstructAsEntity();
        int limit = this.getConstruct().getCarrySize();
        InteractionHand[] hands = this.getConstruct().getCarryingHands();
        for (i = 0; i < hands.length; ++i) {
            ItemStack carried = c.m_21120_(hands[i]);
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)carried)) continue;
            if (carried.m_41613_() + stack.m_41613_() <= limit) {
                carried.m_41764_(carried.m_41613_() + stack.m_41613_());
                return;
            }
            if (carried.m_41613_() >= limit) continue;
            int remaining = limit - carried.m_41613_();
            carried.m_41764_(limit);
            stack.m_41764_(remaining);
        }
        hands = this.getConstruct().getEmptyHands();
        for (i = 0; i < hands.length; ++i) {
            if (stack.m_41613_() <= limit) {
                c.m_21008_(hands[i], stack);
                return;
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(limit);
            stack.m_41764_(stack.m_41613_() - limit);
            c.m_21008_(hands[i], copy);
        }
        if (!(stack.m_41619_() || this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.ITEM_STORAGE) && ManaAndArtificeMod.getInventoryHelper().mergeIntoInventory((IItemHandler)this.construct, stack))) {
            ItemEntity drop = new ItemEntity(c.m_9236_(), c.m_20185_(), c.m_20186_(), c.m_20189_(), stack);
            drop.m_20334_(0.0, 0.25, 0.0);
            drop.m_32060_();
            c.m_9236_().m_7967_((Entity)drop);
        }
    }

    public List<ItemStack> getHeldItems() {
        AbstractGolem c = this.getConstructAsEntity();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!c.m_21205_().m_41619_()) {
            stacks.add(c.m_21205_());
        }
        if (!c.m_21206_().m_41619_()) {
            stacks.add(c.m_21206_());
        }
        return stacks;
    }

    protected List<ItemStack> getLootRoll(ResourceLocation lootTable, ItemStack tool, LootContextParamSet paramSet) {
        AbstractGolem c = this.construct.asEntity();
        LootParams lootparams = new LootParams.Builder((ServerLevel)c.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this.construct.asEntity()).m_287286_(LootContextParams.f_81460_, (Object)this.construct.asEntity().m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287235_(paramSet);
        LootTable loottable = c.m_9236_().m_7654_().m_278653_().m_278676_(lootTable);
        return loottable.m_287195_(lootparams);
    }

    protected void swingHandWithCapability(ConstructCapability cap) {
        this.construct.getHandWithCapability(ConstructCapability.SHEAR).ifPresent(h -> this.construct.asEntity().m_6674_(h));
    }

    public boolean doMove() {
        return this.doMove(2.5f);
    }

    public boolean doMove(float closeEnough) {
        if (this.moveEntityTarget != null && !this.moveEntityTarget.m_6084_()) {
            this.moveEntityTarget = null;
        }
        if (this.moveBlockTarget == null && this.moveEntityTarget == null) {
            return false;
        }
        Vec3 invPos = this.moveEntityTarget != null ? this.moveEntityTarget.m_20182_().m_82520_(0.0, 0.25, 0.0) : new Vec3((double)this.moveBlockTarget.m_123341_() + 0.5, (double)this.moveBlockTarget.m_123342_(), (double)this.moveBlockTarget.m_123343_() + 0.5);
        AbstractGolem c = this.getConstructAsEntity();
        this.construct.getDiagnostics().setMovePos(invPos);
        double dist = c.m_20238_(invPos);
        boolean movecomplete = false;
        if (dist > (double)(closeEnough * closeEnough)) {
            if (this.moveCooldown == 0 || c.m_21573_().m_26571_()) {
                movecomplete = this.moveEntityTarget != null ? this.setPathToEntity(this.moveEntityTarget, closeEnough) : this.setPathToXYZ(invPos, closeEnough);
                this.moveCooldown = 20;
            }
        } else {
            movecomplete = true;
        }
        if (movecomplete) {
            c.m_21573_().m_26573_();
            this.construct.getDiagnostics().setMovePos(null);
            return true;
        }
        return false;
    }

    protected final String translate(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args).getString();
    }

    protected final String translate(BlockEntity te) {
        if (te == null) {
            return "Null Tile Entity";
        }
        return this.translate(te.m_58900_());
    }

    protected final String translate(ItemStack stack) {
        return this.translate(stack.m_41778_(), new Object[0]);
    }

    protected final String translate(FluidStack stack) {
        return this.translate(stack.getTranslationKey(), new Object[0]);
    }

    protected final String translate(BlockState state) {
        if (state == null) {
            return "Null Block state";
        }
        return this.translate(state.m_60734_().m_7705_(), new Object[0]);
    }

    protected final String translate(Entity e) {
        if (e == null) {
            return "Null Entity";
        }
        return this.translate(e.m_6095_().m_20675_(), new Object[0]);
    }

    protected boolean setPathToEntity(Entity entity, float closeEnough) {
        if (this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.TELEPORT) && this.teleportCooldown <= 0) {
            return this.setPathToXYZ(entity.m_20182_(), closeEnough);
        }
        double dist = entity.m_20182_().m_82557_(this.construct.asEntity().m_20182_());
        if (dist < (double)(closeEnough * closeEnough)) {
            return true;
        }
        AbstractGolem c = this.getConstructAsEntity();
        c.m_7910_(Math.min((float)c.m_21133_(Attributes.f_22279_), 0.55f));
        if (!c.m_21573_().m_5624_(entity, (double)c.m_6113_())) {
            if (c.m_21573_().m_26571_()) {
                return true;
            }
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.move_entity_fail", this.translate(entity)), false);
        }
        return false;
    }

    protected boolean setPathToXYZ(Vec3 pos, float closeEnough) {
        AbstractGolem c = this.getConstructAsEntity();
        double dist = pos.m_82557_(c.m_20182_());
        if (dist < (double)(closeEnough * closeEnough)) {
            return true;
        }
        if (this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.TELEPORT) && this.teleportCooldown <= 0) {
            Vec3 targetPos = pos.m_82549_(this.construct.asEntity().m_20182_().m_82546_(pos).m_82541_().m_82490_((double)(closeEnough * 0.95f)));
            if (dist > 36.0 || this.construct.asEntity().f_19862_ || c.m_9236_().m_45547_(new ClipContext(c.m_146892_(), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)c)).m_6662_() != HitResult.Type.MISS) {
                this.teleportCooldown = this.getInteractTime(ConstructCapability.TELEPORT);
                BlockHitResult bhr = c.m_9236_().m_45547_(new ClipContext(targetPos.m_82520_(0.0, 2.0, 0.0), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)c));
                Vec3 teleportPos = targetPos;
                boolean canTeleport = true;
                if (bhr != null && bhr.m_6662_() != HitResult.Type.MISS) {
                    BlockPos bp = BlockPos.m_274446_((Position)bhr.m_82450_());
                    if (bhr.m_82436_() || !this.isTeleportDestinationValid(c, bp)) {
                        canTeleport = false;
                        for (int xShift = 0; xShift <= 2 && !canTeleport; ++xShift) {
                            block1: for (int yShift = -1; yShift <= 1; ++yShift) {
                                for (int zShift = 0; zShift <= 2; ++zShift) {
                                    if (xShift == 0 && zShift == 0 || (bhr = c.m_9236_().m_45547_(new ClipContext(targetPos.m_82520_((double)xShift, (double)(2 + yShift), (double)zShift), targetPos.m_82520_((double)xShift, (double)yShift, (double)zShift), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)c))) == null || !this.isTeleportDestinationValid(c, bp = BlockPos.m_274446_((Position)bhr.m_82450_()))) continue;
                                    teleportPos = bhr.m_82450_();
                                    canTeleport = true;
                                    continue block1;
                                }
                            }
                        }
                    } else {
                        teleportPos = bhr.m_82450_();
                    }
                }
                if (canTeleport) {
                    c.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
                    c.m_9236_().m_6263_((Player)null, c.f_19854_, c.f_19855_, c.f_19856_, SoundEvents.f_11852_, c.m_5720_(), 0.01f, 1.0f);
                    c.m_5496_(SoundEvents.f_11852_, 0.1f, 1.0f);
                    c.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.move_block_success", Math.floor(pos.f_82479_ * 100.0) / 100.0, Math.floor(pos.f_82480_ * 100.0) / 100.0, Math.floor(pos.f_82481_ * 100.0) / 100.0), false);
                    return true;
                }
            }
        }
        c.m_7910_(Math.min((float)c.m_21133_(Attributes.f_22279_), 0.55f));
        if (!c.m_21573_().m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)c.m_6113_())) {
            double[] dists;
            if (c.m_21573_().m_26571_()) {
                return true;
            }
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.move_block_fail", Math.floor(pos.f_82479_ * 100.0) / 100.0, Math.floor(pos.f_82480_ * 100.0) / 100.0, Math.floor(pos.f_82481_ * 100.0) / 100.0), false);
            BlockPos blockPos = BlockPos.m_274446_((Position)pos);
            for (double bpDist : dists = new double[]{blockPos.m_203193_((Position)pos), blockPos.m_7918_(1, 0, 0).m_203193_((Position)pos), blockPos.m_7918_(0, 0, 1).m_203193_((Position)pos), blockPos.m_7918_(1, 0, 1).m_203193_((Position)pos)}) {
                if (!(bpDist <= (double)closeEnough)) continue;
                return true;
            }
            c.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
            c.m_6478_(MoverType.SELF, pos.m_82546_(c.m_20182_()).m_82541_().m_82490_((double)((float)c.m_21133_(Attributes.f_22279_))));
        }
        return false;
    }

    protected final boolean isTeleportDestinationValid(AbstractGolem c, BlockPos pos) {
        return c.m_9236_().m_45556_(new AABB(pos, pos.m_7494_())).allMatch(state -> state.m_60795_());
    }

    protected boolean doAttack() {
        this.moveEntityTarget = this.construct.asEntity().m_5448_();
        int ranged_result = this.doRangedAttack();
        if (ranged_result != -1) {
            return ranged_result != 0;
        }
        return this.doMeleeAttack();
    }

    private boolean doMeleeAttack() {
        if (!this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.MELEE_ATTACK)) {
            return true;
        }
        if (this.moveEntityTarget instanceof LivingEntity && this.construct.validateFriendlyTarget((LivingEntity)this.moveEntityTarget)) {
            this.construct.asEntity().m_6710_(null);
            return true;
        }
        if (this.doMove(2.0f) && this.attackCooldown <= 0 && this.construct.getAttackDelay() <= 0) {
            this.construct.asEntity().m_21391_((Entity)this.construct.asEntity().m_5448_(), 10.0f, 10.0f);
            this.construct.getHandWithCapability(ConstructCapability.MELEE_ATTACK).ifPresent(h -> {
                if (this.construct.canDualSweep() && Math.random() < 0.25) {
                    this.construct.setDualSweeping();
                    DelayedEventQueue.pushEvent(this.construct.asEntity().m_9236_(), new TimedDelayedEvent<Entity>("attack", 8, this.moveEntityTarget, this::meleeSweepCallback));
                } else {
                    this.construct.asEntity().m_6674_(h);
                    DelayedEventQueue.pushEvent(this.construct.asEntity().m_9236_(), new TimedDelayedEvent<Entity>("attack", 8, this.moveEntityTarget, this::meleeAttackCallback));
                }
            });
            return true;
        }
        return false;
    }

    private void meleeAttackCallback(String identifier, Entity target) {
        if (target == null) {
            return;
        }
        this.attackCooldown = 10;
        this.construct.asEntity().m_7327_(target);
    }

    private void meleeSweepCallback(String identifier, Entity target) {
        if (target == null) {
            return;
        }
        this.attackCooldown = 10;
        AbstractGolem c = this.construct.asEntity();
        for (LivingEntity livingentity : c.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(2.0, 0.25, 2.0))) {
            if (livingentity == c || c.m_7307_((Entity)livingentity) || !(c.m_20280_((Entity)livingentity) < 9.0)) continue;
            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(c.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(c.m_146908_() * ((float)Math.PI / 180)))));
            c.m_7327_((Entity)livingentity);
        }
        c.m_9236_().m_6263_((Player)null, c.m_20185_(), c.m_20186_(), c.m_20189_(), SoundEvents.f_12317_, c.m_5720_(), 1.0f, 1.0f);
        if (c.m_9236_() instanceof ServerLevel) {
            double d0 = -Mth.m_14031_((float)(c.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(c.m_146908_() * ((float)Math.PI / 180)));
            ((ServerLevel)c.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, c.m_20185_() + d0, c.m_20227_(0.5), c.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    private int doRangedAttack() {
        if (!(this.construct.isRangedAttacking() || this.construct.canManaCannonAttack() || this.construct.canFluidSpray() || this.construct.canSpellCast())) {
            return -1;
        }
        AbstractGolem constructEntity = this.construct.asEntity();
        LivingEntity target = constructEntity.m_5448_();
        double dist = constructEntity.m_20270_((Entity)target);
        if (target != this.construct.getOwner() && dist < 2.0 && this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.MELEE_ATTACK)) {
            return -1;
        }
        int closeEnoughDist = 16;
        if (this.construct.canFluidSpray()) {
            closeEnoughDist = 6;
        }
        if ((this.fleeCooldown == 0 || constructEntity.m_21573_().m_26571_()) && this.doMove(closeEnoughDist)) {
            this.construct.asEntity().m_21563_().m_148051_((Entity)this.construct.asEntity().m_5448_());
            if (this.construct.getAttackDelay() <= 0 && this.construct.asEntity().m_21563_().m_186069_() && this.construct.performRangedAttack(this.construct.asEntity().m_5448_())) {
                return 1;
            }
        }
        return 0;
    }

    public abstract boolean isFullyConfigured();

    protected void faceBlockPos(BlockPos pos) {
        AbstractGolem c = this.getConstructAsEntity();
        double d0 = (double)pos.m_123341_() + 0.5 - c.m_20185_();
        double d2 = (double)pos.m_123343_() + 0.5 - c.m_20189_();
        double d1 = (double)pos.m_123342_() + 0.5;
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        c.f_19860_ = c.m_146909_();
        c.m_146926_(this.updateRotation(c.m_146909_(), f1, 30.0f));
        c.f_19859_ = c.m_146908_();
        c.m_146922_(this.updateRotation(c.m_146908_(), f, 30.0f));
        c.f_20884_ = c.m_6080_();
        c.m_5616_(this.updateRotation(c.m_146908_(), f, 30.0f));
    }

    private float updateRotation(float start, float end, float step) {
        float f = Mth.m_14177_((float)(end - start));
        if (f > step) {
            f = step;
        }
        if (f < -step) {
            f = -step;
        }
        return start + f;
    }

    public boolean m_183429_() {
        return true;
    }

    public abstract T copyFrom(ConstructAITask<?> var1);

    public final void copyConnections(ConstructAITask<?> other) {
        this.connections.clear();
        other.connections.forEach((k, v) -> this.connections.put((Integer)k, (String)v));
    }

    public abstract void readNBT(CompoundTag var1);

    public final CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", this.getType().toString());
        this.writeInternal(nbt);
        return nbt;
    }

    protected abstract CompoundTag writeInternal(CompoundTag var1);

    public abstract T duplicate();

    public final void loadParameterData(ListTag list) {
        if (!list.isEmpty() && list.m_7264_() != 10) {
            ManaAndArtificeMod.LOGGER.warn("M&A >> construct parameters were not a list of NBT tags; skipping.  This task will be unconfigured.");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i >= this._parameters.size()) {
                return;
            }
            this._parameters.get(i).loadData(list.m_128728_(i));
        }
    }

    public final ListTag saveParameterData() {
        ListTag list = new ListTag();
        this._parameters.forEach(p -> list.add((Object)p.saveData()));
        return list;
    }

    public final void loadConnections(ListTag list) {
        list.forEach(t -> {
            CompoundTag connection;
            if (t instanceof CompoundTag && (connection = (CompoundTag)t).m_128441_("index") && connection.m_128441_("target")) {
                String id = connection.m_128461_("target");
                int index = connection.m_128451_("index");
                this.connections.put(index, id);
            }
        });
    }

    protected List<ConstructAITaskParameter> instantiateParameters() {
        return new ArrayList<ConstructAITaskParameter>();
    }

    public List<ConstructAITaskParameter> getParameters() {
        return this._parameters;
    }

    public static final ConstructTask getTypeFromNBT(CompoundTag nbt) {
        if (nbt.m_128425_("type", 8)) {
            ResourceLocation id = new ResourceLocation(nbt.m_128461_("type"));
            ConstructTask task = (ConstructTask)ManaAndArtificeMod.getConstructTaskRegistry().getValue(id);
            if (task != null) {
                return task;
            }
        }
        return (ConstructTask)ManaAndArtificeMod.getConstructTaskRegistry().getValue(new ResourceLocation("mna", "stay"));
    }

    public String getNextTask() {
        return this.connections.getOrDefault(this.exitCode, null);
    }

    public void forceFail() {
        this.exitCode = 1;
    }

    public void setSuccessCode() {
        this.exitCode = 0;
    }
}

