/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.PotionPylonBlock;
import com.mna.api.blocks.tile.pylon.PylonTileBase;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionEffectPylonTile
extends PylonTileBase {
    private ResourceLocation cachedIcon;

    public PotionEffectPylonTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public PotionEffectPylonTile(BlockPos pPos, BlockState pBlockState) {
        super(ManaAndArtificeMod.getTileHelper().getPotionPylonTileType(), pPos, pBlockState);
    }

    @Override
    protected PotionPylonBlock getBlock() {
        return (PotionPylonBlock)this.m_58900_().m_60734_();
    }

    protected MobEffect getMobEffect() {
        return this.getBlock().getEffect();
    }

    @Override
    public ResourceLocation getIcon() {
        if (this.cachedIcon == null) {
            ResourceLocation effectKey = ForgeRegistries.MOB_EFFECTS.getKey((Object)this.getMobEffect());
            this.cachedIcon = effectKey != null ? new ResourceLocation(effectKey.m_135827_(), "textures/mob_effect/" + effectKey.m_135815_() + ".png") : new ResourceLocation("");
        }
        return this.cachedIcon;
    }

    @Override
    public int[] getColor() {
        int clrPacked = this.getMobEffect().m_19484_();
        if (clrPacked != 0) {
            return new int[]{FastColor.ARGB32.m_13665_((int)clrPacked), FastColor.ARGB32.m_13667_((int)clrPacked), FastColor.ARGB32.m_13669_((int)clrPacked)};
        }
        return super.getColor();
    }

    protected int getAmplifier() {
        return this.getBlock().getAmplifier();
    }

    protected int getDuration() {
        return this.getBlock().getDuration();
    }

    protected int getReapplicationThreshold() {
        return this.getBlock().getReapplicationThreshold();
    }

    protected boolean applyAsAmbient() {
        return true;
    }

    protected boolean effectVisible() {
        return true;
    }

    @Override
    protected HashMap<Affinity, Float> getPowerConsumption() {
        return this.getBlock().getPowerConsumption();
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, PotionEffectPylonTile tile) {
        if (tile.getMobEffect() == null) {
            return;
        }
        if (tile.tick()) {
            int n = tile.powerUpTicks;
            Objects.requireNonNull(tile);
            if (n == 60 && level.m_46467_() % 20L == 0L) {
                tile.forAllPlayers(false, p -> {
                    MobEffectInstance existing = p.m_21124_(tile.getMobEffect());
                    if (existing == null || existing.m_267633_(tile.getReapplicationThreshold())) {
                        p.m_7292_(new MobEffectInstance(tile.getMobEffect(), tile.getDuration(), tile.getAmplifier(), tile.applyAsAmbient(), false, tile.effectVisible()));
                    }
                });
            }
        }
    }
}

