/*
 * Decompiled with CFR 0.152.
 */
package com.mna.advancements.triggers;

import com.google.gson.JsonObject;
import com.mna.api.tools.RLoc;
import java.util.ArrayList;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class CompleteMultiblockTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RLoc.create("multiblock_complete");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        ArrayList<ResourceLocation> structureIDs = new ArrayList<ResourceLocation>();
        if (json.has("multiblockIDs") && json.get("multiblockIDs").isJsonArray()) {
            json.get("multiblockIDs").getAsJsonArray().forEach(e -> structureIDs.add(new ResourceLocation(e.getAsString())));
        }
        return new Instance(entityPredicate, structureIDs);
    }

    public void trigger(ServerPlayer player, ResourceLocation structureID) {
        this.m_66234_(player, instance -> instance.matches(structureID));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ArrayList<ResourceLocation> structureIDs;

        public Instance(ContextAwarePredicate player, ArrayList<ResourceLocation> structureIDs) {
            super(ID, player);
            this.structureIDs = structureIDs;
        }

        public boolean matches(ResourceLocation structureID) {
            if (this.structureIDs != null && this.structureIDs.size() > 0) {
                return this.structureIDs.contains(structureID);
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            return jsonobject;
        }
    }
}

