/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.yaml;

import endorh.simpleconfig.core.PairList;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.DumperOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Node;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.NodeTuple;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.ScalarNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.SequenceNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Tag;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.representer.Represent;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.representer.Representer;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionWrapper;
import endorh.simpleconfig.yaml.FlowList;
import endorh.simpleconfig.yaml.SimpleConfigYamlConstructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SimpleConfigYamlRepresenter
extends Representer {
    private boolean representPairsAsSequences = true;

    public SimpleConfigYamlRepresenter() {
        this.init();
    }

    public SimpleConfigYamlRepresenter(DumperOptions options) {
        super(options);
        this.init();
    }

    private void init() {
        this.multiRepresenters.put(Pair.class, new RepresentPair());
        this.multiRepresenters.put(Triple.class, new RepresentTriple());
        Represent list = (Represent)this.multiRepresenters.remove(List.class);
        this.multiRepresenters.put(PairList.class, new RepresentPairList());
        this.multiRepresenters.put(List.class, list);
        this.multiRepresenters.put(HotKeyActionWrapper.class, new RepresentHotKeyActionWrapper());
    }

    @Override
    protected Node representSequence(Tag tag, Iterable<?> sequence, DumperOptions.FlowStyle flowStyle) {
        if (sequence instanceof FlowList) {
            flowStyle = DumperOptions.FlowStyle.FLOW;
        }
        return super.representSequence(tag, sequence, flowStyle);
    }

    public SequenceNode representSortedMapping(Tag tag, Iterable<? extends Map.Entry<?, ?>> map, DumperOptions.FlowStyle flowStyle) {
        if (flowStyle == DumperOptions.FlowStyle.AUTO) {
            flowStyle = DumperOptions.FlowStyle.BLOCK;
        }
        int size = map instanceof List ? ((List)map).size() : 10;
        ArrayList<Node> nodes = new ArrayList<Node>(size);
        SequenceNode node = new SequenceNode(tag, nodes, flowStyle);
        for (Map.Entry<?, ?> entry : map) {
            Node keyNode = this.representData(entry.getKey());
            Node valueNode = this.representData(entry.getValue());
            NodeTuple tuple = new NodeTuple(keyNode, valueNode);
            MappingNode mapping = new MappingNode(Tag.MAP, Collections.singletonList(tuple), flowStyle);
            nodes.add(mapping);
        }
        return node;
    }

    public boolean isRepresentPairsAsSequences() {
        return this.representPairsAsSequences;
    }

    public void setRepresentPairsAsSequences(boolean representPairsAsSequences) {
        this.representPairsAsSequences = representPairsAsSequences;
    }

    public class RepresentPair
    implements Represent {
        @Override
        public Node representData(Object data) {
            Pair pair = (Pair)data;
            return SimpleConfigYamlRepresenter.this.representSequence(SimpleConfigYamlRepresenter.this.representPairsAsSequences ? Tag.SEQ : SimpleConfigYamlConstructor.PAIR, (Iterable<?>)((Object)FlowList.wrap(Arrays.asList(pair.getLeft(), pair.getRight()))), DumperOptions.FlowStyle.FLOW);
        }
    }

    public class RepresentTriple
    implements Represent {
        @Override
        public Node representData(Object data) {
            Triple triple = (Triple)data;
            return SimpleConfigYamlRepresenter.this.representSequence(SimpleConfigYamlRepresenter.this.representPairsAsSequences ? Tag.SEQ : SimpleConfigYamlConstructor.TRIPLE, (Iterable<?>)((Object)FlowList.wrap(Arrays.asList(triple.getLeft(), triple.getMiddle(), triple.getRight()))), DumperOptions.FlowStyle.FLOW);
        }
    }

    public class RepresentPairList
    implements Represent {
        @Override
        public Node representData(Object data) {
            PairList list = (PairList)((Object)data);
            return SimpleConfigYamlRepresenter.this.representSortedMapping(Tag.PAIRS, (Iterable<? extends Map.Entry<?, ?>>)((Object)list), DumperOptions.FlowStyle.BLOCK);
        }
    }

    public class RepresentHotKeyActionWrapper
    implements Represent {
        @Override
        public Node representData(Object data) {
            ScalarNode scalar;
            HotKeyActionWrapper wrapper = (HotKeyActionWrapper)data;
            HotKeyActionType type = wrapper.type();
            Tag tag = type.getTag();
            Object value = wrapper.value();
            if (value == null) {
                return new SequenceNode(tag, Collections.emptyList(), DumperOptions.FlowStyle.FLOW);
            }
            Node node = SimpleConfigYamlRepresenter.this.representData(value);
            DumperOptions.FlowStyle style = DumperOptions.FlowStyle.BLOCK;
            if (node instanceof ScalarNode && ((scalar = (ScalarNode)node).getScalarStyle() == DumperOptions.ScalarStyle.PLAIN || scalar.getScalarStyle() == DumperOptions.ScalarStyle.SINGLE_QUOTED)) {
                style = DumperOptions.FlowStyle.FLOW;
            }
            return new SequenceNode(tag, Collections.singletonList(node), style);
        }
    }
}

