/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.yaml;

import endorh.simpleconfig.core.PairList;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.DumperOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.LoaderOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.constructor.AbstractConstruct;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.constructor.Construct;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.constructor.Constructor;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.Mark;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.MarkedYAMLException;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Node;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.SequenceNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Tag;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypeManager;
import endorh.simpleconfig.ui.hotkey.HotKeyActionWrapper;
import endorh.simpleconfig.yaml.FlowList;
import endorh.simpleconfig.yaml.NonConfigMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SimpleConfigYamlConstructor
extends Constructor {
    public static final Tag PAIR = new Tag("!pair");
    public static final Tag TRIPLE = new Tag("!triple");

    public SimpleConfigYamlConstructor() {
        this.init();
    }

    public SimpleConfigYamlConstructor(LoaderOptions loadingConfig) {
        super(loadingConfig);
        this.init();
    }

    private void init() {
        this.yamlConstructors.put(Tag.PAIRS, new ConstructPairList());
        this.yamlConstructors.put(PAIR, new ConstructPair());
        this.yamlConstructors.put(TRIPLE, new ConstructTriple());
    }

    @Override
    protected Construct getConstructor(Node node) {
        HotKeyActionType<?, ?> type;
        if (!node.useClassConstructor() && (type = HotKeyActionTypeManager.INSTANCE.getType(node.getTag())) != null) {
            return new ConstructHotKeyActionWrapper(type);
        }
        return super.getConstructor(node);
    }

    @Override
    protected Map<Object, Object> constructMapping(MappingNode node) {
        Map<Object, Object> map = super.constructMapping(node);
        if (map.keySet().stream().anyMatch(k -> !(k instanceof String))) {
            return NonConfigMap.wrap(map);
        }
        return map;
    }

    protected List<?> constructSequence(SequenceNode node) {
        List<? extends Object> list = super.constructSequence(node);
        if (node.getFlowStyle() == DumperOptions.FlowStyle.FLOW) {
            return FlowList.wrap(list);
        }
        return list;
    }

    public class ConstructPairList
    extends AbstractConstruct {
        @Override
        public Object construct(Node node) {
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a sequence, but found " + node.getNodeId(), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            PairList pairs = new PairList(snode.getValue().size());
            for (Node subNode : snode.getValue()) {
                if (!(subNode instanceof MappingNode)) {
                    throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a mapping of length 1, but found " + subNode.getNodeId(), subNode.getStartMark());
                }
                MappingNode mNode = (MappingNode)subNode;
                if (mNode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a single mapping item, but found " + mNode.getValue().size() + " items", mNode.getStartMark());
                }
                Node keyNode = mNode.getValue().get(0).getKeyNode();
                Node valueNode = mNode.getValue().get(0).getValueNode();
                Object key = SimpleConfigYamlConstructor.this.constructObject(keyNode);
                Object value = SimpleConfigYamlConstructor.this.constructObject(valueNode);
                pairs.add(Pair.of((Object)key, (Object)value));
            }
            return pairs;
        }
    }

    public class ConstructPair
    extends AbstractConstruct {
        @Override
        public Object construct(Node node) {
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing a pair", node.getStartMark(), "expected a sequence, but found " + node.getNodeId(), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            List<Node> values = snode.getValue();
            if (values.size() != 2) {
                throw new ConstructorException("while constructing a pair", node.getStartMark(), "expected a sequence of length 2, but length was " + values.size(), node.getStartMark());
            }
            return Pair.of((Object)SimpleConfigYamlConstructor.this.constructObject(values.get(0)), (Object)SimpleConfigYamlConstructor.this.constructObject(values.get(1)));
        }
    }

    public class ConstructTriple
    extends AbstractConstruct {
        @Override
        public Object construct(Node node) {
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing a triple", node.getStartMark(), "expected a sequence, but found " + node.getNodeId(), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            List<Node> values = snode.getValue();
            if (values.size() != 3) {
                throw new ConstructorException("while constructing a triple", node.getStartMark(), "expected a sequence of length 3, but length was " + values.size(), node.getStartMark());
            }
            return Triple.of((Object)SimpleConfigYamlConstructor.this.constructObject(values.get(0)), (Object)SimpleConfigYamlConstructor.this.constructObject(values.get(1)), (Object)SimpleConfigYamlConstructor.this.constructObject(values.get(2)));
        }
    }

    public class ConstructHotKeyActionWrapper<T, A extends HotKeyAction<T>>
    extends AbstractConstruct {
        private final HotKeyActionType<T, A> type;

        public ConstructHotKeyActionWrapper(HotKeyActionType<T, A> type) {
            this.type = type;
        }

        @Override
        public Object construct(Node node) {
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing hotkey wrapper", node.getStartMark(), "expected a sequence, but found " + node.getNodeId(), node.getStartMark());
            }
            SequenceNode seq = (SequenceNode)node;
            List<Node> nodes = seq.getValue();
            if (nodes.size() > 1) {
                throw new ConstructorException("while constructing hotkey wrapper", node.getStartMark(), "expected a sequence empty or of length 1, but found size" + nodes.size(), node.getStartMark());
            }
            Object value = nodes.isEmpty() ? null : SimpleConfigYamlConstructor.this.constructObject(nodes.get(0));
            return new HotKeyActionWrapper<T, A>(this.type, value);
        }
    }

    public static class ConstructorException
    extends MarkedYAMLException {
        public ConstructorException(String context, Mark contextMark, String problem, Mark problemMark, Throwable cause) {
            super(context, contextMark, problem, problemMark, cause);
        }

        public ConstructorException(String context, Mark contextMark, String problem, Mark problemMark) {
            this(context, contextMark, problem, problemMark, (Throwable)null);
        }
    }
}

