/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.yaml;

import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.core.io.WritingException;
import com.electronwill.nightconfig.core.utils.TransformingMap;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.comments.CommentLine;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.comments.CommentType;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.Mark;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Node;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.NodeTuple;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.ScalarNode;
import endorh.simpleconfig.yaml.NodeComments;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.io.Writer;
import java.util.Map;

public class SimpleConfigCommentedYamlWriter
implements ConfigWriter {
    private final SimpleConfigCommentedYamlFormat format;
    private final Yaml yaml;
    private final SimpleConfigImpl config;
    private boolean generateComments = true;

    public SimpleConfigCommentedYamlWriter(SimpleConfigCommentedYamlFormat format) {
        this.format = format;
        this.yaml = format.getYaml();
        this.config = format.getSimpleConfig();
    }

    public void write(UnmodifiableConfig config, Writer writer) {
        try {
            Map<String, Object> unwrappedMap = SimpleConfigCommentedYamlWriter.unwrap(config);
            Node node = this.yaml.represent(unwrappedMap);
            if (this.config != null && this.isGenerateComments()) {
                this.attachYamlComments(node, this.config.getComments());
            }
            this.yaml.serialize(node, writer);
        }
        catch (RuntimeException e) {
            throw new WritingException("YAML writing failed", (Throwable)e);
        }
    }

    public void attachYamlComments(Node root, Map<String, NodeComments> comments) {
        NodeComments rootComments = comments.get("");
        if (rootComments != null) {
            rootComments.apply(root);
        }
        if (root instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)root;
            for (NodeTuple tuple : mappingNode.getValue()) {
                Node keyNode = tuple.getKeyNode();
                if (!(keyNode instanceof ScalarNode)) continue;
                String key = ((ScalarNode)keyNode).getValue();
                this.attachChildYamlComments(key, tuple, comments);
            }
        }
    }

    public void attachChildYamlComments(String path, NodeTuple tuple, Map<String, NodeComments> comments) {
        Node value;
        NodeComments nodeComments = comments.get(path);
        if (nodeComments != null) {
            nodeComments.apply(tuple);
        }
        if ((value = tuple.getValueNode()) instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)value;
            for (NodeTuple childTuple : mappingNode.getValue()) {
                Node childKeyNode = childTuple.getKeyNode();
                if (!(childKeyNode instanceof ScalarNode)) continue;
                String childKey = ((ScalarNode)childKeyNode).getValue();
                this.attachChildYamlComments(path + "." + childKey, childTuple, comments);
            }
        }
    }

    private static Mark dummyMark() {
        return new Mark("generated", 0, 0, 0, new int[0], 0);
    }

    public static CommentLine commentLine(String line) {
        return new CommentLine(SimpleConfigCommentedYamlWriter.dummyMark(), SimpleConfigCommentedYamlWriter.dummyMark(), line, CommentType.BLOCK);
    }

    public static CommentLine blankLine() {
        return new CommentLine(SimpleConfigCommentedYamlWriter.dummyMark(), SimpleConfigCommentedYamlWriter.dummyMark(), "", CommentType.BLANK_LINE);
    }

    private static Map<String, Object> unwrap(UnmodifiableConfig config) {
        return new TransformingMap(config.valueMap(), SimpleConfigCommentedYamlWriter::unwrap, v -> v, v -> v);
    }

    private static Object unwrap(Object value) {
        if (value instanceof UnmodifiableConfig) {
            return SimpleConfigCommentedYamlWriter.unwrap((UnmodifiableConfig)value);
        }
        return value == NullObject.NULL_OBJECT ? null : value;
    }

    public boolean isGenerateComments() {
        return this.generateComments;
    }

    public void setGenerateComments(boolean generateComments) {
        this.generateComments = generateComments;
    }
}

