/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.yaml;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.core.utils.TransformingMap;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Node;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.NodeTuple;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.ScalarNode;
import endorh.simpleconfig.yaml.NodeComments;
import endorh.simpleconfig.yaml.NonConfigMap;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class SimpleConfigCommentedYamlParser
implements ConfigParser<CommentedConfig> {
    private final Yaml yaml;
    private final ConfigFormat<CommentedConfig> configFormat;
    private final SimpleConfigImpl config;
    private boolean parseComments = true;

    public SimpleConfigCommentedYamlParser(SimpleConfigCommentedYamlFormat format) {
        this.yaml = format.getYaml();
        this.configFormat = format;
        this.config = format.getSimpleConfig();
    }

    public ConfigFormat<CommentedConfig> getFormat() {
        return this.configFormat;
    }

    public CommentedConfig parse(Reader reader) {
        CommentedConfig config = (CommentedConfig)this.configFormat.createConfig();
        this.parse(reader, (Config)config, ParsingMode.MERGE);
        return config;
    }

    public void parse(Reader reader, Config destination, ParsingMode parsingMode) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((Reader)reader, (OutputStream)bos, (Charset)StandardCharsets.UTF_8);
            byte[] bytes = bos.toByteArray();
            BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
            Map<String, Object> wrappedMap = this.wrap(this.yaml.loadAs(r, Map.class));
            parsingMode.prepareParsing(destination);
            if (parsingMode == ParsingMode.ADD) {
                for (Map.Entry<String, Object> entry : wrappedMap.entrySet()) {
                    destination.valueMap().putIfAbsent(entry.getKey(), entry.getValue());
                }
            } else {
                destination.valueMap().putAll(wrappedMap);
            }
            if (this.config != null && this.isParseComments()) {
                r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
                Map<String, NodeComments> comments = this.parseYamlComments(this.yaml.compose(r));
                this.config.loadComments(comments);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new ParsingException("YAML parsing failed", (Throwable)e);
        }
    }

    public Map<String, NodeComments> parseYamlComments(Node node) {
        HashMap<String, NodeComments> map = new HashMap<String, NodeComments>();
        if (node != null) {
            NodeComments rootComments = NodeComments.from(node);
            if (rootComments.isNotEmpty()) {
                map.put("", rootComments);
            }
            if (node instanceof MappingNode) {
                MappingNode mNode = (MappingNode)node;
                for (NodeTuple tuple : mNode.getValue()) {
                    Node keyNode = tuple.getKeyNode();
                    if (!(keyNode instanceof ScalarNode)) continue;
                    String key = ((ScalarNode)keyNode).getValue();
                    this.readChildYamlComments(key, tuple, map);
                }
            }
        }
        return map;
    }

    public void readChildYamlComments(String path, NodeTuple tuple, Map<String, NodeComments> destination) {
        Node valueNode;
        NodeComments comments = NodeComments.from(tuple);
        if (comments.isNotEmpty()) {
            destination.put(path, comments);
        }
        if ((valueNode = tuple.getValueNode()) instanceof MappingNode) {
            MappingNode mNode = (MappingNode)valueNode;
            for (NodeTuple childTuple : mNode.getValue()) {
                Node childKeyNode = childTuple.getKeyNode();
                if (!(childKeyNode instanceof ScalarNode)) continue;
                String childKey = ((ScalarNode)childKeyNode).getValue();
                this.readChildYamlComments(path + "." + childKey, childTuple, destination);
            }
        }
    }

    private Map<String, Object> wrap(Map<String, Object> map) {
        return new TransformingMap(map != null ? map : new LinkedHashMap(), this::wrap, v -> v, v -> v);
    }

    private Object wrap(Object value) {
        if (value instanceof Map && !(value instanceof NonConfigMap)) {
            Map<String, Object> map = this.wrap((Map)value);
            return CommentedConfig.wrap(map, this.configFormat);
        }
        return value == null ? NullObject.NULL_OBJECT : value;
    }

    public boolean isParseComments() {
        return this.parseComments;
    }

    public void setParseComments(boolean parseComments) {
        this.parseComments = parseComments;
    }
}

