/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.yaml;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.DumperOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.LoaderOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.constructor.BaseConstructor;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.constructor.Constructor;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.representer.Representer;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlParser;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlWriter;
import endorh.simpleconfig.yaml.SimpleConfigYamlConstructor;
import endorh.simpleconfig.yaml.SimpleConfigYamlRepresenter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SimpleConfigCommentedYamlFormat
implements ConfigFormat<CommentedConfig> {
    public static final ThreadLocal<DumperOptions> DEFAULT_DUMPER_OPTIONS = ThreadLocal.withInitial(() -> {
        DumperOptions dump = new DumperOptions();
        dump.setProcessComments(true);
        dump.setIndent(2);
        dump.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return dump;
    });
    public static final ThreadLocal<LoaderOptions> DEFAULT_LOADER_OPTIONS = ThreadLocal.withInitial(() -> {
        LoaderOptions load = new LoaderOptions();
        load.setProcessComments(true);
        load.setAllowDuplicateKeys(false);
        return load;
    });
    public static final ThreadLocal<Constructor> DEFAULT_CONSTRUCTOR = ThreadLocal.withInitial(() -> new SimpleConfigYamlConstructor(DEFAULT_LOADER_OPTIONS.get()));
    public static final ThreadLocal<Representer> DEFAULT_REPRESENTER = ThreadLocal.withInitial(() -> new SimpleConfigYamlRepresenter(DEFAULT_DUMPER_OPTIONS.get()));
    public static final ThreadLocal<Yaml> DEFAULT_YAML = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)DEFAULT_CONSTRUCTOR.get(), DEFAULT_REPRESENTER.get(), DEFAULT_DUMPER_OPTIONS.get(), DEFAULT_LOADER_OPTIONS.get()));
    public static final ThreadLocal<SimpleConfigCommentedYamlFormat> WITHOUT_COMMENTS = ThreadLocal.withInitial(() -> new SimpleConfigCommentedYamlFormat(DEFAULT_YAML.get(), null));
    private final Yaml yaml;
    private final SimpleConfigImpl config;

    public static SimpleConfigCommentedYamlFormat forConfig(SimpleConfigImpl config) {
        return new SimpleConfigCommentedYamlFormat(DEFAULT_YAML.get(), config);
    }

    public static SimpleConfigCommentedYamlFormat withoutComments() {
        return WITHOUT_COMMENTS.get();
    }

    public static Yaml getDefaultYaml() {
        return DEFAULT_YAML.get();
    }

    public static void registerExtension() {
    }

    private SimpleConfigCommentedYamlFormat(Yaml yaml, SimpleConfigImpl config) {
        this.yaml = yaml;
        this.config = config;
    }

    public SimpleConfigImpl getSimpleConfig() {
        return this.config;
    }

    public SimpleConfigCommentedYamlWriter createWriter() {
        return new SimpleConfigCommentedYamlWriter(this);
    }

    public SimpleConfigCommentedYamlWriter createWriter(boolean generateComments) {
        SimpleConfigCommentedYamlWriter writer = this.createWriter();
        writer.setGenerateComments(generateComments);
        return writer;
    }

    public SimpleConfigCommentedYamlParser createParser() {
        return new SimpleConfigCommentedYamlParser(this);
    }

    public SimpleConfigCommentedYamlParser createParser(boolean parseComments) {
        SimpleConfigCommentedYamlParser parser = this.createParser();
        parser.setParseComments(parseComments);
        return parser;
    }

    public CommentedConfig createConfig(Supplier<Map<String, Object>> mapCreator) {
        return CommentedConfig.of(mapCreator, (ConfigFormat)this);
    }

    public boolean supportsComments() {
        return false;
    }

    public boolean supportsType(Class<?> type) {
        return type == null || type.isEnum() || type == Boolean.class || type == String.class || type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == byte[].class || type == Object[].class || Number.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Pair.class.isAssignableFrom(type) || Triple.class.isAssignableFrom(type) || Config.class.isAssignableFrom(type);
    }

    public Yaml getYaml() {
        return this.yaml;
    }
}

