/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.yaml;

import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.comments.CommentLine;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.comments.CommentType;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.Node;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.nodes.NodeTuple;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class NodeComments {
    @Nullable
    private List<CommentLine> blockComments;
    @Nullable
    private List<CommentLine> keyInLineComments;
    @Nullable
    private List<CommentLine> valueBlockComments;
    @Nullable
    private List<CommentLine> inLineComments;
    @Nullable
    private List<CommentLine> endComments;

    public NodeComments() {
        this(null, null, null, null, null);
    }

    public NodeComments(@Nullable List<CommentLine> blockComments, @Nullable List<CommentLine> keyInLineComments, @Nullable List<CommentLine> valueBlockComments, @Nullable List<CommentLine> inLineComments, @Nullable List<CommentLine> endComments) {
        this.blockComments = blockComments == null || blockComments.isEmpty() ? null : blockComments;
        this.keyInLineComments = keyInLineComments == null || keyInLineComments.isEmpty() ? null : keyInLineComments;
        this.valueBlockComments = valueBlockComments == null || valueBlockComments.isEmpty() ? null : valueBlockComments;
        this.inLineComments = inLineComments == null || inLineComments.isEmpty() ? null : inLineComments;
        this.endComments = endComments == null || endComments.isEmpty() ? null : endComments;
    }

    @Nullable
    public List<CommentLine> getBlockComments() {
        return this.blockComments;
    }

    public void setBlockComments(@Nullable List<CommentLine> blockComments) {
        this.blockComments = blockComments;
    }

    @Nullable
    public List<CommentLine> getKeyInLineComments() {
        return this.keyInLineComments;
    }

    public void setKeyInLineComments(@Nullable List<CommentLine> keyInLineComments) {
        this.keyInLineComments = keyInLineComments;
    }

    @Nullable
    public List<CommentLine> getValueBlockComments() {
        return this.valueBlockComments;
    }

    public void setValueBlockComments(@Nullable List<CommentLine> valueBlockComments) {
        this.valueBlockComments = valueBlockComments;
    }

    @Nullable
    public List<CommentLine> getInLineComments() {
        return this.inLineComments;
    }

    public void setInLineComments(@Nullable List<CommentLine> inLineComments) {
        this.inLineComments = inLineComments;
    }

    @Nullable
    public List<CommentLine> getEndComments() {
        return this.endComments;
    }

    public void setEndComments(@Nullable List<CommentLine> endComments) {
        this.endComments = endComments;
    }

    public List<CommentLine> getAllLines() {
        return Stream.of(this.getBlockComments(), this.getKeyInLineComments(), this.getValueBlockComments(), this.getInLineComments(), this.getEndComments()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void addSeparatorLine() {
        List<CommentLine> comments = this.getBlockComments();
        if (comments == null) {
            comments = new ArrayList<CommentLine>();
        }
        if (comments.isEmpty() || comments.get(0).getCommentType() != CommentType.BLANK_LINE) {
            comments.add(0, SimpleConfigCommentedYamlWriter.blankLine());
        }
        this.setBlockComments(comments);
    }

    public NodeComments appendAsPrefix(@Nullable NodeComments comments) {
        return this.appendAsPrefix(comments, true);
    }

    public NodeComments appendAsPrefix(@Nullable NodeComments comments, boolean addBlankLine) {
        List<CommentLine> list;
        List<CommentLine> blockComments;
        if (!this.isNotEmpty()) {
            return comments;
        }
        if (comments == null) {
            comments = new NodeComments();
        }
        if ((blockComments = comments.getBlockComments()) == null) {
            blockComments = new ArrayList<CommentLine>();
        }
        if (!(list = this.getAllLines()).isEmpty()) {
            if (addBlankLine) {
                list.add(SimpleConfigCommentedYamlWriter.blankLine());
            }
            blockComments.addAll(0, list);
        }
        comments.setBlockComments(blockComments);
        return comments;
    }

    public NodeComments appendAtEnd(@Nullable NodeComments comments) {
        return this.appendAtEnd(comments, true);
    }

    public NodeComments appendAtEnd(@Nullable NodeComments comments, boolean addBlankLine) {
        List<CommentLine> list;
        List<CommentLine> endComments;
        if (!this.isNotEmpty()) {
            return comments;
        }
        if (comments == null) {
            comments = new NodeComments();
        }
        if ((endComments = comments.getEndComments()) == null) {
            endComments = new ArrayList<CommentLine>();
        }
        if (!(list = this.getAllLines()).isEmpty()) {
            if (addBlankLine) {
                endComments.add(SimpleConfigCommentedYamlWriter.blankLine());
            }
            endComments.addAll(list);
        }
        comments.setEndComments(endComments);
        return comments;
    }

    public static NodeComments prefix(CommentLine ... lines) {
        return new NodeComments(Arrays.asList(lines), null, null, null, null);
    }

    public static NodeComments suffix(CommentLine ... lines) {
        return new NodeComments(null, null, null, null, Arrays.asList(lines));
    }

    public static NodeComments from(Node node) {
        List<CommentLine> blockComments = node.getBlockComments();
        List<CommentLine> inLineComments = node.getInLineComments();
        List<CommentLine> endComments = node.getEndComments();
        return new NodeComments(blockComments, null, null, inLineComments, endComments);
    }

    public static NodeComments from(NodeTuple tuple) {
        Node keyNode = tuple.getKeyNode();
        Node valueNode = tuple.getValueNode();
        List<CommentLine> blockComments = keyNode.getBlockComments();
        List<CommentLine> keyInLineComments = keyNode.getInLineComments();
        List<CommentLine> valueBlockComments = valueNode.getBlockComments();
        List<CommentLine> inLineComments = valueNode.getInLineComments();
        List<CommentLine> endComments = valueNode.getEndComments();
        return new NodeComments(blockComments, keyInLineComments, valueBlockComments, inLineComments, endComments);
    }

    public void apply(NodeTuple tuple) {
        Node keyNode = tuple.getKeyNode();
        Node valueNode = tuple.getValueNode();
        keyNode.setBlockComments(this.getBlockComments());
        keyNode.setInLineComments(this.getKeyInLineComments());
        valueNode.setBlockComments(this.getValueBlockComments());
        valueNode.setInLineComments(this.getInLineComments());
        valueNode.setEndComments(this.getEndComments());
    }

    public void apply(Node node) {
        node.setBlockComments(this.getBlockComments());
        node.setInLineComments(this.getInLineComments());
        node.setEndComments(this.getEndComments());
    }

    public boolean isNotEmpty() {
        return this.blockComments != null || this.keyInLineComments != null || this.valueBlockComments != null || this.inLineComments != null || this.endComments != null;
    }
}

