/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.TripleListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class TripleListEntryBuilder<L, M, R, LE extends AbstractConfigListEntry<L>, ME extends AbstractConfigListEntry<M>, RE extends AbstractConfigListEntry<R>, LEB extends FieldBuilder<L, LE, LEB>, MEB extends FieldBuilder<M, ME, MEB>, REB extends FieldBuilder<R, RE, REB>>
extends FieldBuilder<Triple<L, M, R>, TripleListEntry<L, M, R, LE, ME, RE>, TripleListEntryBuilder<L, M, R, LE, ME, RE, LEB, MEB, REB>> {
    protected final LEB leftEntry;
    protected final MEB middleEntry;
    protected final REB rightEntry;
    @Nullable
    protected Icon leftIcon;
    @Nullable
    protected Icon rightIcon;
    protected float leftWeight = 0.333f;
    protected float rightWeight = 0.333f;

    public TripleListEntryBuilder(ConfigFieldBuilder builder, Component name, Triple<L, M, R> value, LEB leftEntry, MEB middleEntry, REB rightEntry) {
        super(TripleListEntry.class, builder, name, value);
        this.leftEntry = leftEntry;
        this.middleEntry = middleEntry;
        this.rightEntry = rightEntry;
    }

    public TripleListEntryBuilder<L, M, R, LE, ME, RE, LEB, MEB, REB> withIcons(@Nullable Icon leftIcon, @Nullable Icon rightIcon) {
        this.leftIcon = leftIcon;
        this.rightIcon = rightIcon;
        return (TripleListEntryBuilder)this.self();
    }

    public TripleListEntryBuilder<L, M, R, LE, ME, RE, LEB, MEB, REB> withWeights(@Range(from=0L, to=1L) float leftWeight, @Range(from=0L, to=1L) float rightWeight) {
        if (leftWeight < 0.0f || rightWeight < 0.0f || leftWeight + rightWeight > 1.0f) {
            throw new IllegalArgumentException("Left and right weights must add up between 0 and 1");
        }
        this.leftWeight = leftWeight;
        this.rightWeight = rightWeight;
        return (TripleListEntryBuilder)this.self();
    }

    @Override
    protected TripleListEntry<L, M, R, LE, ME, RE> buildEntry() {
        return new TripleListEntry(this.fieldNameKey, (Triple)this.value, ((FieldBuilder)this.leftEntry).build(), ((FieldBuilder)this.middleEntry).build(), ((FieldBuilder)this.rightEntry).build());
    }

    @Override
    @NotNull
    public TripleListEntry<L, M, R, LE, ME, RE> build() {
        TripleListEntry entry = (TripleListEntry)super.build();
        entry.setLeftIcon(this.leftIcon);
        entry.setRightIcon(this.rightIcon);
        entry.setLeftWeight(this.leftWeight);
        entry.setRightWeight(this.rightWeight);
        return entry;
    }
}

