/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.StringListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TextFieldBuilder
extends FieldBuilder<String, StringListEntry, TextFieldBuilder> {
    protected int maxLength = Integer.MAX_VALUE;
    protected TextFormatter textFormatter = TextFormatter.DEFAULT;

    public TextFieldBuilder(ConfigFieldBuilder builder, Component name, String value) {
        super(StringListEntry.class, builder, name, Objects.requireNonNull(value));
    }

    public TextFieldBuilder setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return (TextFieldBuilder)this.self();
    }

    public TextFieldBuilder setTextFormatter(TextFormatter textFormatter) {
        this.textFormatter = textFormatter;
        return (TextFieldBuilder)this.self();
    }

    @Override
    @NotNull
    public StringListEntry buildEntry() {
        StringListEntry entry = new StringListEntry(this.fieldNameKey, (String)this.value);
        entry.setMaxLength(this.maxLength);
        entry.setTextFormatter(this.textFormatter);
        return entry;
    }
}

