/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.SliderListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class SliderFieldBuilder<V extends Comparable<V>, Entry extends SliderListEntry<V>, Self extends SliderFieldBuilder<V, Entry, Self>>
extends FieldBuilder<V, Entry, Self> {
    protected final V min;
    protected final V max;
    @Nullable
    protected V sliderMin;
    @Nullable
    protected V sliderMax;
    protected Function<V, Component> textGetter = null;
    @Nullable
    protected RangedEntryBuilder.InvertibleDouble2DoubleFunction sliderMap = null;

    public SliderFieldBuilder(Class<?> entryClass, ConfigFieldBuilder builder, Component name, V value, V min, V max) {
        super(entryClass, builder, name, (Comparable)Objects.requireNonNull(value));
        this.min = (Comparable)Objects.requireNonNull(min);
        this.max = (Comparable)Objects.requireNonNull(max);
        if (min.compareTo(value) > 0 || value.compareTo(max) > 0) {
            throw new IllegalArgumentException("Value not within bounds");
        }
    }

    public Self setSliderMin(@Nullable V sliderMin) {
        this.sliderMin = sliderMin;
        return (Self)((SliderFieldBuilder)this.self());
    }

    public Self setSliderMax(@Nullable V sliderMax) {
        this.sliderMax = sliderMax;
        return (Self)((SliderFieldBuilder)this.self());
    }

    public Self setSliderMap(@Nullable RangedEntryBuilder.InvertibleDouble2DoubleFunction map) {
        this.sliderMap = map;
        return (Self)((SliderFieldBuilder)this.self());
    }

    public Self setTextGetter(Function<V, Component> textGetter) {
        this.textGetter = textGetter;
        return (Self)((SliderFieldBuilder)this.self());
    }

    @Override
    @NotNull
    public Entry build() {
        SliderListEntry entry = (SliderListEntry)super.build();
        entry.setMin(this.min);
        entry.setMax(this.max);
        if (this.sliderMin != null) {
            entry.setSliderMin(this.sliderMin);
        }
        if (this.sliderMax != null) {
            entry.setSliderMax(this.sliderMax);
        }
        if (this.sliderMap != null) {
            entry.setSliderMap(this.sliderMap);
        }
        if (this.textGetter != null) {
            entry.setTextGetter(this.textGetter);
        }
        return (Entry)entry;
    }
}

