/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.range.Range;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.RangeListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeListEntryBuilder<V extends Comparable<V>, R extends Range<V, R>, E extends AbstractConfigListEntry<V>>
extends FieldBuilder<R, RangeListEntry<V, R, E>, RangeListEntryBuilder<V, R, E>> {
    protected final E minEntry;
    protected final E maxEntry;
    protected boolean minExclusivenessEditable = false;
    protected boolean maxExclusivenessEditable = false;
    @NotNull
    protected Icon comparisonIcon = SimpleConfigIcons.Entries.LESS_EQUAL;
    @Nullable
    protected Icon middleIcon = null;

    public RangeListEntryBuilder(ConfigFieldBuilder builder, Component name, R value, FieldBuilder<V, E, ?> entryBuilder) {
        this(builder, name, value, entryBuilder.build(), entryBuilder.build());
    }

    public RangeListEntryBuilder(ConfigFieldBuilder builder, Component name, R value, E minEntry, E maxEntry) {
        super(RangeListEntry.class, builder, name, value);
        this.minEntry = minEntry;
        this.maxEntry = maxEntry;
    }

    public RangeListEntryBuilder<V, R, E> withMiddleIcon(@Nullable Icon middleIcon) {
        this.middleIcon = middleIcon;
        return (RangeListEntryBuilder)this.self();
    }

    public RangeListEntryBuilder<V, R, E> withComparisonIcon(@NotNull Icon icon) {
        this.comparisonIcon = icon;
        return (RangeListEntryBuilder)this.self();
    }

    public RangeListEntryBuilder<V, R, E> withMinExclusivenessEditable(boolean editable) {
        this.minExclusivenessEditable = editable;
        return (RangeListEntryBuilder)this.self();
    }

    public RangeListEntryBuilder<V, R, E> withMaxExclusivenessEditable(boolean editable) {
        this.maxExclusivenessEditable = editable;
        return (RangeListEntryBuilder)this.self();
    }

    public RangeListEntryBuilder<V, R, E> withExclusivenessEditable(boolean min, boolean max) {
        return this.withMinExclusivenessEditable(min).withMaxExclusivenessEditable(max);
    }

    public RangeListEntryBuilder<V, R, E> withExclusivenessEditable(boolean editable) {
        return this.withExclusivenessEditable(editable, editable);
    }

    @Override
    protected RangeListEntry<V, R, E> buildEntry() {
        return new RangeListEntry(this.fieldNameKey, (Range)this.value, this.minEntry, this.maxEntry);
    }

    @Override
    @NotNull
    public RangeListEntry<V, R, E> build() {
        RangeListEntry entry = (RangeListEntry)super.build();
        entry.setMiddleIcon(this.middleIcon);
        entry.setComparisonIcon(this.comparisonIcon);
        entry.setMinExclusivenessEditable(this.minExclusivenessEditable);
        entry.setMaxExclusivenessEditable(this.maxExclusivenessEditable);
        return entry;
    }
}

