/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.PairListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class PairListEntryBuilder<L, R, LE extends AbstractConfigListEntry<L>, RE extends AbstractConfigListEntry<R>, LEB extends FieldBuilder<L, LE, LEB>, REB extends FieldBuilder<R, RE, REB>>
extends FieldBuilder<Pair<L, R>, PairListEntry<L, R, LE, RE>, PairListEntryBuilder<L, R, LE, RE, LEB, REB>> {
    protected final LEB leftEntry;
    protected final REB rightEntry;
    @Nullable
    protected Icon middleIcon = null;
    protected float splitPos = 0.5f;

    public PairListEntryBuilder(ConfigFieldBuilder builder, Component name, Pair<L, R> value, LEB leftEntry, REB rightEntry) {
        super(PairListEntry.class, builder, name, value);
        this.leftEntry = leftEntry;
        this.rightEntry = rightEntry;
    }

    public PairListEntryBuilder<L, R, LE, RE, LEB, REB> withMiddleIcon(Icon middleIcon) {
        this.middleIcon = middleIcon;
        return (PairListEntryBuilder)this.self();
    }

    public PairListEntryBuilder<L, R, LE, RE, LEB, REB> withSplitPos(@Range(from=0L, to=1L) float splitPos) {
        if (splitPos < 0.0f || splitPos > 1.0f) {
            throw new IllegalArgumentException("Split position must be between 0 and 1");
        }
        this.splitPos = splitPos;
        return (PairListEntryBuilder)this.self();
    }

    @Override
    protected PairListEntry<L, R, LE, RE> buildEntry() {
        return new PairListEntry(this.fieldNameKey, (Pair)this.value, ((FieldBuilder)this.leftEntry).build(), ((FieldBuilder)this.rightEntry).build());
    }

    @Override
    @NotNull
    public PairListEntry<L, R, LE, RE> build() {
        PairListEntry entry = (PairListEntry)super.build();
        entry.setMiddleIcon(this.middleIcon);
        entry.setSplitPos(this.splitPos);
        return entry;
    }
}

