/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class FieldBuilder<V, Entry extends AbstractConfigListEntry<V>, Self extends FieldBuilder<V, Entry, Self>> {
    private final Class<?> entryClass;
    private final ConfigFieldBuilder builder;
    @NotNull
    protected final Component fieldNameKey;
    protected Consumer<Entry> onBuildListener;
    protected boolean requireRestart = false;
    protected V value;
    protected V original;
    protected String name;
    @NotNull
    protected Supplier<V> defaultValue;
    @NotNull
    protected Consumer<V> saveConsumer = t -> {};
    @NotNull
    protected Function<V, Optional<Component>> errorSupplier = t -> Optional.empty();
    @NotNull
    protected Function<V, Optional<Component[]>> tooltipSupplier = t -> Optional.empty();
    @Nullable
    protected Supplier<Boolean> editableSupplier = null;
    protected List<EntryTag> entryTags = new ArrayList<EntryTag>();
    protected boolean ignoreEdits = false;

    @ApiStatus.Internal
    protected FieldBuilder(Class<?> entryClass, ConfigFieldBuilder builder, Component name, V value) {
        this.entryClass = entryClass;
        this.builder = builder;
        this.original = value;
        this.value = this.original;
        this.defaultValue = () -> value;
        this.fieldNameKey = Objects.requireNonNull(name);
    }

    @ApiStatus.Internal
    public Class<?> getEntryClass() {
        return this.entryClass;
    }

    protected ConfigFieldBuilder getEntryBuilder() {
        return this.builder;
    }

    protected Self self() {
        return (Self)this;
    }

    public Self setOriginal(V original) {
        this.original = original;
        return this.self();
    }

    public Self setName(String name) {
        this.name = name;
        return this.self();
    }

    public Self setErrorSupplier(Function<V, Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this.self();
    }

    public Self setTooltipSupplier(Function<V, Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this.self();
    }

    public Self setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return this.setTooltipSupplier((V v) -> (Optional)tooltipSupplier.get());
    }

    public Self setTooltip(Component ... tooltip) {
        return this.setTooltipSupplier(() -> Optional.ofNullable(tooltip));
    }

    public Self withTags(Collection<? extends EntryTag> flags) {
        this.entryTags.addAll(flags);
        return this.self();
    }

    public Self withTags(EntryTag ... flags) {
        this.entryTags.addAll(Arrays.asList(flags));
        return this.self();
    }

    public Self withoutTags(Collection<? extends EntryTag> flags) {
        this.entryTags.removeAll(flags);
        return this.self();
    }

    public Self withoutTags(EntryTag ... flags) {
        this.entryTags.removeAll(Arrays.asList(flags));
        return this.self();
    }

    public Self requireRestart(boolean requireRestart) {
        this.requireRestart = requireRestart;
        if (requireRestart) {
            this.withTags(EntryTag.REQUIRES_RESTART);
        } else {
            this.withoutTags(EntryTag.REQUIRES_RESTART);
        }
        return this.self();
    }

    public Self nonPersistent(boolean nonPersistent) {
        return nonPersistent ? this.withTags(EntryTag.NON_PERSISTENT) : this.withoutTags(EntryTag.NON_PERSISTENT);
    }

    public Self setEditableSupplier(@Nullable Supplier<Boolean> editableSupplier) {
        this.editableSupplier = editableSupplier;
        return this.self();
    }

    public Self withSaveConsumer(Consumer<V> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this.self();
    }

    public Self setIgnoreEdits(boolean ignoreEdits) {
        this.ignoreEdits = ignoreEdits;
        return this.self();
    }

    public Self setDefaultValue(Supplier<V> defaultValue) {
        this.defaultValue = defaultValue;
        return this.self();
    }

    public Self setDefaultValue(V defaultValue) {
        return this.setDefaultValue((V)((Supplier<Object>)() -> defaultValue));
    }

    public Self withBuildListener(Consumer<Entry> listener) {
        this.onBuildListener = listener;
        return this.self();
    }

    @NotNull
    public Entry build() {
        Entry entry = this.buildEntry();
        ((AbstractConfigField)entry).setRequiresRestart(this.requireRestart);
        ((AbstractConfigField)entry).setErrorSupplier(() -> this.errorSupplier.apply(entry.getValue()));
        ((AbstractConfigField)entry).setDefaultValue(this.defaultValue);
        ((AbstractConfigField)entry).setSaveConsumer(this.saveConsumer);
        if (entry instanceof TooltipListEntry) {
            ((TooltipListEntry)entry).setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        }
        ((AbstractConfigField)entry).setOriginal(this.value);
        if (this.name != null) {
            ((AbstractConfigField)entry).setName(this.name);
        }
        ((AbstractConfigField)entry).getEntryTags().addAll(this.entryTags);
        ((AbstractConfigField)entry).setEditableSupplier(this.editableSupplier);
        ((AbstractConfigField)entry).setIgnoreEdits(this.ignoreEdits);
        if (this.onBuildListener != null) {
            this.onBuildListener.accept(entry);
        }
        return entry;
    }

    protected abstract Entry buildEntry();
}

