/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.EnumListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EnumSelectorBuilder<V extends Enum<?>>
extends FieldBuilder<V, EnumListEntry<V>, EnumSelectorBuilder<V>> {
    protected final Class<V> clazz;
    protected Function<V, Component> enumNameProvider = EnumListEntry.DEFAULT_NAME_PROVIDER::apply;
    @Nullable
    protected Function<V, List<Component>> enumTooltipProvider = null;
    @Nullable
    protected Set<V> allowedValues = null;

    public EnumSelectorBuilder(ConfigFieldBuilder builder, Component name, V value) {
        super(EnumListEntry.class, builder, name, value);
        Objects.requireNonNull(value);
        this.value = value;
        this.clazz = ((Enum)value).getDeclaringClass();
    }

    public EnumSelectorBuilder<V> setEnumNameProvider(Function<V, Component> enumNameProvider) {
        Objects.requireNonNull(enumNameProvider);
        this.enumNameProvider = enumNameProvider;
        return this;
    }

    public EnumSelectorBuilder<V> setEnumTooltipProvider(Function<V, List<Component>> enumTooltipProvider) {
        Objects.requireNonNull(enumTooltipProvider);
        this.enumTooltipProvider = enumTooltipProvider;
        return this;
    }

    public EnumSelectorBuilder<V> setAllowedValues(@Nullable Set<V> allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }

    @Override
    @NotNull
    public EnumListEntry<V> buildEntry() {
        return new EnumListEntry<Enum>(this.fieldNameKey, this.clazz, (Enum)this.value, this.enumNameProvider, this.enumTooltipProvider, this.allowedValues);
    }
}

