/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.ConfigCategory;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.impl.ConfigCategoryImpl;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategoryBuilderImpl
implements ConfigCategoryBuilder {
    protected final ConfigScreenBuilder builder;
    protected final String name;
    protected SimpleConfig.EditType type;
    protected final List<FieldBuilder<?, ?, ?>> entries = new ArrayList();
    protected Component title;
    protected int sortingOrder;
    @Nullable
    protected ResourceLocation background;
    @Nullable
    protected Supplier<Optional<Component[]>> description = Optional::empty;
    @Nullable
    protected Path containingFile;
    protected boolean isEditable = true;
    protected Icon icon = Icon.EMPTY;
    protected int color = 0;
    @Nullable
    protected CompletableFuture<Function<ConfigCategory, Boolean>> loadingFuture = null;

    public ConfigCategoryBuilderImpl(ConfigScreenBuilder builder, String name, SimpleConfig.EditType type) {
        this.builder = builder;
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SimpleConfig.EditType getType() {
        return this.type;
    }

    @Override
    public ConfigCategoryBuilder addEntry(FieldBuilder<?, ?, ?> entry) {
        this.entries.add(entry);
        return this;
    }

    @Override
    public ConfigCategoryBuilder addEntry(int index, FieldBuilder<?, ?, ?> entry) {
        this.entries.add(index, entry);
        return this;
    }

    @Override
    public Component getTitle() {
        return this.title != null ? this.title : Component.m_237113_((String)this.name);
    }

    @Override
    public void setTitle(Component title) {
        this.title = title;
    }

    @Override
    public int getSortingOrder() {
        return this.sortingOrder;
    }

    @Override
    public void setSortingOrder(int sortingOrder) {
        this.sortingOrder = sortingOrder;
    }

    @Override
    @Nullable
    public ResourceLocation getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@Nullable ResourceLocation background) {
        this.background = background;
    }

    @Override
    @Nullable
    public Supplier<Optional<Component[]>> getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(@Nullable Supplier<Optional<Component[]>> description) {
        this.description = description;
    }

    @Override
    @Nullable
    public Path getContainingFile() {
        return this.containingFile;
    }

    @Override
    public void setContainingFile(@Nullable Path containingFile) {
        this.containingFile = containingFile;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    @Override
    @Nullable
    public CompletableFuture<Function<ConfigCategory, Boolean>> getLoadingFuture() {
        return this.loadingFuture;
    }

    @Override
    public void setLoadingFuture(@Nullable CompletableFuture<Function<ConfigCategory, Boolean>> future) {
        this.loadingFuture = future;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public ConfigCategoryImpl build() {
        List<AbstractConfigField<?>> builtEntries = this.entries.stream().map(FieldBuilder::build).collect(Collectors.toList());
        return new ConfigCategoryImpl(this.name, this.type, builtEntries, this.getTitle(), this.getSortingOrder(), this.getBackground(), this.getDescription(), this.getContainingFile(), this.isEditable(), this.getIcon(), this.getColor(), this.getLoadingFuture());
    }
}

