/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.ComboBoxListEntry;
import endorh.simpleconfig.ui.gui.widget.combobox.IComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.BlockNameTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.BlockTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.FluidNameTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.FluidTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.ItemNameTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.ItemTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.ResourceLocationTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.StringTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ComboBoxFieldBuilder<T>
extends FieldBuilder<T, ComboBoxListEntry<T>, ComboBoxFieldBuilder<T>> {
    protected final TypeWrapper<T> typeWrapper;
    protected List<T> suggestions = null;
    protected IComboBoxModel<T> suggestionProvider;
    protected boolean suggestionMode = true;
    protected int maxLength = Integer.MAX_VALUE;

    public ComboBoxFieldBuilder(ConfigFieldBuilder builder, Component name, T value, TypeWrapper<T> typeWrapper) {
        super(ComboBoxListEntry.class, builder, name, value);
        this.typeWrapper = typeWrapper;
    }

    public ComboBoxFieldBuilder<T> setSuggestions(List<T> suggestions) {
        this.suggestions = suggestions;
        return (ComboBoxFieldBuilder)this.self();
    }

    public ComboBoxFieldBuilder<T> setSuggestionProvider(IComboBoxModel<T> suggestionProvider) {
        this.suggestionProvider = suggestionProvider;
        return (ComboBoxFieldBuilder)this.self();
    }

    public ComboBoxFieldBuilder<T> setSuggestionMode(boolean suggestionMode) {
        this.suggestionMode = suggestionMode;
        return (ComboBoxFieldBuilder)this.self();
    }

    public ComboBoxFieldBuilder<T> setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return (ComboBoxFieldBuilder)this.self();
    }

    @Override
    protected ComboBoxListEntry<T> buildEntry() {
        ComboBoxListEntry<Object> entry = new ComboBoxListEntry<Object>(this.fieldNameKey, this.value, this.typeWrapper, this.suggestions);
        entry.setSuggestionMode(this.suggestionMode);
        entry.setMaxLength(this.maxLength);
        if (this.suggestionProvider != null) {
            entry.setSuggestionProvider(this.suggestionProvider);
        }
        return entry;
    }

    public static TypeWrapper<String> ofString() {
        return new StringTypeWrapper();
    }

    public static TypeWrapper<ResourceLocation> ofResourceLocation() {
        return new ResourceLocationTypeWrapper();
    }

    public static TypeWrapper<Item> ofItem() {
        return new ItemTypeWrapper();
    }

    public static TypeWrapper<ResourceLocation> ofItemName() {
        return new ItemNameTypeWrapper();
    }

    public static TypeWrapper<Block> ofBlock() {
        return new BlockTypeWrapper();
    }

    public static TypeWrapper<ResourceLocation> ofBlockName() {
        return new BlockNameTypeWrapper();
    }

    public static TypeWrapper<Fluid> ofFluid() {
        return new FluidTypeWrapper();
    }

    public static TypeWrapper<ResourceLocation> ofFluidName() {
        return new FluidNameTypeWrapper();
    }
}

