/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl.builders;

import com.google.common.collect.Maps;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.entry.BeanProxy;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.entries.BeanListEntry;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class BeanFieldBuilder<B>
extends FieldBuilder<B, BeanListEntry<B>, BeanFieldBuilder<B>> {
    private final BeanProxy<B> proxy;
    protected final Map<String, FieldBuilder<?, ?, ?>> entries = Maps.newLinkedHashMap();
    @Nullable
    protected String caption;
    @Nullable
    protected Function<B, Icon> iconProvider;
    @Nullable
    protected Boolean overrideEquals;

    public BeanFieldBuilder(BeanProxy<B> proxy2, ConfigFieldBuilder builder, Component name, B value) {
        super(BeanListEntry.class, builder, name, value);
        this.proxy = proxy2;
    }

    public BeanFieldBuilder<B> add(String name, FieldBuilder<?, ?, ?> builder) {
        this.entries.put(name, builder);
        return this;
    }

    public <T, E extends AbstractConfigListEntry<T>, F extends FieldBuilder<T, E, F>> BeanFieldBuilder<B> caption(String name, F builder) {
        this.add(name, builder);
        this.caption = name;
        return this;
    }

    public BeanFieldBuilder<B> withoutCaption() {
        this.caption = null;
        return this;
    }

    public BeanFieldBuilder<B> withIcon(@Nullable Function<B, Icon> iconProvider) {
        this.iconProvider = iconProvider;
        return this;
    }

    public BeanFieldBuilder<B> withIcon(@Nullable Icon icon) {
        return this.withIcon(icon != null ? b -> icon : null);
    }

    public BeanFieldBuilder<B> overrideEquals(@Nullable Boolean overrideEquals) {
        this.overrideEquals = overrideEquals;
        return this;
    }

    public BeanFieldBuilder<B> overrideEquals() {
        return this.overrideEquals(true);
    }

    @Override
    protected BeanListEntry<B> buildEntry() {
        LinkedHashMap entries2 = new LinkedHashMap();
        this.entries.forEach((name, b) -> entries2.put((String)name, (AbstractConfigListEntry<?>)b.build()));
        BeanListEntry<Object> entry = new BeanListEntry<Object>(this.fieldNameKey, this.value, this.proxy, entries2, this.caption, this.iconProvider);
        if (this.overrideEquals != null) {
            entry.setOverrideEquals(this.overrideEquals);
        }
        return entry;
    }
}

