/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl;

import com.mojang.blaze3d.platform.Window;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class ScissorsHandlerImpl
implements ScissorsHandler {
    @ApiStatus.Internal
    public static final ScissorsHandler INSTANCE = new ScissorsHandlerImpl();
    private final Stack<Rectangle> scissorsAreas = new Stack();

    @Override
    public void clearScissors() {
        this.scissorsAreas.clear();
        this.applyScissors();
    }

    @Override
    public Collection<Rectangle> getScissorsAreas() {
        return Collections.unmodifiableCollection(this.scissorsAreas);
    }

    @Override
    public void pushScissor(Rectangle clipArea) {
        this.scissorsAreas.add(clipArea);
        this.applyScissors();
    }

    @Override
    public void popScissor() {
        if (!this.scissorsAreas.isEmpty()) {
            this.scissorsAreas.remove(this.scissorsAreas.size() - 1);
        }
        this.applyScissors();
    }

    @Override
    public void withSingleScissor(Rectangle clipArea, Runnable runnable) {
        this.applyScissor(clipArea);
        runnable.run();
        this.applyScissors();
    }

    @Override
    public void withoutScissors(Runnable runnable) {
        this.applyScissor(null);
        runnable.run();
        this.applyScissors();
    }

    private void applyScissors() {
        if (!this.scissorsAreas.isEmpty()) {
            Rectangle r = this.scissorsAreas.stream().reduce(Rectangle::intersection).orElse(new Rectangle());
            r.setBounds(Math.min(r.x, r.x + r.width), Math.min(r.y, r.y + r.height), Math.abs(r.width), Math.abs(r.height));
            this.applyScissor(r);
        } else {
            this.applyScissor(null);
        }
    }

    private void applyScissor(Rectangle r) {
        if (r != null) {
            GL11.glEnable((int)3089);
            if (r.isEmpty()) {
                GL11.glScissor((int)0, (int)0, (int)0, (int)0);
            } else {
                Window window = Minecraft.m_91087_().m_91268_();
                double scaleFactor = window.m_85449_();
                GL11.glScissor((int)((int)((double)r.x * scaleFactor)), (int)((int)((double)(window.m_85446_() - r.height - r.y) * scaleFactor)), (int)((int)((double)r.width * scaleFactor)), (int)((int)((double)r.height * scaleFactor)));
            }
        } else {
            GL11.glDisable((int)3089);
        }
    }
}

