/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl;

import com.google.common.collect.Lists;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.entries.BaseListCell;
import endorh.simpleconfig.ui.gui.entries.BaseListEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EditHistory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected AbstractConfigScreen owner;
    protected int maxSize = ClientConfig.advanced.max_undo;
    protected List<EditRecord> records;
    @Nullable
    protected EditRecord preservedState;
    @Nullable
    protected EditRecord collector;
    protected int cursor = 0;
    protected Runnable onHistory;
    protected Supplier<Boolean> peek;
    protected boolean insideAtomicAction = false;

    public EditHistory() {
        this.records = new ArrayList<EditRecord>();
    }

    public EditHistory(EditHistory previous) {
        this.records = new ArrayList<EditRecord>(previous.records);
        this.maxSize = previous.maxSize;
        this.cursor = this.records.size();
        this.preservedState = null;
        this.collector = null;
        this.onHistory = null;
        this.peek = null;
        this.owner = null;
        this.insideAtomicAction = false;
    }

    public void setOwner(@Nullable AbstractConfigScreen owner) {
        this.owner = owner;
    }

    protected AbstractConfigScreen getOwner() {
        if (this.owner == null) {
            throw new IllegalStateException("Cannot use unowned EditHistory");
        }
        return this.owner;
    }

    public void runUnrecordedAction(Runnable action) {
        if (this.insideAtomicAction) {
            throw new IllegalStateException("Cannot run unrecorded action within another atomic action");
        }
        this.insideAtomicAction = true;
        this.startBatch(null);
        action.run();
        this.discardPreservedState();
        this.collector = null;
        this.insideAtomicAction = false;
    }

    public void runAtomicTransparentAction(Runnable action) {
        this.runAtomicTransparentAction(null, action);
    }

    public void runAtomicTransparentAction(@Nullable AbstractConfigField<?> focus, Runnable action) {
        boolean insideAction = this.insideAtomicAction;
        if (!insideAction) {
            this.startBatch(focus);
            this.insideAtomicAction = true;
        }
        action.run();
        if (!insideAction) {
            this.saveBatch();
            this.insideAtomicAction = false;
        }
    }

    public void startBatch(@Nullable AbstractConfigField<?> focus) {
        if (this.preservedState != null) {
            this.saveState();
        }
        if (this.collector != null) {
            this.saveBatch();
        }
        this.collector = new EditRecord(focus != null ? focus.getPath() : null, new HashMap<String, Object>(), null);
    }

    public void saveBatch() {
        this.saveState();
        if (this.collector != null) {
            EditRecord c = this.collector;
            this.collector = null;
            c.flatten(this.getOwner());
            if (!c.isEmpty()) {
                this.addRecord(c);
            }
        }
    }

    public void preserveState(EditRecord record) {
        if (this.preservedState != null) {
            this.saveState();
        }
        this.preservedState = record;
    }

    public void preserveState(AbstractConfigField<?> entry) {
        if (this.preservedState != null) {
            this.saveState();
        }
        this.preservedState = EditRecord.of(entry);
    }

    public void discardPreservedState() {
        this.preservedState = null;
    }

    public void saveState() {
        if (this.preservedState != null) {
            this.preservedState.flatten(this.getOwner());
            if (!this.preservedState.isEmpty()) {
                this.addRecord(this.preservedState);
            }
            this.preservedState = null;
        }
    }

    public void add(EditRecord record) {
        if (this.preservedState != null) {
            this.saveState();
        }
        this.addRecord(record);
    }

    protected void addRecord(EditRecord record) {
        if (this.collector != null) {
            this.collector.merge(record);
        } else {
            if (this.cursor < this.records.size()) {
                this.records.subList(this.cursor, this.records.size()).clear();
            }
            this.records.add(record);
            if (this.records.size() > this.maxSize) {
                this.records.remove(0);
            }
            this.cursor = this.records.size();
        }
    }

    public void apply(boolean forward) {
        if (this.insideAtomicAction) {
            throw new IllegalStateException("Cannot apply history inside transparent history action");
        }
        if (this.preservedState != null) {
            this.saveState();
        }
        if (this.onHistory != null) {
            this.onHistory.run();
        }
        if (this.collector != null) {
            this.saveBatch();
        }
        if (forward && this.cursor >= this.records.size() || !forward && this.cursor <= 0) {
            return;
        }
        if (!forward) {
            --this.cursor;
        }
        EditRecord record = this.records.get(this.cursor);
        EditRecord replacement = record.apply(this.getOwner());
        this.records.set(this.cursor, replacement);
        if (forward) {
            ++this.cursor;
        }
    }

    public boolean canUndo() {
        return this.cursor > 0 || this.preservedState != null && this.preservedState.peek(this.getOwner()) || this.peek != null && this.peek.get() != false;
    }

    public boolean canRedo() {
        return !(this.cursor >= this.records.size() || this.preservedState != null && this.preservedState.peek(this.getOwner()) || this.peek != null && this.peek.get() != false);
    }

    public int getCursor() {
        this.cursor = Mth.m_14045_((int)this.cursor, (int)0, (int)this.records.size());
        return this.cursor;
    }

    public int size() {
        return this.records.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if (this.records.size() > this.maxSize) {
            this.records.subList(0, this.records.size() - this.maxSize).clear();
        }
    }

    public void setOnHistory(Runnable onHistory) {
        this.onHistory = onHistory;
    }

    public void setPeek(Supplier<Boolean> peek) {
        this.peek = peek;
    }

    public static class EditRecord {
        protected String focusEntry;
        protected Map<String, Object> values;
        @Nullable
        protected List<ListEditRecord> listRecords;

        protected EditRecord(String focus, Map<String, Object> changes, List<ListEditRecord> listEditRecords) {
            this.values = changes;
            this.focusEntry = focus;
        }

        public static EditRecord of(AbstractConfigField<?> entry) {
            return new EditRecord(entry.getPath(), (Map)Util.m_137469_(new HashMap(), m -> m.put(entry.getPath(), entry.getValue())), null);
        }

        public static EditRecord of(AbstractConfigField<?> focus, Iterable<AbstractConfigField<?>> entries2) {
            return new EditRecord(focus.getPath(), (Map)Util.m_137469_(new HashMap(), m -> entries2.forEach(e -> m.put(e.getPath(), e.getValue()))), null);
        }

        public static EditRecord of(IEntryHolder holder) {
            return new EditRecord(holder instanceof AbstractConfigField ? ((AbstractConfigField)((Object)holder)).getPath() : null, holder.getAllMainEntries().stream().collect(Collectors.toMap(AbstractConfigField::getPath, e -> e, (a, b) -> b)), null);
        }

        public EditRecord apply(IEntryHolder holder) {
            AbstractConfigField<?> focus;
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<ListEditRecord> lr = null;
            for (Map.Entry<String, Object> e : this.values.entrySet()) {
                AbstractConfigField<?> entry = holder.getEntry(e.getKey());
                if (entry != null) {
                    Object v = e.getValue();
                    map.put(e.getKey(), entry.getValue());
                    entry.restoreHistoryValue(v);
                    continue;
                }
                LOGGER.warn("Could not find entry with path " + e.getKey());
            }
            if (this.listRecords != null) {
                lr = new ArrayList<ListEditRecord>();
                for (ListEditRecord record : this.listRecords) {
                    ListEditRecord r = record.apply(holder, false);
                    if (r.isEmpty()) continue;
                    lr.add(r);
                }
            }
            if (this.focusEntry != null && (focus = holder.getEntry(this.focusEntry)) != null) {
                focus.claimFocus();
                focus.preserveState();
            }
            return new EditRecord(this.focusEntry, map, lr);
        }

        private static <E> boolean tryCheckEqualValue(AbstractConfigField<E> entry, Object value) {
            try {
                return entry.areEqual(entry.getValue(), value);
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }

        public void flatten(IEntryHolder holder) {
            HashSet<String> removed = new HashSet<String>();
            for (Map.Entry<String, Object> e : this.values.entrySet()) {
                AbstractConfigField<?> entry = holder.getEntry(e.getKey());
                if (entry != null && !EditRecord.tryCheckEqualValue(entry, e.getValue())) continue;
                removed.add(e.getKey());
            }
            this.values.keySet().removeAll(removed);
            if (this.listRecords != null) {
                ArrayList removedLR = Lists.newArrayList();
                for (ListEditRecord record : this.listRecords) {
                    record.flatten(holder);
                    if (!record.isEmpty()) continue;
                    removedLR.add(record);
                }
                this.listRecords.removeAll(removedLR);
                if (this.listRecords.isEmpty()) {
                    this.listRecords = null;
                }
            }
        }

        protected void merge(EditRecord record) {
            if (record instanceof ListEditRecord) {
                if (this.listRecords == null) {
                    this.listRecords = new ArrayList<ListEditRecord>();
                }
                this.listRecords.add((ListEditRecord)record);
            } else {
                this.values.putAll(record.values);
            }
        }

        public boolean peek(AbstractConfigScreen holder) {
            for (Map.Entry<String, Object> e : this.values.entrySet()) {
                AbstractConfigField<?> entry = holder.getEntry(e.getKey());
                if (entry == null || EditRecord.tryCheckEqualValue(entry, e.getValue())) continue;
                return true;
            }
            return false;
        }

        public int size() {
            return this.values.size();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        @ApiStatus.Internal
        public static class ListEditRecord
        extends EditRecord {
            public static ListEditRecord EMPTY = new ListEditRecord(null, null, null, null, null);
            protected String listEntry;
            protected List<Integer> remove;
            protected Map<Integer, Object> modify;
            protected Map<Integer, Object> add;
            protected Map<Integer, Integer> move;

            protected ListEditRecord(String listEntry, List<Integer> remove, Map<Integer, Object> modify, Map<Integer, Object> add, Map<Integer, Integer> move) {
                super(null, Collections.emptyMap(), null);
                this.listEntry = listEntry;
                this.remove = remove;
                this.modify = modify;
                this.add = add;
                this.move = move;
            }

            @Override
            public ListEditRecord apply(IEntryHolder holder) {
                return this.apply(holder, true);
            }

            public ListEditRecord apply(IEntryHolder holder, boolean claimFocus) {
                if (this.listEntry == null) {
                    return EMPTY;
                }
                AbstractConfigField<?> entry = holder.getEntry(this.listEntry);
                if (!(entry instanceof BaseListEntry)) {
                    LOGGER.warn("Expected a list entry at path " + this.listEntry);
                    return EMPTY;
                }
                ListEditRecord applied = this.apply((BaseListEntry)entry);
                if (claimFocus) {
                    entry.claimFocus();
                    entry.preserveState();
                }
                return applied;
            }

            public ListEditRecord apply(BaseListEntry<?, ?, ?> list) {
                if (this.remove != null) {
                    List value = (List)list.getValue();
                    Int2ObjectArrayMap add = new Int2ObjectArrayMap(this.remove.size());
                    for (int idx : this.remove) {
                        add.put(idx, value.get(idx));
                        list.remove(idx);
                        list.markRestoredCell(idx, false, true);
                        value.remove(idx);
                    }
                    return ListEditRecord.add(list, (Map<Integer, Object>)add);
                }
                if (this.add != null) {
                    IntArrayList remove = new IntArrayList(this.add.size());
                    BaseListEntry<?, ?, ?> l = list;
                    this.add.forEach((arg_0, arg_1) -> ListEditRecord.lambda$apply$0(l, (List)remove, arg_0, arg_1));
                    return ListEditRecord.remove(list, (List<Integer>)remove);
                }
                if (this.modify != null) {
                    List value = (List)list.getValue();
                    Int2ObjectArrayMap mod = new Int2ObjectArrayMap(this.modify.size());
                    BaseListEntry<?, ?, ?> l = list;
                    this.modify.forEach((arg_0, arg_1) -> ListEditRecord.lambda$apply$1(value, l, (Map)mod, arg_0, arg_1));
                    return ListEditRecord.modify(list, (Map<Integer, Object>)mod);
                }
                if (this.move != null) {
                    Int2ObjectArrayMap m = new Int2ObjectArrayMap(this.move.size());
                    this.move.forEach((arg_0, arg_1) -> ListEditRecord.lambda$apply$2(list, (Map)m, arg_0, arg_1));
                    return ListEditRecord.move(list, (Map<Integer, Integer>)m);
                }
                return EMPTY;
            }

            @Override
            public void flatten(IEntryHolder holder) {
                AbstractConfigField<?> entry = holder.getEntry(this.listEntry);
                if (entry instanceof BaseListEntry) {
                    BaseListEntry list = (BaseListEntry)entry;
                    if (this.modify != null) {
                        List cells = list.getCells();
                        List value = (List)list.getValue();
                        ArrayList removed = new ArrayList();
                        this.modify.forEach((i, v) -> {
                            if (i < 0 || i >= cells.size() || ((BaseListCell)cells.get((int)i)).areEqual(value.get((int)i), v)) {
                                removed.add(i);
                            }
                        });
                        removed.forEach(this.modify::remove);
                        if (this.modify.isEmpty()) {
                            this.modify = null;
                        }
                    }
                } else {
                    LOGGER.warn("Expected list entry at path \"" + this.listEntry + "\"");
                }
            }

            @Override
            public boolean peek(AbstractConfigScreen holder) {
                AbstractConfigField<?> entry = holder.getEntry(this.listEntry);
                if (entry instanceof BaseListEntry) {
                    BaseListEntry list = (BaseListEntry)entry;
                    if (this.modify != null) {
                        List cells = list.getCells();
                        List value = (List)list.getValue();
                        for (Map.Entry<Integer, Object> e : this.modify.entrySet()) {
                            int i = e.getKey();
                            if (i < 0 || i >= cells.size() || cells.get(i).areEqual(value.get(i), e.getValue())) continue;
                            return true;
                        }
                    }
                } else {
                    LOGGER.warn("Expected list entry at path \"" + this.listEntry + "\"");
                }
                return false;
            }

            @Override
            protected void merge(EditRecord record) {
                throw new UnsupportedOperationException("Use a regular EditRecord for merging");
            }

            @Override
            public int size() {
                return (this.remove != null ? this.remove.size() : 0) + (this.modify != null ? this.modify.size() : 0) + (this.add != null ? this.add.size() : 0) + (this.move != null ? this.move.size() : 0);
            }

            public static ListEditRecord remove(BaseListEntry<?, ?, ?> list, List<Integer> indexes) {
                return new ListEditRecord(list.getPath(), indexes, null, null, null);
            }

            public static ListEditRecord modify(BaseListEntry<?, ?, ?> list, Map<Integer, Object> values) {
                return new ListEditRecord(list.getPath(), null, values, null, null);
            }

            public static ListEditRecord add(BaseListEntry<?, ?, ?> list, Map<Integer, Object> add) {
                return new ListEditRecord(list.getPath(), null, null, add, null);
            }

            public static ListEditRecord move(BaseListEntry<?, ?, ?> list, Map<Integer, Integer> moves) {
                return new ListEditRecord(list.getPath(), null, null, null, moves);
            }

            private static /* synthetic */ void lambda$apply$2(BaseListEntry list, Map m, Integer i, Integer j) {
                list.move(i, j);
                list.markRestoredCell(j, false, false);
                m.put(j, i);
            }

            private static /* synthetic */ void lambda$apply$1(List value, BaseListEntry l, Map mod, Integer i, Object v) {
                try {
                    Object p = value.get(i);
                    l.set(i, v);
                    l.markRestoredCell(i, false, false);
                    mod.put(i, p);
                }
                catch (ClassCastException e) {
                    LOGGER.warn("Error restoring modified list entry: " + e.getMessage());
                }
            }

            private static /* synthetic */ void lambda$apply$0(BaseListEntry l, List remove, Integer i, Object v) {
                try {
                    l.add(i, v);
                    l.markRestoredCell(i, true, false);
                    remove.add(i);
                }
                catch (ClassCastException e) {
                    LOGGER.warn("Error restoring removed list entry: " + e.getMessage());
                }
            }
        }
    }
}

