/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.ui.api.ConfigCategory;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.impl.ConfigCategoryImpl;
import endorh.simpleconfig.ui.impl.builders.ConfigCategoryBuilderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ConfigScreenBuilderImpl
implements ConfigScreenBuilder {
    protected Runnable savingRunnable;
    protected Runnable closingRunnable;
    protected String modId;
    protected Screen parent;
    protected ConfigHotKey editedConfigHotkey = null;
    protected Consumer<Boolean> hotKeySaver = null;
    protected Component title = Component.m_237115_((String)"simpleconfig.config.title");
    protected boolean editable = true;
    protected boolean transparentBackground = false;
    protected ResourceLocation defaultBackground = new ResourceLocation("textures/gui/options_background.png");
    protected Consumer<Screen> afterInitConsumer = screen -> {};
    protected final EnumMap<SimpleConfig.EditType, Map<String, ConfigCategoryBuilder>> categories = (EnumMap)Util.m_137469_(new EnumMap(SimpleConfig.EditType.class), m -> {
        for (SimpleConfig.EditType type : SimpleConfig.EditType.values()) {
            m.put(type, new LinkedHashMap());
        }
    });
    protected ConfigCategoryBuilder fallbackCategory = null;
    protected boolean alwaysShowTabs = false;
    @Nullable
    protected ConfigScreenBuilder.IConfigSnapshotHandler snapshotHandler;
    @Nullable
    protected ConfigScreenBuilder.IRemoteConfigProvider remoteConfigProvider;
    private ConfigCategoryBuilder selectedCategory;
    @Nullable
    private ConfigScreenBuilder.IConfigScreenGUIState previousGUIState = null;

    @ApiStatus.Internal
    public ConfigScreenBuilderImpl(String modId) {
        this.modId = modId;
    }

    @Override
    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @Override
    public ConfigScreenBuilder setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
        return this;
    }

    @Override
    public ConfigScreenBuilder setTransparentBackground(boolean transparent) {
        this.transparentBackground = transparent;
        return this;
    }

    @Override
    public boolean hasTransparentBackground() {
        return this.transparentBackground;
    }

    @Override
    public ConfigScreenBuilder setSnapshotHandler(ConfigScreenBuilder.IConfigSnapshotHandler handler) {
        this.snapshotHandler = handler;
        return this;
    }

    @Override
    public ConfigScreenBuilder setRemoteCommonConfigProvider(ConfigScreenBuilder.IRemoteConfigProvider provider) {
        this.remoteConfigProvider = provider;
        return this;
    }

    @Override
    public ConfigScreenBuilder setAfterInitConsumer(Consumer<Screen> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
        return this;
    }

    @Override
    public ConfigScreenBuilder setFallbackCategory(ConfigCategoryBuilder fallbackCategory) {
        this.fallbackCategory = fallbackCategory;
        return this;
    }

    @Override
    public Screen getParentScreen() {
        return this.parent;
    }

    @Override
    public ConfigScreenBuilder setParentScreen(Screen parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public ConfigScreenBuilder setTitle(Component title) {
        this.title = title;
        return this;
    }

    @Override
    public ConfigHotKey getEditedConfigHotKey() {
        return this.editedConfigHotkey;
    }

    @Override
    public Consumer<Boolean> getHotKeySaver() {
        return this.hotKeySaver;
    }

    @Override
    public ConfigScreenBuilder setEditedConfigHotKey(ConfigHotKey hotkey, Consumer<Boolean> hotKeySaver) {
        this.editedConfigHotkey = hotkey;
        this.hotKeySaver = hotKeySaver;
        return this;
    }

    @Override
    public ConfigCategoryBuilder getSelectedCategory() {
        return this.selectedCategory;
    }

    @Override
    public ConfigScreenBuilder setSelectedCategory(ConfigCategoryBuilder category) {
        this.selectedCategory = category;
        return this;
    }

    @Override
    @Nullable
    public ConfigScreenBuilder.IConfigScreenGUIState getPreviousGUIState() {
        return this.previousGUIState;
    }

    @Override
    public ConfigScreenBuilder setPreviousGUIState(@Nullable ConfigScreenBuilder.IConfigScreenGUIState state) {
        this.previousGUIState = state;
        return this;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public ConfigScreenBuilder setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Override
    public List<ConfigCategoryBuilder> getCategories(SimpleConfig.EditType type) {
        return new ArrayList<ConfigCategoryBuilder>(this.categories.get((Object)type).values());
    }

    @Override
    public ConfigCategoryBuilder getOrCreateCategory(String name, SimpleConfig.EditType type) {
        Map<String, ConfigCategoryBuilder> categories = this.categories.get((Object)type);
        ConfigCategoryBuilder cat = categories.computeIfAbsent(name, key -> new ConfigCategoryBuilderImpl(this, name, type));
        if (this.fallbackCategory == null) {
            this.fallbackCategory = cat;
        }
        return cat;
    }

    @Override
    public ConfigScreenBuilder removeCategory(String name, SimpleConfig.EditType type) {
        Map<String, ConfigCategoryBuilder> categories = this.categories.get((Object)type);
        if (!categories.containsKey(name)) {
            throw new IllegalArgumentException("Category " + name + " does not exist");
        }
        if (categories.get(name) == this.fallbackCategory) {
            this.fallbackCategory = null;
        }
        categories.remove(name);
        return this;
    }

    @Override
    public ConfigScreenBuilder removeCategoryIfExists(String name, SimpleConfig.EditType type) {
        Map<String, ConfigCategoryBuilder> categories = this.categories.get((Object)type);
        if (categories.containsKey(name)) {
            this.removeCategory(name, type);
        }
        return this;
    }

    @Override
    public boolean hasCategory(String name, SimpleConfig.EditType type) {
        Map<String, ConfigCategoryBuilder> categories = this.categories.get((Object)type);
        return categories.containsKey(name);
    }

    @Override
    public ResourceLocation getDefaultBackgroundTexture() {
        return this.defaultBackground;
    }

    @Override
    public ConfigScreenBuilder setDefaultBackgroundTexture(ResourceLocation texture) {
        this.defaultBackground = texture;
        return this;
    }

    @Override
    public Runnable getSavingRunnable() {
        return this.savingRunnable;
    }

    @Override
    public ConfigScreenBuilder setSavingRunnable(Runnable runnable) {
        this.savingRunnable = runnable;
        return this;
    }

    @Override
    public Runnable getClosingRunnable() {
        return this.closingRunnable;
    }

    @Override
    public ConfigScreenBuilder setClosingRunnable(Runnable runnable) {
        this.closingRunnable = runnable;
        return this;
    }

    @Override
    public Consumer<Screen> getAfterInitConsumer() {
        return this.afterInitConsumer;
    }

    @Override
    public AbstractConfigScreen build() {
        if (this.categories.values().stream().allMatch(Map::isEmpty) || this.fallbackCategory == null) {
            throw new IllegalStateException("Config screen without categories or fallback category");
        }
        ConfigCategoryBuilder selectedBuilder = this.selectedCategory != null ? this.selectedCategory : this.fallbackCategory;
        ConfigCategoryImpl selected = null;
        EnumMap<SimpleConfig.EditType, List> builtMap = new EnumMap<SimpleConfig.EditType, List>(SimpleConfig.EditType.class);
        for (Map.Entry<SimpleConfig.EditType, Map<String, ConfigCategoryBuilder>> e : this.categories.entrySet()) {
            List categories = builtMap.computeIfAbsent(e.getKey(), k -> new ArrayList());
            for (ConfigCategoryBuilder builder : e.getValue().values()) {
                ConfigCategoryImpl built = builder.build();
                categories.add(built);
                if (builder != selectedBuilder) continue;
                selected = built;
            }
        }
        SimpleConfigScreen screen = new SimpleConfigScreen(this.parent, this.modId, this.title, (Collection)builtMap.get((Object)SimpleConfig.EditType.CLIENT), (Collection<ConfigCategory>)((Collection)builtMap.get((Object)SimpleConfig.EditType.COMMON)), (Collection<ConfigCategory>)((Collection)builtMap.get((Object)SimpleConfig.EditType.SERVER_COMMON)), (Collection<ConfigCategory>)((Collection)builtMap.get((Object)SimpleConfig.EditType.SERVER)), this.defaultBackground);
        ((AbstractConfigScreen)screen).setEditedConfigHotKey(this.editedConfigHotkey, this.hotKeySaver);
        screen.setSavingRunnable(this.savingRunnable);
        screen.setClosingRunnable(this.closingRunnable);
        screen.setEditable(this.editable);
        ((AbstractConfigScreen)screen).setSelectedCategory(selected);
        screen.setTransparentBackground(this.transparentBackground);
        screen.setAlwaysShowTabs(this.alwaysShowTabs);
        screen.setAfterInitConsumer(this.afterInitConsumer);
        screen.setSnapshotHandler(this.snapshotHandler);
        ((AbstractConfigScreen)screen).setRemoteCommonConfigProvider(this.remoteConfigProvider);
        ((AbstractConfigScreen)screen).loadConfigScreenGUIState(this.previousGUIState);
        return screen;
    }

    public static class ConfigScreenGUIState
    implements ConfigScreenBuilder.IConfigScreenGUIState {
        private SimpleConfig.EditType editedType;
        private final Map<SimpleConfig.EditType, String> selectedCategories = new EnumMap<SimpleConfig.EditType, String>(SimpleConfig.EditType.class);
        private final Map<SimpleConfig.EditType, Map<String, ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState>> categoryStates = new EnumMap<SimpleConfig.EditType, Map<String, ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState>>(SimpleConfig.EditType.class);

        @Override
        public SimpleConfig.EditType getEditedType() {
            return this.editedType;
        }

        public void setEditedType(SimpleConfig.EditType editedType) {
            this.editedType = editedType;
        }

        @Override
        public Map<SimpleConfig.EditType, String> getSelectedCategories() {
            return this.selectedCategories;
        }

        @Override
        public Map<SimpleConfig.EditType, Map<String, ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState>> getCategoryStates() {
            return this.categoryStates;
        }

        public static class ConfigCategoryGUIState
        implements ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState {
            private final Map<String, Boolean> expandStates = new HashMap<String, Boolean>();
            private String selectedEntry;
            private int scrollOffset;

            @Override
            public Map<String, Boolean> getExpandStates() {
                return this.expandStates;
            }

            @Override
            public String getSelectedEntry() {
                return this.selectedEntry;
            }

            public void setSelectedEntry(String selectedEntry) {
                this.selectedEntry = selectedEntry;
            }

            @Override
            public int getScrollOffset() {
                return this.scrollOffset;
            }

            public void setScrollOffset(int scrollOffset) {
                this.scrollOffset = scrollOffset;
            }
        }
    }
}

