/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.impl;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigCategory;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategoryImpl
implements ConfigCategory {
    protected final List<AbstractConfigField<?>> entries;
    protected final String name;
    protected Component title;
    protected int sortingOrder;
    @Nullable
    protected ResourceLocation background;
    @Nullable
    protected Supplier<Optional<Component[]>> description;
    @Nullable
    protected Path containingFile;
    protected SimpleConfig.EditType type;
    protected boolean isEditable;
    protected Icon icon;
    protected int color;
    @Nullable
    protected final CompletableFuture<Boolean> loadingFuture;
    private boolean loaded;

    @ApiStatus.Internal
    public ConfigCategoryImpl(String name, SimpleConfig.EditType type, List<AbstractConfigField<?>> entries2, Component title, int sortingOrder, @Nullable ResourceLocation background, @Nullable Supplier<Optional<Component[]>> description, @Nullable Path containingFile, boolean isEditable, Icon icon, int color, @Nullable CompletableFuture<Function<ConfigCategory, Boolean>> loadingFuture) {
        this.entries = entries2;
        this.name = name;
        this.title = title;
        this.type = type;
        this.sortingOrder = sortingOrder;
        this.background = background;
        this.description = description;
        this.containingFile = containingFile;
        this.isEditable = isEditable;
        this.icon = icon;
        this.color = color;
        this.loadingFuture = loadingFuture != null ? loadingFuture.thenApply(f -> {
            this.loaded = (Boolean)f.apply(this);
            return this.loaded;
        }) : null;
    }

    private static <T> void finishLoadingField(AbstractConfigField<T> field) {
        field.setOriginal(field.getValue());
    }

    @Override
    public void finishLoadingEntries() {
        this.getAllMainEntries().forEach(ConfigCategoryImpl::finishLoadingField);
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(Component name) {
        this.title = name;
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.entries;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigCategory addEntry(AbstractConfigListEntry<?> entry) {
        this.entries.add(entry);
        return this;
    }

    @Override
    @ApiStatus.Internal
    public void removeEntry(String name) {
        this.entries.removeIf(e -> e.getName().equals(name));
    }

    @Override
    public Optional<Path> getContainingFile() {
        return Optional.ofNullable(this.containingFile);
    }

    @Override
    @Nullable
    public ResourceLocation getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@Nullable ResourceLocation background) {
        this.background = background;
    }

    @Override
    public SimpleConfig.EditType getType() {
        return this.type;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    @Override
    @Nullable
    public CompletableFuture<Boolean> getLoadingFuture() {
        return this.loadingFuture;
    }

    @Override
    public boolean isLoaded() {
        return this.loadingFuture == null || this.loaded;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public int getSortingOrder() {
        return this.sortingOrder;
    }

    @Override
    @Nullable
    public Supplier<Optional<Component[]>> getDescription() {
        return this.description;
    }
}

