/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.electronwill.nightconfig.core.CommentedConfig;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SimpleHotKeyActionType<V, S>
extends HotKeyActionType<V, SimpleHotKeyAction<V, S>> {
    protected final String translationKey;
    protected final ISimpleHotKeyAction<V, S> action;
    @Nullable
    protected final ISimpleHotKeyError<V, S> error;
    private static final Pattern COLON = Pattern.compile(":");

    public SimpleHotKeyActionType(String tagName, Icon icon, ISimpleHotKeyAction<V, S> action) {
        this(tagName, icon, action, null);
    }

    public SimpleHotKeyActionType(String tagName, Icon icon, ISimpleHotKeyAction<V, S> action, @Nullable ISimpleHotKeyError<V, S> error) {
        super(tagName.replace(':', '.'), icon);
        this.action = action;
        this.error = error;
        if (tagName.contains(":")) {
            String[] split = COLON.split(tagName, 2);
            this.translationKey = split[1];
        } else {
            this.translationKey = tagName;
        }
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public Component formatAction(SimpleHotKeyAction<V, S> action) {
        return Component.m_237110_((String)("simpleconfig.hotkey.type.action." + this.getTranslationKey()), (Object[])new Object[]{this.formatStorage(action.getStorage())});
    }

    public Component formatStorage(S storage) {
        String value = storage instanceof Float ? String.format("%.2f", storage) : (storage instanceof Double ? String.format("%.3f", storage) : String.valueOf(storage));
        return Component.m_237113_((String)value).m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Override
    @Nullable
    public <T, C, E extends AbstractConfigEntry<T, C, V>> SimpleHotKeyAction<V, S> deserialize(E entry, Object value) {
        if (value == null) {
            return null;
        }
        return new SimpleHotKeyAction<V, Object>(this, entry, this.action, value);
    }

    @Override
    public <T, C, E extends AbstractConfigEntry<T, C, V>> Object serialize(E entry, SimpleHotKeyAction<V, S> action) {
        return action.getStorage();
    }

    @Override
    public <T, C, E extends AbstractConfigEntry<T, C, V>> Optional<Component> getActionError(E entry, Object value) {
        try {
            return this.error != null ? this.error.getError(entry, value) : Optional.empty();
        }
        catch (ClassCastException e) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.command.error.set.invalid_type_generic"));
        }
    }

    @FunctionalInterface
    public static interface ISimpleHotKeyAction<V, S> {
        @Nullable
        public V applyValue(AbstractConfigEntry<?, ?, V> var1, V var2, S var3);
    }

    @FunctionalInterface
    public static interface ISimpleHotKeyError<V, S> {
        public Optional<Component> getError(AbstractConfigEntry<?, ?, V> var1, S var2);
    }

    public static class SimpleHotKeyAction<V, S>
    extends HotKeyAction<V> {
        private static final Logger LOGGER = LogManager.getLogger();
        private final AbstractConfigEntry<?, ?, V> entry;
        private final ISimpleHotKeyAction<V, S> action;
        private final S storage;
        private static final Pattern FLOATING_NUMBER = Pattern.compile("^[+-]?(?:\\d*\\.\\d+|\\d*\\.)$");

        public SimpleHotKeyAction(SimpleHotKeyActionType<V, S> type, AbstractConfigEntry<?, ?, V> entry, ISimpleHotKeyAction<V, S> action, S storage) {
            super(type);
            this.entry = entry;
            this.action = action;
            this.storage = storage;
        }

        @Override
        public SimpleHotKeyActionType<V, S> getType() {
            return (SimpleHotKeyActionType)super.getType();
        }

        public S getStorage() {
            return this.storage;
        }

        public AbstractConfigEntry<?, ?, V> getEntry() {
            return this.entry;
        }

        @Override
        @Nullable
        public <T, C, E extends AbstractConfigEntry<T, C, V>> Component apply(String path, E entry, CommentedConfig result) {
            boolean change;
            Component prev = this.formatValue(entry.getForCommand());
            T prevValue = entry.get();
            Object newValue = entry.fromGui(this.applyValue(entry.forGui(prevValue)));
            boolean success = entry.isValidValue(newValue);
            if (!success) {
                LOGGER.error(entry.getGlobalPath() + ": Error applying config hotkey, result value is not a valid value: " + newValue);
                newValue = entry.defValue;
            }
            Object v = newValue;
            Component set = this.formatValue(entry.forCommand(v));
            boolean bl = change = success && !Objects.equals(prevValue, v);
            if (success) {
                result.set(path, entry.apply(e -> e.forActualConfig(e.forConfig(v))));
            }
            MutableComponent report = this.formatPath(entry.getPath()).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)("simpleconfig.hotkey.type.report." + ((SimpleHotKeyActionType)this.getType()).getTranslationKey()), (Object[])new Object[]{((SimpleHotKeyActionType)this.getType()).formatStorage(this.getStorage()), prev, set}).m_130940_(change ? ChatFormatting.WHITE : ChatFormatting.GRAY));
            if (!success) {
                report.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"simpleconfig.hotkey.report.failure").m_130940_(ChatFormatting.RED));
            }
            return report;
        }

        private MutableComponent formatPath(String path) {
            if (((String)path).length() > 60) {
                path = ((String)path).substring(0, 10) + "..." + ((String)path).substring(((String)path).length() - 47);
            }
            return Component.m_237113_((String)("[" + (String)path + "]")).m_130940_(ChatFormatting.LIGHT_PURPLE);
        }

        private Component formatValue(String value) {
            if (FLOATING_NUMBER.matcher(value).matches()) {
                double v = Double.parseDouble(value);
                value = String.format("%.3f", v);
            }
            return Component.m_237113_((String)value).m_130940_(ChatFormatting.DARK_AQUA);
        }

        @Nullable
        public V applyValue(V value) {
            try {
                return this.action.applyValue(this.entry, value, this.storage);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleHotKeyAction that = (SimpleHotKeyAction)o;
            return Objects.equals(this.entry, that.entry) && Objects.equals(this.action, that.action) && this.equalsStorage(this.storage, that.storage);
        }

        protected boolean equalsStorage(Object a, Object b) {
            if (a instanceof Number && b instanceof Number) {
                return Float.compare(((Number)a).floatValue(), ((Number)b).floatValue()) == 0;
            }
            return Objects.equals(a, b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.entry, this.action, this.storage);
        }
    }
}

