/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.SimpleConfigPaths;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.InfoDialog;
import endorh.simpleconfig.ui.gui.ProgressDialog;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import endorh.simpleconfig.ui.gui.widget.combobox.ComboBoxWidget;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyTreeView;
import endorh.simpleconfig.ui.hotkey.ResourceConfigHotKeyGroupHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SavedHotKeyGroupPickerWidget
extends AbstractContainerEventHandler
implements IPositionableRenderable.IRectanglePositionableRenderable {
    public static boolean skipOverwriteDialog = false;
    protected final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    protected final Rectangle area = new Rectangle(0, 0, 100, 20);
    private final Supplier<IDialogCapableScreen> screen;
    protected final IOverlayCapableContainer overlayContainer;
    protected final ConfigHotKeyTreeView tree;
    protected MultiFunctionImageButton loadButton;
    protected MultiFunctionImageButton saveButton;
    protected ComboBoxWidget<SavedHotKeyGroup> selector;
    protected long UPDATE_INTERVAL = 2000L;
    protected long lastUpdate = 0L;
    protected CompletableFuture<List<RemoteSavedHotKeyGroup>> lastFuture;
    protected List<LocalSavedHotKeyGroup> localGroups = Lists.newArrayList();
    protected List<RemoteSavedHotKeyGroup> remoteGroups = Lists.newArrayList();
    protected List<ResourceSavedHotKeyGroup> resourceGroups = Lists.newArrayList();

    public SavedHotKeyGroupPickerWidget(Supplier<IDialogCapableScreen> screen, IOverlayCapableContainer overlayContainer, ConfigHotKeyTreeView tree) {
        this.screen = screen;
        this.overlayContainer = overlayContainer;
        this.tree = tree;
        this.loadButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.LOAD, MultiFunctionImageButton.ButtonAction.of(this::load).active(() -> this.selector.getValue() != null).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.load_group")));
        this.saveButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.SAVE, MultiFunctionImageButton.ButtonAction.of(() -> this.saveLocal(false)).active(() -> !this.selector.getText().isEmpty() && tree.getFocusedEntry() instanceof ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.save_group.local"))).on(MultiFunctionImageButton.Modifier.SHIFT, MultiFunctionImageButton.ButtonAction.of(() -> this.saveRemote(false)).icon(SimpleConfigIcons.Buttons.SAVE_REMOTE).active(() -> !this.selector.getText().isEmpty() && tree.getFocusedEntry() instanceof ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry && ServerConfig.permissions.canEditServerHotKeys()).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.save_group.remote"))).on(MultiFunctionImageButton.Modifier.ALT, MultiFunctionImageButton.ButtonAction.of(() -> this.delete(true)).icon(SimpleConfigIcons.Buttons.DELETE).active(() -> {
            SavedHotKeyGroup value = this.selector.getValue();
            return value instanceof WritableSavedHotKeyGroup && ((WritableSavedHotKeyGroup)value).canWrite();
        }).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.delete_group")));
        this.selector = new ComboBoxWidget<SavedHotKeyGroup>(new SavedHotKeyGroupWrapper(this), () -> overlayContainer, 0, 0, 80, 18);
        this.selector.setSuggestionProvider(new SimpleComboBoxModel(this::getSavedGroups));
        this.selector.setHint((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.hint"));
        Stream.of(new AbstractWidget[]{this.selector, this.loadButton, this.saveButton}).forEach(this.listeners::add);
    }

    public IDialogCapableScreen getScreen() {
        IDialogCapableScreen screen = this.screen.get();
        if (screen == null) {
            throw new IllegalStateException("Cannot get screen so early!");
        }
        return screen;
    }

    public boolean m_93696_() {
        return this.selector.m_93696_() || this.loadButton.m_93696_() || this.saveButton.m_93696_();
    }

    public void m_93692_(boolean focused) {
        if (focused == this.m_93696_()) {
            return;
        }
        if (focused) {
            this.m_7522_((GuiEventListener)this.selector);
            this.selector.m_93692_(true);
        }
        super.m_93692_(focused);
    }

    @Override
    public Rectangle getArea() {
        return this.area;
    }

    @Nullable
    protected ConfigHotKeyManager.ConfigHotKeyGroup getFocusedGroup() {
        ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry entry;
        for (entry = (ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry)this.tree.getFocusedEntry(); entry != null && !(entry instanceof ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry); entry = (ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry)entry.getParent()) {
        }
        if (entry == null) {
            return null;
        }
        return ((ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry)entry).buildGroup();
    }

    public boolean existsGroup(String name, List<? extends SavedHotKeyGroup> groups) {
        return groups.stream().anyMatch(g -> name.equals(g.getName()));
    }

    public void load() {
        SavedHotKeyGroup group2 = this.selector.getValue();
        if (group2 != null) {
            String rr = group2 instanceof ResourceSavedHotKeyGroup ? "resource" : (group2 instanceof RemoteSavedHotKeyGroup ? "remote" : "local");
            MutableComponent displayName = Component.m_237113_((String)group2.getName()).m_130940_(ChatFormatting.LIGHT_PURPLE);
            this.getScreen().addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.loading"), group2.load().thenAccept(g -> {
                if (g != null) {
                    this.tree.tryAddEntry(new ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry(this.tree::getDialogScreen, this.tree::getOverlayContainer, (ConfigHotKeyManager.ConfigHotKeyGroup)g));
                }
            }), d -> {
                d.setBody(SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.loading." + rr, displayName));
                d.setSuccessDialog(InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.loaded"), SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.loaded." + rr, displayName)));
            }));
        }
    }

    protected boolean showConfirmDialog(String intent, String overwrite, Component name, Runnable action, @Nullable Runnable alternative) {
        boolean mistaken;
        boolean bl = mistaken = !intent.equals(overwrite);
        if (!mistaken && skipOverwriteDialog) {
            return false;
        }
        String problem = mistaken ? "mistaken" : "overwrite";
        List<Component> body = SimpleConfigTextUtil.splitTtc("simpleconfig.ui.saved_hotkeys." + problem + "." + overwrite, name);
        if (mistaken) {
            body.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.saved_hotkeys.mistaken.question." + intent, new Object[0]));
        } else {
            body.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.saved_hotkeys.overwrite.question", new Object[0]));
        }
        this.getScreen().addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)("simpleconfig.ui.saved_hotkeys." + problem)), d -> {
            d.setBody(body);
            d.setConfirmText((Component)Component.m_237115_((String)(mistaken ? "simpleconfig.ui.saved_hotkeys.mistaken.option.create." + intent : "simpleconfig.ui.confirm_overwrite.overwrite")));
            d.setConfirmButtonTint("remote".equals(intent) ? 1686151423 : 1686175648);
            if (mistaken) {
                d.withAction(b -> {
                    if (b) {
                        action.run();
                    }
                });
                if (alternative != null && !"resource".equals(overwrite)) {
                    d.addButton(1, (AbstractWidget)TintedButton.of((Component)Component.m_237115_((String)"simpleconfig.ui.confirm_overwrite.overwrite"), "remote".equals(overwrite) ? 1686151423 : 1686175648, p -> {
                        d.cancel(false);
                        alternative.run();
                    }));
                }
            } else {
                d.withCheckBoxes((b, c) -> {
                    if (b) {
                        skipOverwriteDialog = c[0];
                        action.run();
                    }
                }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again_this_session")));
            }
        }));
        return true;
    }

    public void saveLocal(boolean overwrite) {
        ConfigHotKeyManager.ConfigHotKeyGroup g = this.getFocusedGroup();
        if (g == null) {
            return;
        }
        LocalSavedHotKeyGroup group2 = SavedHotKeyGroup.local(this.selector.getText());
        String name = group2.getName();
        MutableComponent displayName = Component.m_237113_((String)name).m_130940_(ChatFormatting.LIGHT_PURPLE);
        if (!overwrite) {
            String oo = null;
            if (this.existsGroup(name, this.localGroups)) {
                oo = "local";
            } else if (this.existsGroup(name, this.remoteGroups)) {
                oo = "remote";
            } else if (this.existsGroup(name, this.resourceGroups)) {
                oo = "resource";
            }
            if (oo != null && this.showConfirmDialog("local", oo, (Component)displayName, () -> this.saveLocal(true), () -> this.saveRemote(true))) {
                return;
            }
        }
        File file = group2.getFile();
        this.getScreen().addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.saving"), group2.save(g), d -> {
            d.setCancellableByUser(false);
            d.setBody(SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.saving.local", displayName));
            d.setSuccessDialog(InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.saved"), SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.saved.local", displayName, "simpleconfig.ui.saved_hotkeys.saved.file", Component.m_237113_((String)SimpleConfigPaths.relativize(file.toPath()).toString()).m_130938_(s -> s.m_131162_(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy"))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, file.getAbsolutePath()))))));
        }));
    }

    public void saveRemote(boolean overwrite) {
        ConfigHotKeyManager.ConfigHotKeyGroup g = this.getFocusedGroup();
        if (g == null) {
            return;
        }
        RemoteSavedHotKeyGroup group2 = SavedHotKeyGroup.remote(this.selector.getText());
        String name = group2.getName();
        MutableComponent displayName = Component.m_237113_((String)name).m_130940_(ChatFormatting.LIGHT_PURPLE);
        if (!overwrite) {
            String oo = null;
            if (this.existsGroup(name, this.remoteGroups)) {
                oo = "remote";
            } else if (this.existsGroup(name, this.localGroups)) {
                oo = "local";
            } else if (this.existsGroup(name, this.resourceGroups)) {
                oo = "resource";
            }
            if (oo != null && this.showConfirmDialog("remote", oo, (Component)displayName, () -> this.saveRemote(true), () -> this.saveLocal(true))) {
                return;
            }
        }
        if (group2.canWrite()) {
            this.getScreen().addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.saving"), group2.save(g), d -> {
                d.setCancellableByUser(false);
                d.setBody(SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.saving.remote", displayName));
                d.setSuccessDialog(InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.saved"), SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.saved.remote", displayName)));
            }));
        }
    }

    public void delete(boolean confirm2) {
        WritableSavedHotKeyGroup writable;
        SavedHotKeyGroup value = this.selector.getValue();
        if (value instanceof WritableSavedHotKeyGroup && (writable = (WritableSavedHotKeyGroup)value).canWrite()) {
            String rr;
            MutableComponent displayName = Component.m_237113_((String)writable.getName()).m_130940_(ChatFormatting.LIGHT_PURPLE);
            String string = rr = writable instanceof RemoteSavedHotKeyGroup ? "remote" : "local";
            if (confirm2) {
                this.getScreen().addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.confirm.delete.title"), d -> {
                    d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.saved_hotkeys.confirm.delete.body." + rr, displayName));
                    d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.confirm.delete"));
                    d.setConfirmButtonTint(-2135088092);
                    d.withAction(b -> {
                        if (b) {
                            this.delete(false);
                        }
                    });
                }));
            } else {
                this.getScreen().addDialog(ProgressDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.deleting"), writable.delete(), d -> {
                    d.setCancellableByUser(false);
                    d.setBody(SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.deleting." + rr, displayName));
                    d.setSuccessDialog(InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.saved_hotkeys.deleted"), SimpleConfigTextUtil.paragraph("simpleconfig.ui.saved_hotkeys.deleted." + rr, displayName)));
                }));
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate > this.UPDATE_INTERVAL) {
            this.lastUpdate = time;
            this.update();
        }
        Rectangle area = this.getArea();
        this.selector.m_264152_(area.x + 1, area.y + 2);
        this.selector.m_93674_(area.width - 42);
        this.selector.setHeight(area.height - 4);
        int x1 = area.getMaxX() - 40;
        this.loadButton.m_264152_(x1, area.y);
        int x = area.getMaxX() - 20;
        this.saveButton.m_264152_(x, area.y);
        this.selector.m_88315_(gg, mouseX, mouseY, partialTicks);
        this.loadButton.m_88315_(gg, mouseX, mouseY, partialTicks);
        this.saveButton.m_88315_(gg, mouseX, mouseY, partialTicks);
    }

    protected void update() {
        this.localGroups = this.getLocalGroups();
        this.resourceGroups = ResourceConfigHotKeyGroupHandler.INSTANCE.getResourceHotKeyGroups();
        this.updateSelector();
        if (this.lastFuture == null) {
            this.lastFuture = SimpleConfigNetworkHandler.getRemoteSavedHotKeyGroups();
            this.lastFuture.thenAccept(g -> {
                this.remoteGroups = g;
                this.lastFuture = null;
                this.updateSelector();
            });
        }
    }

    protected void updateSelector() {
        this.selector.setText(this.selector.getText());
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    public List<SavedHotKeyGroup> getSavedGroups() {
        return Stream.of(this.localGroups, this.remoteGroups, this.resourceGroups).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<LocalSavedHotKeyGroup> getLocalGroups() {
        String YAML_EXT = ".yaml";
        File[] files = SimpleConfigPaths.LOCAL_HOTKEYS_DIR.toFile().listFiles((dir, name) -> name.endsWith(YAML_EXT));
        ArrayList<LocalSavedHotKeyGroup> list = new ArrayList<LocalSavedHotKeyGroup>();
        if (files != null) {
            for (File file : files) {
                String name2 = file.getName();
                list.add(SavedHotKeyGroup.local(name2.substring(0, name2.length() - YAML_EXT.length())));
            }
        }
        return list;
    }

    public static class SavedHotKeyGroupWrapper
    implements TypeWrapper<SavedHotKeyGroup> {
        private final SavedHotKeyGroupPickerWidget widget;

        public SavedHotKeyGroupWrapper(SavedHotKeyGroupPickerWidget widget) {
            this.widget = widget;
        }

        @Override
        public Pair<Optional<SavedHotKeyGroup>, Optional<Component>> parseElement(@NotNull String text) {
            SavedHotKeyGroup group2 = this.widget.getSavedGroups().stream().filter(g -> text.equals(g.getName())).findFirst().orElse(null);
            return Pair.of(Optional.ofNullable(group2), Optional.empty());
        }

        @Override
        public Component getDisplayName(@NotNull SavedHotKeyGroup element) {
            return element.getDisplayName();
        }

        @Override
        public boolean hasIcon() {
            return true;
        }

        @Override
        public Optional<Icon> getIcon(@Nullable SavedHotKeyGroup element, String text) {
            return element != null ? Optional.ofNullable(element.getIcon()) : (text.isEmpty() ? Optional.empty() : Optional.of(SimpleConfigIcons.Hotkeys.SAVE_HOTKEY));
        }

        @Override
        public int getIconHeight() {
            return 14;
        }

        @Override
        public int getIconWidth() {
            return 14;
        }
    }

    public static abstract class SavedHotKeyGroup {
        private static final Pattern HYPHEN = Pattern.compile(":");
        private final String name;

        public static LocalSavedHotKeyGroup local(String name) {
            return new LocalSavedHotKeyGroup(name);
        }

        public static RemoteSavedHotKeyGroup remote(String name) {
            return new RemoteSavedHotKeyGroup(name);
        }

        public static ResourceSavedHotKeyGroup resource(String name, ResourceLocation location) {
            return new ResourceSavedHotKeyGroup(name, location);
        }

        protected SavedHotKeyGroup(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public CompletableFuture<ConfigHotKeyManager.ConfigHotKeyGroup> load() {
            return this.loadData().thenApply(data -> ConfigHotKeyManager.INSTANCE.load(this.getName(), (byte[])data));
        }

        public abstract CompletableFuture<byte[]> loadData();

        protected static <T> CompletableFuture<T> failedFuture(Throwable throwable) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(throwable);
            return future;
        }

        public Component getDisplayName() {
            String name = this.getName();
            if (name.contains(":")) {
                String[] split = HYPHEN.split(name, 2);
                return Component.m_237113_((String)split[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)":").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.BOLD)).m_7220_((Component)Component.m_237113_((String)split[1]).m_130948_(this.getStyle()));
            }
            return Component.m_237113_((String)name).m_130948_(this.getStyle());
        }

        public Style getStyle() {
            return Style.f_131099_.m_131157_(ChatFormatting.WHITE);
        }

        public Icon getIcon() {
            return Icon.EMPTY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SavedHotKeyGroup that = (SavedHotKeyGroup)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class ResourceSavedHotKeyGroup
    extends SavedHotKeyGroup {
        private final ResourceLocation location;

        public ResourceSavedHotKeyGroup(String name, ResourceLocation location) {
            super(name);
            this.location = location;
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        protected InputStream getInputStream() throws IOException {
            return Minecraft.m_91087_().m_91098_().m_215593_(this.getLocation()).m_215507_();
        }

        @Override
        public CompletableFuture<byte[]> loadData() {
            try {
                return CompletableFuture.completedFuture(IOUtils.toByteArray((InputStream)this.getInputStream()));
            }
            catch (IOException e) {
                return ResourceSavedHotKeyGroup.failedFuture(e);
            }
        }

        @Override
        public Style getStyle() {
            return Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN);
        }

        @Override
        public Icon getIcon() {
            return SimpleConfigIcons.Hotkeys.RESOURCE_HOTKEY;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ResourceSavedHotKeyGroup that = (ResourceSavedHotKeyGroup)o;
            return this.location.equals((Object)that.location);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.location);
        }
    }

    public static class RemoteSavedHotKeyGroup
    extends WritableSavedHotKeyGroup {
        protected RemoteSavedHotKeyGroup(String name) {
            super(name);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean canWrite() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return false;
            }
            return ServerConfig.permissions.canEditServerHotKeys((Player)player);
        }

        @Override
        public CompletableFuture<byte[]> loadData() {
            return SimpleConfigNetworkHandler.getRemoteSavedHotKeyGroup(this.getName());
        }

        @Override
        public CompletableFuture<Boolean> saveData(byte[] fileData) {
            return SimpleConfigNetworkHandler.saveRemoteHotKeyGroup(this.getName(), fileData);
        }

        @Override
        public CompletableFuture<Boolean> delete() {
            return this.saveData(null);
        }

        @Override
        public Style getStyle() {
            return Style.f_131099_.m_131157_(ChatFormatting.AQUA);
        }

        @Override
        public Icon getIcon() {
            return SimpleConfigIcons.Hotkeys.REMOTE_HOTKEY;
        }
    }

    public static class LocalSavedHotKeyGroup
    extends WritableSavedHotKeyGroup {
        protected LocalSavedHotKeyGroup(String name) {
            super(name);
        }

        public File getFile() {
            return SimpleConfigPaths.LOCAL_HOTKEYS_DIR.resolve(this.getName() + ".yaml").toFile();
        }

        @Override
        public CompletableFuture<byte[]> loadData() {
            try {
                return CompletableFuture.completedFuture(FileUtils.readFileToByteArray((File)this.getFile()));
            }
            catch (IOException e) {
                return LocalSavedHotKeyGroup.failedFuture(e);
            }
        }

        @Override
        public CompletableFuture<Boolean> saveData(byte[] fileData) {
            try {
                FileUtils.writeByteArrayToFile((File)this.getFile(), (byte[])fileData);
                return CompletableFuture.completedFuture(true);
            }
            catch (IOException e) {
                return LocalSavedHotKeyGroup.failedFuture(e);
            }
        }

        @Override
        public CompletableFuture<Boolean> delete() {
            File file = this.getFile();
            if (file.isFile()) {
                if (!file.delete()) {
                    return LocalSavedHotKeyGroup.failedFuture(new IOException("Failed to delete file: " + file));
                }
                return CompletableFuture.completedFuture(true);
            }
            return LocalSavedHotKeyGroup.failedFuture(new FileNotFoundException("File not found: " + file));
        }

        @Override
        public Style getStyle() {
            return Style.f_131099_.m_131157_(ChatFormatting.GREEN);
        }

        @Override
        public Icon getIcon() {
            return SimpleConfigIcons.Hotkeys.LOCAL_HOTKEY;
        }
    }

    public static abstract class WritableSavedHotKeyGroup
    extends SavedHotKeyGroup {
        protected WritableSavedHotKeyGroup(String name) {
            super(name);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean canWrite() {
            return true;
        }

        public CompletableFuture<Boolean> save(ConfigHotKeyManager.ConfigHotKeyGroup group2) {
            return this.saveData(ConfigHotKeyManager.INSTANCE.dump(group2));
        }

        public abstract CompletableFuture<Boolean> saveData(byte[] var1);

        public abstract CompletableFuture<Boolean> delete();
    }
}

