/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.hotkey.SavedHotKeyGroupPickerWidget;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ResourceConfigHotKeyGroupHandler
extends SimplePreparableReloadListener<Loader> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceHotKeyGroupsDescriptor.class, (Object)new ResourceHotKeyGroupsDescriptor.Serializer()).create();
    private static final TypeToken<ResourceHotKeyGroupsDescriptor> TYPE = new TypeToken<ResourceHotKeyGroupsDescriptor>(){};
    public static final ResourceConfigHotKeyGroupHandler INSTANCE = new ResourceConfigHotKeyGroupHandler();
    private final Map<String, SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup> groupRegistry = Maps.newLinkedHashMap();

    public List<SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup> getResourceHotKeyGroups() {
        return new ArrayList<SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup>(this.groupRegistry.values());
    }

    @NotNull
    protected Loader prepare(@NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        Loader l = new Loader();
        profiler.m_7242_();
        for (String namespace : manager.m_7187_()) {
            profiler.m_6180_(namespace);
            try {
                for (Resource index : manager.m_213829_(new ResourceLocation(namespace, "config-hotkeys.json"))) {
                    profiler.m_6180_(index.m_215506_());
                    try (InputStream is = index.m_215507_();
                         InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        profiler.m_6180_("parse");
                        ResourceHotKeyGroupsDescriptor desc = (ResourceHotKeyGroupsDescriptor)GsonHelper.m_13767_((Gson)GSON, (Reader)r, TYPE);
                        profiler.m_6182_("register");
                        if (desc != null) {
                            l.registerGroups(namespace, desc);
                        }
                        profiler.m_7238_();
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Invalid config-hotkeys.json in resourcepack: '{}'", (Object)index.m_215506_(), (Object)e);
                    }
                    profiler.m_7238_();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            profiler.m_7238_();
        }
        profiler.m_7241_();
        return l;
    }

    protected void apply(@NotNull Loader l, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        this.groupRegistry.clear();
        l.getGroups().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.groupRegistry.put((String)e.getKey(), (SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup)e.getValue()));
    }

    public static class Loader {
        private final Map<String, SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup> groupMap = Maps.newHashMap();

        public void registerGroups(String namespace, ResourceHotKeyGroupsDescriptor descriptor) {
            for (String name2 : descriptor.groups()) {
                String groupName = namespace + ":" + name2;
                this.groupMap.put(groupName, SavedHotKeyGroupPickerWidget.SavedHotKeyGroup.resource(groupName, new ResourceLocation(namespace, "config-hotkeys/" + name2 + ".yaml")));
            }
            descriptor.defaultGroups().stream().sorted().forEach(name -> {
                String groupName = namespace + ":" + name;
                SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup group2 = SavedHotKeyGroupPickerWidget.SavedHotKeyGroup.resource(groupName, new ResourceLocation(namespace, "config-hotkeys/" + name + ".yaml"));
                this.groupMap.put(groupName, group2);
                try {
                    ConfigHotKeyManager.INSTANCE.addDefaultGroup(group2.load().get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
        }

        public Map<String, SavedHotKeyGroupPickerWidget.ResourceSavedHotKeyGroup> getGroups() {
            return this.groupMap;
        }
    }

    public record ResourceHotKeyGroupsDescriptor(Set<String> groups, Set<String> defaultGroups) {

        public static class Serializer
        implements JsonDeserializer<ResourceHotKeyGroupsDescriptor>,
        JsonSerializer<ResourceHotKeyGroupsDescriptor> {
            public ResourceHotKeyGroupsDescriptor deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject obj = GsonHelper.m_13918_((JsonElement)json, (String)"config hotkeys");
                JsonArray arr = GsonHelper.m_13832_((JsonObject)obj, (String)"groups", (JsonArray)new JsonArray());
                HashSet<String> set = new HashSet<String>();
                if (arr != null) {
                    for (JsonElement item : arr) {
                        set.add(GsonHelper.m_13805_((JsonElement)item, (String)"group name"));
                    }
                }
                arr = GsonHelper.m_13832_((JsonObject)obj, (String)"default_groups", (JsonArray)new JsonArray());
                HashSet<String> def = new HashSet<String>();
                if (arr != null) {
                    for (JsonElement item : arr) {
                        def.add(GsonHelper.m_13805_((JsonElement)item, (String)"group name"));
                    }
                }
                return new ResourceHotKeyGroupsDescriptor(set, def);
            }

            public JsonElement serialize(ResourceHotKeyGroupsDescriptor src, Type typeOfSrc, JsonSerializationContext ctx) {
                JsonObject obj = new JsonObject();
                obj.add("groups", ctx.serialize(new ArrayList<String>(src.groups)));
                obj.add("default_groups", ctx.serialize(new ArrayList<String>(src.defaultGroups)));
                return obj;
            }
        }
    }
}

