/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.electronwill.nightconfig.core.CommentedConfig;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NestedHotKeyActionType<V>
extends HotKeyActionType<V, NestedHotKeyAction<V>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INestedHotKeyAction<V> action;

    public NestedHotKeyActionType(String tagName, Icon icon, INestedHotKeyAction<V> action) {
        super(tagName, icon);
        this.action = action;
    }

    @Override
    @Nullable
    public <T, C, E extends AbstractConfigEntry<T, C, V>> NestedHotKeyAction<V> create(E entry, Object value) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        Map<String, AbstractConfigEntry<?, ?, ?>> entries2 = this.action.getEntries(entry, map.keySet());
        if (entries2 == null) {
            return null;
        }
        LinkedHashMap actions = new LinkedHashMap();
        map.forEach((key, field) -> actions.put((String)key, NestedHotKeyActionType.createHotKeyAction(field, (AbstractConfigEntry)entries2.get(key))));
        return new NestedHotKeyAction<V>(this, this.action, actions);
    }

    private static <T> HotKeyAction<T> createHotKeyAction(AbstractConfigField<T> field, AbstractConfigEntry<?, ?, ?> entry) {
        try {
            return field.createHotKeyAction(entry);
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    @Override
    @Nullable
    public <T, C, E extends AbstractConfigEntry<T, C, V>> NestedHotKeyAction<V> deserialize(E entry, Object value) {
        if (value instanceof Map) {
            Map m = (Map)value;
            LinkedHashMap<String, HotKeyActionWrapper> storages = new LinkedHashMap<String, HotKeyActionWrapper>();
            m.entrySet().stream().filter(e -> e.getKey() instanceof String && e.getValue() instanceof HotKeyActionWrapper).forEach(e -> storages.put((String)e.getKey(), (HotKeyActionWrapper)e.getValue()));
            Map<String, AbstractConfigEntry<?, ?, ?>> entries2 = this.action.getEntries(entry, storages.keySet());
            if (entries2 == null) {
                return null;
            }
            LinkedHashMap map = new LinkedHashMap();
            storages.forEach((key, wrapper) -> {
                AbstractConfigEntry e = (AbstractConfigEntry)entries2.get(key);
                if (e != null) {
                    map.put((String)key, NestedHotKeyActionType.deserializeNested(wrapper, entry, wrapper.value()));
                }
            });
            if (!map.isEmpty()) {
                return new NestedHotKeyAction<V>(this, this.action, map);
            }
        }
        return null;
    }

    protected static <V> HotKeyAction<V> deserializeNested(HotKeyActionWrapper<V, ?> wrapper, AbstractConfigEntry<?, ?, ?> entry, Object value) {
        try {
            return wrapper.type().deserialize(entry, value);
        }
        catch (ClassCastException e) {
            LOGGER.error("Could not deserialize hotkey action: " + entry.getGlobalPath(), (Throwable)e);
            return null;
        }
    }

    @Override
    public <T, C, E extends AbstractConfigEntry<T, C, V>> Object serialize(E entry, NestedHotKeyAction<V> action) {
        Map<String, HotKeyAction<?>> storage = action.getStorage();
        LinkedHashMap map = new LinkedHashMap();
        Map<String, AbstractConfigEntry<?, ?, ?>> entries2 = this.action.getEntries(entry, storage.keySet());
        if (entries2 == null) {
            return null;
        }
        storage.forEach((key, a) -> {
            AbstractConfigEntry e = (AbstractConfigEntry)entries2.get(key);
            HotKeyActionWrapper w = NestedHotKeyActionType.serializeNested(e, a);
            if (w != null) {
                map.put(key, w);
            }
        });
        return map;
    }

    protected static <V, A extends HotKeyAction<V>> HotKeyActionWrapper<V, A> serializeNested(AbstractConfigEntry<?, ?, ?> entry, A action) {
        try {
            AbstractConfigEntry<?, ?, ?> e = entry;
            HotKeyActionType<V, ?> type = action.getType();
            Object storage = type.serialize(e, action);
            return new HotKeyActionWrapper(type, storage);
        }
        catch (ClassCastException e) {
            LOGGER.error("Could not serialize hotkey action: " + entry.getGlobalPath(), (Throwable)e);
            return null;
        }
    }

    public static interface INestedHotKeyAction<V> {
        public static <V> INestedHotKeyAction<V> of(final BiFunction<AbstractConfigEntry<?, ?, V>, Set<String>, Map<String, AbstractConfigEntry<?, ?, ?>>> getter, final BiFunction<AbstractConfigEntry<?, ?, V>, CommentedConfig, Object> setter) {
            return new INestedHotKeyAction<V>(){

                @Override
                @Nullable
                public Map<String, AbstractConfigEntry<?, ?, ?>> getEntries(AbstractConfigEntry<?, ?, V> entry, Set<String> names) {
                    return (Map)getter.apply(entry, names);
                }

                @Override
                @Nullable
                public Object applyValue(AbstractConfigEntry<?, ?, V> entry, CommentedConfig values) {
                    return setter.apply(entry, values);
                }
            };
        }

        @Nullable
        public Map<String, AbstractConfigEntry<?, ?, ?>> getEntries(AbstractConfigEntry<?, ?, V> var1, Set<String> var2);

        @Nullable
        public Object applyValue(AbstractConfigEntry<?, ?, V> var1, CommentedConfig var2);
    }

    public static class NestedHotKeyAction<V>
    extends HotKeyAction<V> {
        private final INestedHotKeyAction<V> action;
        private final Map<String, HotKeyAction<?>> storage;

        public NestedHotKeyAction(HotKeyActionType<V, ?> type, INestedHotKeyAction<V> action, Map<String, HotKeyAction<?>> storage) {
            super(type);
            this.action = action;
            this.storage = storage;
        }

        @Override
        @Nullable
        public <T, C, E extends AbstractConfigEntry<T, C, V>> Component apply(String path, E entry, CommentedConfig result) {
            try {
                Map<String, AbstractConfigEntry<?, ?, ?>> entries2 = this.action.getEntries(entry, this.storage.keySet());
                if (entries2 == null) {
                    return null;
                }
                CommentedConfig config = CommentedConfig.inMemory();
                this.storage.forEach((name, action) -> {
                    try {
                        AbstractConfigEntry e = (AbstractConfigEntry)entries2.get(name);
                        if (e != null) {
                            action.apply((String)name, e, config);
                        }
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("Error applying hotkey action " + path + "." + name, (Throwable)e);
                    }
                });
                Object value = this.action.applyValue(entry, config);
                if (value != null) {
                    result.set(path, value);
                }
                return Component.m_237113_((String)"Testing... blip blap blop!");
            }
            catch (ClassCastException e) {
                LOGGER.error("Error applying hotkey action " + path, (Throwable)e);
                return null;
            }
        }

        public INestedHotKeyAction<V> getAction() {
            return this.action;
        }

        public Map<String, HotKeyAction<?>> getStorage() {
            return this.storage;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NestedHotKeyAction that = (NestedHotKeyAction)o;
            return this.action.equals(that.action) && this.storage.equals(that.storage);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.action, this.storage);
        }
    }
}

