/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class Keys {
    public static int FIRST_UNASSIGNED_KEY = -103;
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[\\s_-]++");
    private static final Object2IntMap<String> NAMES_TO_IDS = new Object2IntOpenHashMap();
    private static final Int2ObjectMap<String> IDS_TO_NAMES = new Int2ObjectOpenHashMap();
    private static final Map<String, String> TRANSLATION_OVERRIDES = new HashMap<String, String>();
    private static final IntSet MODIFIER_KEYS = (IntSet)Util.m_137469_((Object)new IntOpenHashSet(8), s -> IntStream.of(343, 347, 341, 345, 342, 346, 340, 344).forEach(arg_0 -> ((IntOpenHashSet)s).add(arg_0)));

    public static InputConstants.Key getInputFromName(String name) {
        name = SEPARATOR_PATTERN.matcher(name).replaceAll(".").toLowerCase();
        try {
            InputConstants.Key input;
            if (name.startsWith("mouse.") || name.startsWith("keyboard.")) {
                input = InputConstants.m_84851_((String)("key." + name));
            } else if (!name.contains(".")) {
                input = InputConstants.m_84851_((String)("key.keyboard." + name));
            } else {
                try {
                    input = InputConstants.m_84851_((String)name);
                }
                catch (IllegalArgumentException ignored) {
                    input = InputConstants.m_84851_((String)("key.keyboard." + name));
                }
            }
            return input;
        }
        catch (IllegalArgumentException e) {
            return InputConstants.f_84822_;
        }
    }

    public static InputConstants.Key getInputFromKey(int key) {
        if (key >= -100 && key < -1) {
            return InputConstants.Type.MOUSE.m_84895_(key + 100);
        }
        if (key <= -300) {
            return InputConstants.m_84827_((int)-1, (int)(-300 - key));
        }
        if (key >= 0) {
            return InputConstants.m_84827_((int)key, (int)-1);
        }
        return InputConstants.f_84822_;
    }

    public static int getKeyFromName(String name) {
        int key = NAMES_TO_IDS.getOrDefault((Object)name, -1);
        if (key != -1) {
            return key;
        }
        InputConstants.Key input = Keys.getInputFromName(name);
        return switch (input.m_84868_()) {
            case InputConstants.Type.MOUSE -> input.m_84873_() - 100;
            case InputConstants.Type.SCANCODE -> -300 - input.m_84873_();
            default -> input.m_84873_();
        };
    }

    public static String getNameForKey(int key) {
        String name = (String)IDS_TO_NAMES.get(key);
        if (name != null) {
            return name;
        }
        InputConstants.Key input = Keys.getInputFromKey(key);
        String keyName = input.m_84874_();
        if (keyName.startsWith("key.keyboard.")) {
            keyName = keyName.substring("key.keyboard.".length());
        } else if (keyName.startsWith("key.mouse.")) {
            keyName = keyName.substring("key.".length());
        }
        return keyName;
    }

    public static int getKeyFromInput(int keyCode, int scanCode) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        return input.m_84868_() == InputConstants.Type.SCANCODE ? -300 - input.m_84873_() : input.m_84873_();
    }

    public static int getKeyFromMouseInput(int button) {
        return button - 100;
    }

    public static int getKeyFromScroll(double scrollDelta) {
        return scrollDelta < 0.0 ? -102 : -101;
    }

    public static boolean isMouseKey(int key) {
        return key >= -100 && key < -1;
    }

    public static boolean isScrollKey(int key) {
        return key == -101 || key == -102;
    }

    public static boolean isKeyCode(int key) {
        return key >= 0;
    }

    public static boolean isScanCode(int key) {
        return key <= -300;
    }

    public static boolean isVirtualKey(int key) {
        return key <= FIRST_UNASSIGNED_KEY && key >= -300;
    }

    public static boolean isModifier(int key) {
        return MODIFIER_KEYS.contains(key);
    }

    public static MutableComponent getDisplayNameForKey(int key) {
        String translationKey;
        if (key == -1) {
            return Component.m_237115_((String)"key.abbrev.unknown");
        }
        InputConstants.Key input = null;
        if (key == -102) {
            translationKey = "key.mouse.scroll.down";
        } else if (key == -101) {
            translationKey = "key.mouse.scroll.up";
        } else {
            input = Keys.getInputFromKey(key);
            translationKey = input.m_84874_();
        }
        if (TRANSLATION_OVERRIDES.containsKey(translationKey)) {
            return Component.m_237115_((String)TRANSLATION_OVERRIDES.get(translationKey));
        }
        return input != null ? input.m_84875_().m_6881_() : Component.m_237115_((String)translationKey);
    }

    @Nullable
    public static String getCharFromKey(int key) {
        InputConstants.Key input = Keys.getInputFromKey(key);
        if (input.m_84868_() == InputConstants.Type.MOUSE || input.m_84873_() == -1) {
            return null;
        }
        if (input.m_84868_() == InputConstants.Type.KEYSYM) {
            return GLFW.glfwGetKeyName((int)input.m_84873_(), (int)-1);
        }
        return GLFW.glfwGetKeyName((int)-1, (int)input.m_84873_());
    }

    public static int getKeyFromChar(String ch) {
        Optional<InputConstants.Key> opt = Keys.getInputMap(InputConstants.Type.KEYSYM).values().stream().filter(i -> i.m_84873_() != -1 && ch.equals(GLFW.glfwGetKeyName((int)i.m_84873_(), (int)-1))).findFirst();
        if (opt.isPresent()) {
            return opt.get().m_84873_();
        }
        opt = Keys.getInputMap(InputConstants.Type.SCANCODE).values().stream().filter(i -> ch.equals(GLFW.glfwGetKeyName((int)-1, (int)i.m_84873_()))).findFirst();
        return opt.map(input -> -300 - input.m_84873_()).orElse(-1);
    }

    protected static Int2ObjectMap<InputConstants.Key> getInputMap(InputConstants.Type type) {
        return (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(InputConstants.Type.class, (Object)type, (String)"f_84885_");
    }

    private static void overrideTranslation(String key, String override) {
        TRANSLATION_OVERRIDES.put(key, override);
    }

    private static void addAlias(int keyCode, String name) {
        IDS_TO_NAMES.put(keyCode, (Object)name);
        NAMES_TO_IDS.put((Object)name, keyCode);
    }

    static {
        Keys.addAlias(-97, "mouse.back");
        Keys.addAlias(-96, "mouse.forwards");
        Keys.addAlias(-102, "mouse.scroll.down");
        Keys.addAlias(-101, "mouse.scroll.up");
        Keys.overrideTranslation("key.keyboard.left.control", "key.abbrev.left.control");
        Keys.overrideTranslation("key.keyboard.right.control", "key.abbrev.right.control");
        Keys.overrideTranslation("key.keyboard.left.alt", "key.abbrev.left.alt");
        Keys.overrideTranslation("key.keyboard.right.alt", "key.abbrev.right.alt");
        Keys.overrideTranslation("key.keyboard.left.shift", "key.abbrev.left.shift");
        Keys.overrideTranslation("key.keyboard.right.shift", "key.abbrev.right.shift");
        Keys.overrideTranslation("key.keyboard.left.win", "key.abbrev.left.win");
        Keys.overrideTranslation("key.keyboard.right.win", "key.abbrev.right.win");
        Keys.overrideTranslation("key.mouse.left", "key.abbrev.mouse.left");
        Keys.overrideTranslation("key.mouse.right", "key.abbrev.mouse.right");
        Keys.overrideTranslation("key.mouse.middle", "key.abbrev.mouse.middle");
        Keys.overrideTranslation("key.mouse.4", "key.abbrev.mouse.4");
        Keys.overrideTranslation("key.mouse.5", "key.abbrev.mouse.5");
        Keys.overrideTranslation("key.mouse.scroll.down", "key.abbrev.mouse.scroll.down");
        Keys.overrideTranslation("key.mouse.scroll.up", "key.abbrev.mouse.scroll.up");
        Keys.overrideTranslation("key.mouse.scroll.left", "key.abbrev.mouse.scroll.left");
        Keys.overrideTranslation("key.mouse.scroll.right", "key.abbrev.mouse.scroll.right");
    }
}

