/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.google.common.base.Splitter;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettingsBuilder;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.ui.hotkey.Keys;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyBindMappingImpl
implements KeyBindMapping {
    @NotNull
    private final IntList requiredKeys;
    @Nullable
    private final Int2ObjectMap<String> charMap;
    @NotNull
    private final ExtendedKeyBindSettings settings;
    private static final Pattern KEY_BIND_PATTERN = Pattern.compile("^(?<char>@)?+(?<exclusive>!)?+(?<order>>)?+(?<keys>.*?)(?<extra>!)?+(?<prevent>>)?+(?::(?<activation>\\w++))?+(?:#(?<context>\\w++))?+$");
    private static final Pattern CHARS_SORTED_PATTERN = Pattern.compile("^(?:\"[^\"]++\"|\\w++(?:\\.\\w++)*+)(?:>(?:\"[^\"]++\"|\\w++(?:\\.\\w++)*+))*+$");
    private static final Pattern CHARS_UNSORTED_PATTERN = Pattern.compile("^(?:\"[^\"]++\"|\\w++(?:\\.\\w++)*+)(?:\\+(?:\"[^\"]++\"|\\w++(?:\\.\\w++)*+))*+$");
    private static final Pattern KEYS_SORTED_PATTERN = Pattern.compile("^\\w++(?:\\.\\w++)*+(?:>\\w++(?:\\.\\w++)*+)*+$");
    private static final Pattern KEYS_UNSORTED_PATTERN = Pattern.compile("^\\w++(?:\\.\\w++)*+(?:\\+\\w++(?:\\.\\w++)*+)*+$");
    private static final Splitter UNORDERED_SPLITTER = Splitter.on((char)'+');
    private static final Splitter ORDERED_SPLITTER = Splitter.on((char)'>');

    @NotNull
    public static KeyBindMappingImpl unset() {
        return new KeyBindMappingImpl((IntList)new IntArrayList(), null, ExtendedKeyBindSettings.ingame().build());
    }

    @NotNull
    public static KeyBindMappingImpl unset(ExtendedKeyBindSettings settings) {
        return new KeyBindMappingImpl((IntList)new IntArrayList(), null, settings);
    }

    public KeyBindMappingImpl(@NotNull IntList requiredKeys, @Nullable Int2ObjectMap<String> charMap, @NotNull ExtendedKeyBindSettings settings) {
        this.requiredKeys = requiredKeys;
        this.charMap = charMap;
        this.settings = settings;
    }

    @Override
    @NotNull
    public IntList getRequiredKeys() {
        return this.requiredKeys;
    }

    @Override
    @Nullable
    public Int2ObjectMap<String> getCharMap() {
        return this.charMap;
    }

    @Override
    @NotNull
    public ExtendedKeyBindSettings getSettings() {
        return this.settings;
    }

    @Override
    public boolean isUnset() {
        return this.requiredKeys.isEmpty();
    }

    @Override
    public boolean overlaps(KeyBindMapping other) {
        boolean compareByChar;
        boolean otherIsRelease;
        int otherKeysSize;
        ExtendedKeyBindSettings settings = this.getSettings();
        ExtendedKeyBindSettings otherSettings = other.getSettings();
        if (!settings.context().conflictsWith(otherSettings.context()) || this.isUnset() || other.isUnset()) {
            return false;
        }
        IntList keys = this.getRequiredKeys();
        IntList otherKeys = other.getRequiredKeys();
        int keysSize = keys.size();
        if (keysSize < (otherKeysSize = otherKeys.size())) {
            return false;
        }
        KeyBindMapping.KeyBindActivation act = settings.activation();
        KeyBindMapping.KeyBindActivation otherAct = otherSettings.activation();
        boolean isRelease = (act == KeyBindMapping.KeyBindActivation.RELEASE || act == KeyBindMapping.KeyBindActivation.TOGGLE_RELEASE) && settings.exclusive();
        boolean bl = otherIsRelease = (otherAct == KeyBindMapping.KeyBindActivation.RELEASE || otherAct == KeyBindMapping.KeyBindActivation.TOGGLE_RELEASE) && otherSettings.exclusive();
        if (isRelease != otherIsRelease && act != KeyBindMapping.KeyBindActivation.BOTH && otherAct != KeyBindMapping.KeyBindActivation.BOTH) {
            return false;
        }
        boolean matchByChar = settings.matchByChar();
        boolean otherMatchByChar = otherSettings.matchByChar();
        Int2ObjectMap<String> charMap = this.getCharMap();
        Int2ObjectMap<String> otherCharMap = other.getCharMap();
        boolean bl2 = compareByChar = matchByChar || otherMatchByChar;
        assert (!matchByChar || charMap != null);
        assert (!otherMatchByChar || otherCharMap != null);
        if (settings.orderSensitive() && otherSettings.orderSensitive()) {
            boolean strict = !otherSettings.allowExtraKeys();
            int j = 0;
            block0: for (int i = 0; i < otherKeysSize; ++i) {
                int otherKey2 = otherKeys.getInt(i);
                while (j <= i + keysSize - otherKeysSize) {
                    int key = keys.getInt(j++);
                    if (compareByChar) {
                        String otherCh;
                        String ch = matchByChar ? (String)charMap.get(key) : Keys.getCharFromKey(key);
                        String string = otherCh = otherMatchByChar ? (String)otherCharMap.get(otherKey2) : Keys.getCharFromKey(otherKey2);
                        if (ch != null ? ch.equals(otherCh) : otherCh == null && key == otherKey2) {
                            continue block0;
                        }
                    } else if (!Keys.isVirtualKey(key) && key == otherKey2) continue block0;
                    if (!strict) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        IntOpenHashSet set = new IntOpenHashSet((IntCollection)keys);
        if (compareByChar) {
            HashSet charSet = charMap != null ? new HashSet(charMap.values()) : keys.intStream().mapToObj(Keys::getCharFromKey).filter(Objects::nonNull).collect(Collectors.toSet());
            return otherKeys.intStream().allMatch(otherKey -> {
                String otherChar = otherMatchByChar ? (String)otherCharMap.get(otherKey) : Keys.getCharFromKey(otherKey);
                return otherChar != null ? charSet.contains(otherChar) : set.contains(otherKey);
            });
        }
        return set.containsAll((IntCollection)otherKeys);
    }

    @Override
    @NotNull
    public KeyBindMapping copy() {
        return new KeyBindMappingImpl((IntList)new IntArrayList(this.requiredKeys), (Int2ObjectMap<String>)(this.charMap == null ? null : new Int2ObjectOpenHashMap(this.charMap)), this.settings.copy());
    }

    @Override
    @NotNull
    public Component getDisplayName(Style style) {
        ExtendedKeyBindSettings settings = this.getSettings();
        MutableComponent joiner = Component.m_237113_((String)(settings.orderSensitive() ? ">" : "+")).m_130940_(ChatFormatting.GRAY);
        if (this.requiredKeys.isEmpty()) {
            return Component.m_237119_();
        }
        MutableComponent r = Component.m_237113_((String)"");
        int first = this.requiredKeys.getInt(0);
        boolean matchByChar = settings.matchByChar();
        String firstChar = this.charMap != null ? (String)this.charMap.get(first) : null;
        r.m_7220_((Component)(matchByChar && firstChar != null ? this.formatKey(firstChar) : this.formatKey(first)).m_130948_(style));
        for (int i = 1; i < this.requiredKeys.size(); ++i) {
            int k = this.requiredKeys.getInt(i);
            String ch = this.charMap != null ? (String)this.charMap.get(k) : null;
            r.m_7220_((Component)joiner).m_7220_((Component)(matchByChar && ch != null ? this.formatKey(ch) : this.formatKey(k)).m_130948_(style));
        }
        return r;
    }

    @Override
    @NotNull
    public String serialize() {
        ExtendedKeyBindSettings settings = this.getSettings();
        String joiner = settings.orderSensitive() ? ">" : "+";
        boolean matchByChar = settings.matchByChar();
        String keys = this.requiredKeys.isEmpty() ? "unset" : (matchByChar ? this.requiredKeys.intStream().mapToObj(k -> {
            String ch = this.charMap != null ? (String)this.charMap.get(k) : null;
            return ch != null ? KeyBindMappingImpl.serializeKey(ch) : KeyBindMappingImpl.serializeKey(k);
        }).collect(Collectors.joining(joiner)) : this.requiredKeys.intStream().mapToObj(KeyBindMappingImpl::serializeKey).collect(Collectors.joining(joiner)));
        KeyBindMapping.KeyBindActivation activation = settings.activation();
        KeyBindMapping.KeyBindContext context = settings.context();
        String act = activation != KeyBindMapping.KeyBindActivation.PRESS ? activation.serialize() : "";
        String ctx = context != KeyBindMapping.VanillaKeyBindContext.GAME ? context.serialize() : "";
        StringBuilder b = new StringBuilder(keys.length() + act.length() + ctx.length() + 4);
        if (settings.matchByChar() && !keys.contains("\"")) {
            b.append('@');
        }
        if (settings.exclusive()) {
            b.append('!');
        }
        if (settings.orderSensitive() && this.requiredKeys.size() <= 1) {
            b.append('>');
        }
        b.append(keys);
        if (!settings.allowExtraKeys()) {
            b.append("!");
        }
        if (!settings.preventFurther()) {
            b.append(">");
        }
        if (!act.isEmpty()) {
            b.append(':');
            b.append(act);
        }
        if (!ctx.isEmpty()) {
            b.append('#');
            b.append(ctx);
        }
        return b.toString();
    }

    @NotNull
    public static KeyBindMappingImpl parse(String serialized) {
        Pattern pattern;
        Splitter splitter;
        Matcher m = KEY_BIND_PATTERN.matcher(serialized);
        ExtendedKeyBindSettingsBuilder settings = new ExtendedKeyBindSettingsBuilder();
        if (!m.matches()) {
            return new KeyBindMappingImpl((IntList)new IntArrayList(), null, settings.build());
        }
        if (m.group("exclusive") != null) {
            settings.setExclusive(true);
        }
        boolean orderSensitive = m.group("order") != null || m.group("keys").contains(">");
        settings.setOrderSensitive(orderSensitive);
        settings.setAllowExtraKeys(m.group("extra") == null);
        settings.setPreventFurther(m.group("prevent") == null);
        String keys = m.group("keys");
        boolean matchByChar = m.group("char") != null || keys.contains("\"");
        settings.setMatchByChar(matchByChar);
        String activation = m.group("activation");
        settings.withActivation(activation != null ? KeyBindMapping.KeyBindActivation.deserialize(activation) : KeyBindMapping.KeyBindActivation.PRESS);
        String context = m.group("context");
        settings.withContext(context != null ? KeyBindMapping.KeyBindContext.deserialize(context) : KeyBindMapping.VanillaKeyBindContext.GAME);
        Splitter splitter2 = splitter = orderSensitive ? ORDERED_SPLITTER : UNORDERED_SPLITTER;
        Pattern pattern2 = matchByChar ? (orderSensitive ? CHARS_SORTED_PATTERN : CHARS_UNSORTED_PATTERN) : (pattern = orderSensitive ? KEYS_SORTED_PATTERN : KEYS_UNSORTED_PATTERN);
        if (keys.equals("unset")) {
            return new KeyBindMappingImpl((IntList)new IntArrayList(), (Int2ObjectMap<String>)(matchByChar ? new Int2ObjectOpenHashMap() : null), settings.build());
        }
        if (!pattern.matcher(keys).matches()) {
            return new KeyBindMappingImpl((IntList)new IntArrayList(), null, settings.build());
        }
        if (matchByChar) {
            IntArrayList list = new IntArrayList();
            Int2ObjectOpenHashMap chars = new Int2ObjectOpenHashMap();
            int charIndex = Keys.FIRST_UNASSIGNED_KEY;
            for (String ch : splitter.split((CharSequence)keys)) {
                if (ch.startsWith("\"")) {
                    list.add(charIndex);
                    chars.put(charIndex++, (Object)KeyBindMappingImpl.deserializeChar(ch));
                    continue;
                }
                list.add(KeyBindMappingImpl.deserializeKey(ch));
            }
            return new KeyBindMappingImpl((IntList)list, (Int2ObjectMap<String>)chars, settings.build());
        }
        IntArrayList list = new IntArrayList();
        Iterable iter = splitter.split((CharSequence)keys);
        iter.forEach(s -> list.add(KeyBindMappingImpl.deserializeKey(s)));
        return new KeyBindMappingImpl((IntList)list, null, settings.build());
    }

    protected static String serializeKey(int key) {
        return Keys.getNameForKey(key);
    }

    protected static String serializeKey(String key) {
        return "\"" + key + "\"";
    }

    protected static int deserializeKey(String key) {
        return Keys.getKeyFromName(key);
    }

    protected static String deserializeChar(String key) {
        return key.substring(1, key.length() - 1);
    }

    protected MutableComponent formatKey(int key) {
        return Component.m_237113_((String)WordUtils.capitalize((String)Keys.getDisplayNameForKey(key).getString())).m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)(Keys.isMouseKey(key) || Keys.isScrollKey(key) ? 0xAAAAFF : (Keys.isScanCode(key) ? 0xAAFFFF : (Keys.isModifier(key) ? 0xEEEEEE : 0xFFFFFF))))));
    }

    protected MutableComponent formatKey(String key) {
        return Component.m_237113_((String)WordUtils.capitalize((String)key)).m_130940_(ChatFormatting.ITALIC);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBindMappingImpl that = (KeyBindMappingImpl)o;
        int size = this.requiredKeys.size();
        if (size != that.requiredKeys.size() || !this.settings.equals(that.settings)) {
            return false;
        }
        if (this.charMap == null || that.charMap == null) {
            return this.requiredKeys.equals(that.requiredKeys);
        }
        for (int i = 0; i < size; ++i) {
            String tch;
            int k = this.requiredKeys.getInt(i);
            int tk = that.requiredKeys.getInt(i);
            String ch = (String)this.charMap.get(k);
            if (ch == null != ((tch = (String)that.charMap.get(tk)) == null)) {
                return false;
            }
            if (!(ch == null ? k != tk : !ch.equals(tch))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.charMap == null) {
            return Objects.hash(this.requiredKeys, this.settings);
        }
        int hash = Objects.hash(this.settings);
        IntListIterator intListIterator = this.requiredKeys.iterator();
        while (intListIterator.hasNext()) {
            int k = (Integer)intListIterator.next();
            String ch = (String)this.charMap.get(k);
            hash = 31 * hash + (ch == null ? k : ch.hashCode());
        }
        return hash;
    }

    public String toString() {
        return this.serialize();
    }
}

