/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.mojang.blaze3d.platform.InputConstants;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.SimpleConfigGroup;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.SimpleConfigGUIManagerImpl;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.gui.AbstractButtonDialog;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyTreeView;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class HotKeyListDialog
extends AbstractButtonDialog {
    private final ConfigHotKeyTreeView treeView;

    public static AbstractDialog forModId(String modId) {
        return new HotKeyListDialog(modId);
    }

    public static AbstractDialog generic() {
        return new HotKeyListDialog(null);
    }

    public HotKeyListDialog(@Nullable String modId) {
        super((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.title"));
        TintedButton cancelButton = TintedButton.of(CommonComponents.f_130656_, p -> this.cancel(false));
        cancelButton.setTintColor(1694474368);
        this.addButton((AbstractWidget)cancelButton);
        TintedButton saveButton = TintedButton.of((Component)Component.m_237115_((String)"simpleconfig.ui.save"), p -> this.cancel(true));
        saveButton.setTintColor(1686175648);
        this.addButton((AbstractWidget)saveButton);
        this.treeView = new ConfigHotKeyTreeView(this::getScreen, this, ConfigHotKeyManager.INSTANCE.getHotKeys(), this::editHotKey);
        this.treeView.setContextModId(modId);
        this.treeView.setTransparent(true);
        this.bodyListeners.add(this.treeView);
    }

    public ConfigHotKeyTreeView getTreeView() {
        if (this.treeView == null) {
            throw new IllegalStateException("TreeView cannot be accessed until a screen is attached");
        }
        return this.treeView;
    }

    public void editHotKey(String modId, ConfigHotKey hotKey) {
        IDialogCapableScreen screen = (IDialogCapableScreen)this.getScreen();
        SimpleConfigGUIManagerImpl.INSTANCE.showConfigGUIForHotKey(modId, screen, this, hotKey);
        screen.removeDialog(this);
    }

    @Override
    public void tick(boolean top) {
        this.treeView.tick();
    }

    @Override
    public boolean canCopyText() {
        return false;
    }

    public boolean isEdited() {
        return !ConfigHotKeyManager.INSTANCE.getHotKeys().equals(this.getValue());
    }

    public ConfigHotKeyManager.ConfigHotKeyGroup getValue() {
        Object root = this.getTreeView().getRoot();
        if (!(root instanceof ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry)) {
            throw new IllegalStateException("Tree View root entry is not group");
        }
        return ((ConfigHotKeyTreeView.ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry)root).buildGroup();
    }

    @Override
    public void cancel(boolean success) {
        SimpleConfigGroup CONFIRM = SimpleConfigMod.CLIENT_CONFIG.getGroup("confirm");
        String SAVE_HOTKEYS = "save_hotkeys";
        String DISCARD_HOTKEYS = "discard_hotkeys";
        if (success) {
            if (ClientConfig.confirm.save_hotkeys && this.isEdited()) {
                ((IDialogCapableScreen)this.getScreen()).addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.save.title"), d -> {
                    d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.hotkey.dialog.save.body", new Object[0]));
                    d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.controls.general.save"));
                    d.setConfirmButtonTint(-2139029632);
                    d.withCheckBoxes((b, c) -> {
                        if (b) {
                            if (CONFIRM.hasGUI()) {
                                CONFIRM.setGUI(SAVE_HOTKEYS, !c[0]);
                            } else {
                                CONFIRM.set(SAVE_HOTKEYS, !c[0]);
                            }
                            this.save();
                            super.cancel(true);
                        }
                    }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again")));
                }));
            } else {
                this.save();
                this.getTreeView().removeCandidates();
                super.cancel(true);
            }
        } else if (ClientConfig.confirm.discard_hotkeys && this.isEdited()) {
            ((IDialogCapableScreen)this.getScreen()).addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.discard.title"), d -> {
                d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.hotkey.dialog.discard.body", new Object[0]));
                d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.controls.general.discard"));
                d.setConfirmButtonTint(-2130739072);
                d.withCheckBoxes((b, c) -> {
                    if (b) {
                        if (CONFIRM.hasGUI()) {
                            CONFIRM.setGUI(DISCARD_HOTKEYS, !c[0]);
                        } else {
                            CONFIRM.set(DISCARD_HOTKEYS, !c[0]);
                        }
                        super.cancel(false);
                    }
                }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again")));
            }));
        } else {
            this.getTreeView().removeCandidates();
            super.cancel(false);
        }
    }

    protected void save() {
        ConfigHotKeyManager.INSTANCE.updateHotKeys(this.getValue());
    }

    @Override
    protected void layout() {
        int w = Mth.m_14045_((int)((int)((double)((Screen)this.getScreen()).f_96543_ * 0.7)), (int)120, (int)800);
        int titleWidth = this.font.m_92852_((FormattedText)this.title);
        w = Math.max(w, titleWidth + 16);
        int h = Mth.m_14045_((int)(60 + this.getInnerHeight()), (int)68, (int)((int)((double)((Screen)this.getScreen()).f_96544_ * 0.9)));
        w = Math.max(w, this.buttons.size() * 80);
        w = Math.min(w, ((Screen)this.getScreen()).f_96543_ - 16);
        this.setWidth(w);
        this.setHeight(h);
        super.layout();
    }

    @Override
    public void renderInner(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        ConfigHotKeyTreeView treeView = this.getTreeView();
        treeView.setX(x);
        treeView.setY(y);
        treeView.setWidth(w);
        treeView.setHeight(h - 4);
        treeView.m_88315_(gg, mouseX, mouseY, delta);
    }

    @Override
    public int getInnerHeight() {
        return Mth.m_14045_((int)(this.getTreeView().getPreferredHeight() + 4), (int)64, (int)((int)((double)((Screen)this.getScreen()).f_96544_ * 0.9) - 60));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (SimpleConfigMod.KeyBindings.SAVE.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.cancel(true);
            return true;
        }
        boolean r = super.m_7933_(keyCode, scanCode, modifiers);
        if (!(r || keyCode != 265 && keyCode != 264)) {
            ConfigHotKeyTreeView treeView = this.getTreeView();
            this.m_7522_(treeView);
            return treeView.m_7933_(keyCode, scanCode, modifiers);
        }
        return r;
    }
}

