/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.electronwill.nightconfig.core.CommentedConfig;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.entry.AbstractRangedEntry;
import endorh.simpleconfig.core.entry.BeanEntry;
import endorh.simpleconfig.core.entry.BeanProxy;
import endorh.simpleconfig.core.entry.EntryPairEntry;
import endorh.simpleconfig.core.entry.EnumEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypeManager;
import endorh.simpleconfig.ui.hotkey.NestedHotKeyActionType;
import endorh.simpleconfig.ui.hotkey.SimpleHotKeyActionType;
import endorh.simpleconfig.ui.hotkey.StorageLessHotKeyActionType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class HotKeyActionTypes {
    public static final AssignHotKeyActionType ASSIGN = HotKeyActionTypes.reg(new AssignHotKeyActionType());
    public static final SimpleHotKeyActionType<Integer, Number> INT_ADD = HotKeyActionTypes.type("int:add", SimpleConfigIcons.Actions.ADD, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Mth.m_14045_((int)(a + b.intValue()), (int)min.intValue(), (int)max.intValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Integer, Number> INT_ADD_CYCLE = HotKeyActionTypes.type("int:cycle", SimpleConfigIcons.Actions.ADD_CYCLE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> {
        int mn = min.intValue();
        int mx = max.intValue();
        int r = mx - mn;
        return mn + (a + b.intValue() - mn + r) % r;
    }), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Integer, Number> INT_MUL = HotKeyActionTypes.type("int:mul", SimpleConfigIcons.Actions.MULTIPLY, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Mth.m_14045_((int)((int)((float)a.intValue() * b.floatValue())), (int)min.intValue(), (int)max.intValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Integer, Number> INT_DIV = HotKeyActionTypes.type("int:div", SimpleConfigIcons.Actions.DIVIDE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Mth.m_14045_((int)((int)((float)a.intValue() / b.floatValue())), (int)min.intValue(), (int)max.intValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Long, Number> LONG_ADD = HotKeyActionTypes.type("long:add", SimpleConfigIcons.Actions.ADD, HotKeyActionTypes.ranged((entry, a, b, min, max) -> (long)Mth.m_14008_((double)((double)a.longValue() + b.doubleValue()), (double)min.doubleValue(), (double)max.doubleValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Long, Number> LONG_ADD_CYCLE = HotKeyActionTypes.type("long:cycle", SimpleConfigIcons.Actions.ADD_CYCLE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> {
        long mn = min.longValue();
        long mx = max.longValue();
        long r = mx - mn;
        return mn + (a + b.longValue() - mn + r) % r;
    }), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Long, Number> LONG_MUL = HotKeyActionTypes.type("long:mul", SimpleConfigIcons.Actions.MULTIPLY, HotKeyActionTypes.ranged((entry, a, b, min, max) -> (long)Mth.m_14036_((float)((long)((double)a.longValue() * b.doubleValue())), (float)min.longValue(), (float)max.longValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Long, Number> LONG_DIV = HotKeyActionTypes.type("long:div", SimpleConfigIcons.Actions.DIVIDE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> (long)Mth.m_14008_((double)((double)a.longValue() / b.doubleValue()), (double)min.doubleValue(), (double)max.doubleValue())));
    public static final SimpleHotKeyActionType<Float, Number> FLOAT_ADD = HotKeyActionTypes.type("float:add", SimpleConfigIcons.Actions.ADD, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Float.valueOf(Mth.m_14036_((float)(a.floatValue() + b.floatValue()), (float)min.floatValue(), (float)max.floatValue()))), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Float, Number> FLOAT_ADD_CYCLE = HotKeyActionTypes.type("float:cycle", SimpleConfigIcons.Actions.ADD_CYCLE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> {
        float mn = min.floatValue();
        float mx = max.floatValue();
        float r = mx - mn;
        return Float.valueOf(mn + (a.floatValue() + b.floatValue() - mn + r) % r);
    }), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Float, Number> FLOAT_MULTIPLY = HotKeyActionTypes.type("float:mul", SimpleConfigIcons.Actions.MULTIPLY, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Float.valueOf(Mth.m_14036_((float)(a.floatValue() * b.floatValue()), (float)min.floatValue(), (float)max.floatValue()))), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Float, Number> FLOAT_DIVIDE = HotKeyActionTypes.type("float:div", SimpleConfigIcons.Actions.DIVIDE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> b.floatValue() == 0.0f ? null : Float.valueOf(Mth.m_14036_((float)(a.floatValue() / b.floatValue()), (float)min.floatValue(), (float)max.floatValue()))), HotKeyActionTypes.divError());
    public static final SimpleHotKeyActionType<Double, Number> DOUBLE_ADD = HotKeyActionTypes.type("double:add", SimpleConfigIcons.Actions.ADD, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Mth.m_14008_((double)(a + b.doubleValue()), (double)min.doubleValue(), (double)max.doubleValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Double, Number> DOUBLE_ADD_CYCLE = HotKeyActionTypes.type("double:cycle", SimpleConfigIcons.Actions.ADD_CYCLE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> {
        double mn = min.doubleValue();
        double mx = max.doubleValue();
        double r = mx - mn;
        return mn + (a + b.doubleValue() - mn + r) % r;
    }), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Double, Number> DOUBLE_MULTIPLY = HotKeyActionTypes.type("double:mul", SimpleConfigIcons.Actions.MULTIPLY, HotKeyActionTypes.ranged((entry, a, b, min, max) -> Mth.m_14008_((double)(a * b.doubleValue()), (double)min.doubleValue(), (double)max.doubleValue())), HotKeyActionTypes.notNull());
    public static final SimpleHotKeyActionType<Double, Number> DOUBLE_DIVIDE = HotKeyActionTypes.type("double:div", SimpleConfigIcons.Actions.DIVIDE, HotKeyActionTypes.ranged((entry, a, b, min, max) -> b.doubleValue() == 0.0 ? null : Double.valueOf(Mth.m_14008_((double)(a / b.doubleValue()), (double)min.doubleValue(), (double)max.doubleValue()))), HotKeyActionTypes.divError());
    public static final EnumAddSimpleHotKeyActionType<Enum<?>> ENUM_ADD = HotKeyActionTypes.reg(new EnumAddSimpleHotKeyActionType());
    public static final StorageLessHotKeyActionType<Boolean> BOOLEAN_TOGGLE = HotKeyActionTypes.type("bool:toggle", SimpleConfigIcons.Actions.CYCLE, (AbstractConfigEntry<?, ?, V> entry, V b) -> b == false);

    public static <T extends HotKeyActionType<?, ?>> T type(T type) {
        HotKeyActionTypeManager.INSTANCE.register(type);
        return type;
    }

    public static <V, S, T extends SimpleHotKeyActionType<V, S>> T reg(T type) {
        HotKeyActionTypeManager.INSTANCE.register(type);
        return type;
    }

    public static <V, S> SimpleHotKeyActionType<V, S> type(String name, Icon button, SimpleHotKeyActionType.ISimpleHotKeyAction<V, S> action) {
        return HotKeyActionTypes.reg(new SimpleHotKeyActionType<V, S>(name, button, action));
    }

    public static <V, S> SimpleHotKeyActionType<V, S> type(String name, Icon button, SimpleHotKeyActionType.ISimpleHotKeyAction<V, S> action, SimpleHotKeyActionType.ISimpleHotKeyError<V, S> error) {
        return HotKeyActionTypes.reg(new SimpleHotKeyActionType<V, S>(name, button, action, error));
    }

    public static <V> StorageLessHotKeyActionType<V> type(String name, Icon button, StorageLessHotKeyActionType.IStorageLessHotKeyAction<V> action) {
        return HotKeyActionTypes.reg(new StorageLessHotKeyActionType<V>(name, button, action));
    }

    public static <V, S> SimpleHotKeyActionType.ISimpleHotKeyAction<V, S> ranged(IRangedSimpleHotKeyAction<V, S> action) {
        return (entry, value, serialized) -> {
            if (entry instanceof AbstractRangedEntry) {
                AbstractRangedEntry ranged = (AbstractRangedEntry)entry;
                Object min = ranged.getMin();
                Object max = ranged.getMax();
                if (min instanceof Number && max instanceof Number) {
                    return action.applyValue(entry, value, serialized, (Number)min, (Number)max);
                }
            }
            return null;
        };
    }

    protected static <V, S> SimpleHotKeyActionType.ISimpleHotKeyError<V, S> notNull() {
        return (entry, v) -> v == null ? Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value")) : Optional.empty();
    }

    protected static <V, S> SimpleHotKeyActionType.ISimpleHotKeyError<V, S> divError() {
        return (entry, v) -> {
            if (v == null) {
                return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value"));
            }
            if (v instanceof Number && ((Number)v).doubleValue() == 0.0) {
                return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.zero_div"));
            }
            return Optional.empty();
        };
    }

    @ApiStatus.Internal
    protected static void registerTypes() {
    }

    @FunctionalInterface
    public static interface IRangedSimpleHotKeyAction<V, S> {
        public V applyValue(AbstractConfigEntry<?, ?, V> var1, V var2, S var3, Number var4, Number var5);
    }

    public static class AssignHotKeyActionType
    extends SimpleHotKeyActionType<Object, Object> {
        public AssignHotKeyActionType() {
            super("assign", SimpleConfigIcons.Actions.ASSIGN, (entry, value, storage) -> storage);
        }

        @Override
        @Nullable
        public <T, C, E extends AbstractConfigEntry<T, C, Object>> SimpleHotKeyActionType.SimpleHotKeyAction<Object, Object> create(E entry, Object value) {
            return this.deserialize((AbstractConfigEntry)entry, entry.forActualConfig(entry.forConfig(entry.fromGuiOrDefault((Object)value))));
        }

        @Override
        @Nullable
        public <T, C, E extends AbstractConfigEntry<T, C, Object>> SimpleHotKeyActionType.SimpleHotKeyAction<Object, Object> deserialize(E entry, Object value) {
            T v = entry.fromConfig(entry.fromActualConfig(value));
            if (v == null) {
                return null;
            }
            Object g = entry.forGui(v);
            if (g == null) {
                return null;
            }
            return new SimpleHotKeyActionType.SimpleHotKeyAction<Object, Object>(this, entry, this.action, g);
        }

        @Override
        public <T, C, E extends AbstractConfigEntry<T, C, Object>> Object serialize(E entry, SimpleHotKeyActionType.SimpleHotKeyAction<Object, Object> action) {
            Object storage = action.getStorage();
            T v = entry.fromGui((Object)storage);
            if (v == null) {
                return null;
            }
            return entry.forActualConfig(entry.forConfig(v));
        }

        @Override
        public Component formatAction(SimpleHotKeyActionType.SimpleHotKeyAction<Object, Object> action) {
            return this.formatAction(action.getEntry(), action);
        }

        private <T> Component formatAction(AbstractConfigEntry<T, ?, Object> entry, SimpleHotKeyActionType.SimpleHotKeyAction<Object, Object> action) {
            String value = entry.forCommand(entry.fromGui(action.getStorage()));
            return Component.m_237110_((String)("simpleconfig.hotkey.type.action." + this.getTranslationKey()), (Object[])new Object[]{Component.m_237113_((String)(value != null ? value : "null")).m_130940_(ChatFormatting.DARK_AQUA)});
        }

        public <V> SimpleHotKeyActionType<V, V> cast() {
            return this;
        }
    }

    public static class EnumAddSimpleHotKeyActionType<E extends Enum<?>>
    extends SimpleHotKeyActionType<E, Integer> {
        public EnumAddSimpleHotKeyActionType() {
            super("enum.cycle", SimpleConfigIcons.Actions.ADD_CYCLE, (entry, value, storage) -> {
                EnumEntry e = (EnumEntry)entry;
                Set values = e.getAllowedValues();
                Object[] enums = Arrays.stream((Enum[])value.getClass().getEnumConstants()).filter(values::contains).toArray();
                return (Enum)enums[(enums.length + storage + value.ordinal()) % enums.length];
            });
        }

        public <T extends Enum<?>> EnumAddSimpleHotKeyActionType<T> cast() {
            return this;
        }

        @Override
        public <T, C, EE extends AbstractConfigEntry<T, C, E>> Optional<Component> getActionError(EE entry, Object value) {
            if (value == null) {
                return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value"));
            }
            return Optional.empty();
        }
    }

    public static class PairNestedHotKeyActionType<L, R>
    extends NestedHotKeyActionType<Pair<L, R>> {
        public PairNestedHotKeyActionType() {
            super("pair:sub", SimpleConfigIcons.Actions.NONE, NestedHotKeyActionType.INestedHotKeyAction.of((entry, names) -> {
                if (!(entry instanceof EntryPairEntry)) {
                    return null;
                }
                EntryPairEntry e = (EntryPairEntry)entry;
                LinkedHashMap<String, AbstractConfigEntry<Object, Object, Object>> map = new LinkedHashMap<String, AbstractConfigEntry<Object, Object, Object>>();
                if (names.contains("left")) {
                    map.put("left", e.leftEntry);
                }
                if (names.contains("right")) {
                    map.put("right", e.rightEntry);
                }
                return map;
            }, (entry, values) -> {
                if (!(entry instanceof EntryPairEntry)) {
                    return null;
                }
                EntryPairEntry e = (EntryPairEntry)entry;
                Pair value = e.apply(ee -> (Pair)ee.forGui((Pair)ee.get()));
                try {
                    return e.apply(ee -> ee.forActualConfig((Pair)ee.forConfig((Pair)ee.fromGuiOrDefault(Pair.of((Object)values.getOrElse("left", value.getLeft()), (Object)values.getOrElse("right", value.getRight()))))));
                }
                catch (ClassCastException ignored) {
                    return null;
                }
            }));
        }

        public <L, R> PairNestedHotKeyActionType<L, R> cast() {
            return this;
        }
    }

    public static class BeanHotKeyActionType<B>
    extends NestedHotKeyActionType<B> {
        public BeanHotKeyActionType() {
            super("bean:sub", SimpleConfigIcons.Actions.NONE, NestedHotKeyActionType.INestedHotKeyAction.of((entry, names) -> {
                if (!(entry instanceof BeanEntry)) {
                    return null;
                }
                BeanEntry e = (BeanEntry)entry;
                LinkedHashMap map = new LinkedHashMap();
                names.forEach(n -> {
                    AbstractConfigEntry<?, ?, ?> ee = e.getEntry((String)n);
                    if (ee != null) {
                        map.put(n, ee);
                    }
                });
                return map;
            }, (entry, values) -> {
                if (!(entry instanceof BeanEntry)) {
                    return null;
                }
                BeanEntry e = (BeanEntry)entry;
                BeanProxy proxy2 = e.getProxy();
                Object bean = proxy2.createFrom(e.get());
                for (CommentedConfig.Entry entry2 : values.entrySet()) {
                }
                return e.forActualConfig((Map<String, Object>)e.forConfig(bean));
            }));
        }

        public <BB> BeanHotKeyActionType<BB> cast() {
            return this;
        }
    }
}

