/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProxy;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.InputMatchingContext;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.ui.hotkey.KeyBindMappingImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedKeyBindImpl
implements ExtendedKeyBind {
    private final String modId;
    @NotNull
    private Component title;
    @NotNull
    private KeyBindMapping keyBind;
    @Nullable
    private Component candidateName;
    @Nullable
    private KeyBindMapping candidateDefinition;
    private final Runnable callback;
    private boolean pressed = false;
    private boolean pressedToggle = false;
    protected static final ExtendedKeyBindProxy.ExtendedKeyBindFactory FACTORY = new ExtendedKeyBindProxy.ExtendedKeyBindFactory(){

        @Override
        @NotNull
        public ExtendedKeyBind create(@Nullable String modId, Component title, KeyBindMapping definition, Runnable action) {
            return new ExtendedKeyBindImpl(modId, title, definition, action);
        }

        @Override
        @NotNull
        public KeyBindMapping parseMapping(String serialized) {
            return KeyBindMappingImpl.parse(serialized);
        }

        @Override
        @NotNull
        public KeyBindMapping unsetMapping(ExtendedKeyBindSettings settings) {
            return KeyBindMappingImpl.unset(settings);
        }
    };

    public ExtendedKeyBindImpl(Component title, KeyBindMapping keyBind, Runnable callback) {
        this(null, title, keyBind, callback);
    }

    public ExtendedKeyBindImpl(@Nullable String modId, @NotNull Component title, @NotNull KeyBindMapping keyBind, Runnable callback) {
        this.modId = modId;
        this.title = title;
        this.keyBind = keyBind;
        this.callback = callback;
    }

    @Override
    @Nullable
    public String getModId() {
        return this.modId;
    }

    @Override
    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(@NotNull Component title) {
        this.title = title;
    }

    @Override
    @NotNull
    public KeyBindMapping getDefinition() {
        return this.keyBind;
    }

    @Override
    public void setDefinition(@NotNull KeyBindMapping keyBind) {
        this.keyBind = keyBind;
    }

    public Component getCandidateName() {
        return this.candidateName != null ? this.candidateName : this.getTitle();
    }

    public void setCandidateName(@Nullable Component name) {
        this.candidateName = name;
    }

    public KeyBindMapping getCandidateDefinition() {
        return this.candidateDefinition != null ? this.candidateDefinition : this.getDefinition();
    }

    public void setCandidateDefinition(@Nullable KeyBindMapping definition) {
        this.candidateDefinition = definition;
    }

    @Override
    public boolean isPressed() {
        ExtendedKeyBindSettings settings = this.getDefinition().getSettings();
        KeyBindMapping.KeyBindActivation activation = settings.activation();
        return activation == KeyBindMapping.KeyBindActivation.TOGGLE ? this.pressedToggle : (activation == KeyBindMapping.KeyBindActivation.TOGGLE_RELEASE ? !this.pressedToggle : this.pressed);
    }

    @Override
    public boolean isPhysicallyPressed() {
        return this.pressed;
    }

    public boolean overlaps(ExtendedKeyBind other) {
        return this.getCandidateDefinition().overlaps(((ExtendedKeyBindImpl)other).getCandidateDefinition());
    }

    @Override
    @ApiStatus.Internal
    public void trigger() {
        this.callback.run();
    }

    @Override
    @ApiStatus.Internal
    public void updatePressed(InputMatchingContext context) {
        boolean matchByChar;
        KeyBindMapping keyBind = this.getDefinition();
        ExtendedKeyBindSettings settings = keyBind.getSettings();
        if (!settings.context().isActive() || context.isCancelled() || context.isTriggered() && settings.exclusive()) {
            context.getRepeatableKeyBinds().remove(this);
            this.pressed = false;
            return;
        }
        IntList requiredKeys = keyBind.getRequiredKeys();
        Int2ObjectMap<String> requiredChars = keyBind.getCharMap();
        boolean bl = matchByChar = settings.matchByChar() && requiredChars != null;
        if (requiredKeys.isEmpty()) {
            context.getRepeatableKeyBinds().remove(this);
            this.pressed = false;
            return;
        }
        boolean prevPressed = this.pressed;
        IntSet pressedKeys = context.getPressedKeys();
        IntList sortedKeys = context.getSortedPressedKeys();
        Int2ObjectMap<String> charMap = context.getCharMap();
        Set<String> pressedChars = context.getPressedChars();
        int pressedSize = pressedKeys.size();
        int requiredSize = requiredKeys.size();
        if (settings.allowExtraKeys() ? pressedSize >= requiredSize : pressedSize == requiredSize) {
            if (matchByChar) {
                this.pressed = true;
                IntListIterator intListIterator = requiredKeys.iterator();
                while (intListIterator.hasNext()) {
                    int key = (Integer)intListIterator.next();
                    String ch = (String)requiredChars.get(key);
                    if (!(ch != null ? !pressedChars.contains(ch) : !pressedKeys.contains(key))) continue;
                    this.pressed = false;
                    break;
                }
            } else {
                this.pressed = pressedKeys.containsAll((IntCollection)requiredKeys);
            }
            if (settings.orderSensitive()) {
                int pi = 0;
                int sizeDiff = pressedSize - requiredSize;
                if (matchByChar) {
                    block1: for (int i = 0; i < requiredSize; ++i) {
                        boolean isChar;
                        int key = requiredKeys.getInt(i);
                        String requiredChar = (String)requiredChars.get(key);
                        boolean bl2 = isChar = requiredChar != null;
                        while (pi <= sizeDiff + i) {
                            int pressedKey = sortedKeys.getInt(pi++);
                            String pressedChar = (String)charMap.get(pressedKey);
                            if (!(isChar ? requiredChar.equals(pressedChar) : pressedChar == null && key == pressedKey)) continue;
                            continue block1;
                        }
                        this.pressed = false;
                        break;
                    }
                } else {
                    block3: for (int i = 0; i < requiredSize; ++i) {
                        int key = requiredKeys.getInt(i);
                        while (pi <= sizeDiff + i) {
                            if (key != sortedKeys.getInt(pi++)) continue;
                            continue block3;
                        }
                        this.pressed = false;
                        break;
                    }
                }
            }
        } else {
            this.pressed = false;
        }
        KeyBindMapping.KeyBindActivation activation = settings.activation();
        if (!this.pressed) {
            context.getRepeatableKeyBinds().remove(this);
        }
        if (activation == KeyBindMapping.KeyBindActivation.TOGGLE && this.pressed && !prevPressed || activation == KeyBindMapping.KeyBindActivation.TOGGLE_RELEASE && !this.pressed && prevPressed) {
            boolean bl3 = this.pressedToggle = !this.pressedToggle;
        }
        if (this.pressed == prevPressed) {
            return;
        }
        if (this.pressed && !context.isPreventFurther() && settings.preventFurther()) {
            context.setPreventFurther(true);
        }
        if (activation == KeyBindMapping.KeyBindActivation.BOTH || activation == KeyBindMapping.KeyBindActivation.TOGGLE && this.pressed && this.pressedToggle || activation == KeyBindMapping.KeyBindActivation.TOGGLE_RELEASE && !this.pressed && this.pressedToggle || (activation == KeyBindMapping.KeyBindActivation.PRESS || activation == KeyBindMapping.KeyBindActivation.REPEAT) && this.pressed || activation == KeyBindMapping.KeyBindActivation.RELEASE && !this.pressed) {
            this.trigger();
            context.setTriggered(true);
            if (activation == KeyBindMapping.KeyBindActivation.REPEAT) {
                context.getRepeatableKeyBinds().add(this);
            }
        }
    }

    @Override
    @ApiStatus.Internal
    public void onRepeat() {
        ExtendedKeyBindSettings settings = this.getDefinition().getSettings();
        if (settings.activation() != KeyBindMapping.KeyBindActivation.REPEAT || !this.isPhysicallyPressed()) {
            return;
        }
        this.trigger();
    }

    public String toString() {
        return this.getTitle().getString() + ": " + this.getDefinition().getDisplayName().getString();
    }
}

