/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProvider;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProxy;
import endorh.simpleconfig.api.ui.hotkey.InputMatchingContext;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import endorh.simpleconfig.ui.hotkey.Keys;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class ExtendedKeyBindDispatcher {
    public static final ExtendedKeyBindDispatcher INSTANCE = new ExtendedKeyBindDispatcher();
    private static final IntSet AUTO_RELEASED_KEYS = (IntSet)Util.m_137469_((Object)new IntOpenHashSet(2), s -> IntStream.of(343, 347).forEach(arg_0 -> ((IntOpenHashSet)s).add(arg_0)));
    protected static final ExtendedKeyBindProxy.ExtendedKeyBindRegistrar REGISTRAR = new ExtendedKeyBindProxy.ExtendedKeyBindRegistrar(){

        @Override
        public void registerProvider(ExtendedKeyBindProvider provider) {
            ExtendedKeyBindDispatcher.registerProvider(provider);
        }

        @Override
        public void unregisterProvider(ExtendedKeyBindProvider provider) {
            ExtendedKeyBindDispatcher.unregisterProvider(provider);
        }
    };
    protected InputMatchingContext ctx = new InputMatchingContextImpl();
    protected WeakHashMap<ExtendedKeyBindProvider, ExtendedKeyBindProviderTicket> tickets = new WeakHashMap();
    protected SortedMap<ExtendedKeyBindProviderTicket, Integer> providers = new TreeMap<ExtendedKeyBindProviderTicket, Integer>();

    public static void registerProvider(ExtendedKeyBindProvider provider) {
        ExtendedKeyBindProviderTicket ticket = ExtendedKeyBindDispatcher.INSTANCE.tickets.computeIfAbsent(provider, p -> new ExtendedKeyBindProviderTicket(provider));
        ExtendedKeyBindDispatcher.INSTANCE.providers.remove(ticket);
        ExtendedKeyBindDispatcher.INSTANCE.providers.put(ticket, provider.getPriority());
    }

    public static void unregisterProvider(ExtendedKeyBindProvider provider) {
        ExtendedKeyBindProviderTicket ticket = ExtendedKeyBindDispatcher.INSTANCE.tickets.remove(provider);
        if (ticket != null) {
            ExtendedKeyBindDispatcher.INSTANCE.providers.remove(ticket);
        }
    }

    protected Collection<ExtendedKeyBindProvider> getSortedProviders() {
        Iterator<Map.Entry<ExtendedKeyBindProviderTicket, Integer>> iter = this.providers.entrySet().iterator();
        ArrayList<ExtendedKeyBindProviderTicket> added = new ArrayList<ExtendedKeyBindProviderTicket>();
        while (iter.hasNext()) {
            Map.Entry<ExtendedKeyBindProviderTicket, Integer> e = iter.next();
            ExtendedKeyBindProviderTicket ticket = e.getKey();
            ExtendedKeyBindProvider provider = ticket.getProvider();
            if (provider.getPriority() == e.getValue().intValue()) continue;
            iter.remove();
            added.add(ticket);
        }
        added.forEach(p -> this.providers.put((ExtendedKeyBindProviderTicket)p, p.getProvider().getPriority()));
        return this.providers.keySet().stream().map(ExtendedKeyBindProviderTicket::getProvider).collect(Collectors.toList());
    }

    protected boolean press(int key, int scanCode) {
        int k = Keys.getKeyFromInput(key, scanCode);
        Int2ObjectMap<String> charMap = this.ctx.getCharMap();
        if (!charMap.containsKey(k) && scanCode > 0) {
            String ch = GLFW.glfwGetKeyName((int)key, (int)scanCode);
            charMap.put(k, (Object)ch);
            if (ch != null) {
                this.ctx.getPressedChars().add(ch);
            }
        } else {
            String ch = (String)charMap.get(k);
            if (ch != null) {
                this.ctx.getPressedChars().add(ch);
            }
        }
        return this.press(k);
    }

    protected boolean press(int key) {
        this.ctx.setPreventFurther(false);
        this.ctx.getSortedPressedKeys().add(key);
        this.ctx.getPressedKeys().add(key);
        this.updateKeyBinds();
        return this.ctx.isPreventFurther();
    }

    protected boolean release(int key) {
        this.ctx.setPreventFurther(false);
        this.ctx.getSortedPressedKeys().remove((Object)key);
        IntSet pressedKeys = this.ctx.getPressedKeys();
        pressedKeys.remove(key);
        this.updateKeyBinds();
        if (pressedKeys.isEmpty() || pressedKeys.size() == 1 && AUTO_RELEASED_KEYS.containsAll((IntCollection)pressedKeys)) {
            this.resetContext();
        } else {
            String ch = (String)this.ctx.getCharMap().get(key);
            if (ch != null) {
                this.ctx.getPressedChars().remove(ch);
            }
        }
        return this.ctx.isPreventFurther();
    }

    public void resetContext() {
        this.ctx.getPressedKeys().clear();
        this.ctx.getSortedPressedKeys().clear();
        this.ctx.getCharMap().clear();
        this.ctx.getPressedChars().clear();
        this.ctx.getRepeatableKeyBinds().clear();
        this.ctx.setCancelled(false);
        this.ctx.setTriggered(false);
        this.ctx.setPreventFurther(false);
    }

    public void updateKeyBinds() {
        Collection<ExtendedKeyBindProvider> providers = this.getSortedProviders();
        if (!this.ctx.isCancelled()) {
            for (ExtendedKeyBindProvider ticket : providers) {
                for (ExtendedKeyBind keyBind : ticket.getActiveKeyBinds()) {
                    keyBind.updatePressed(this.ctx);
                    if (!this.ctx.isCancelled()) continue;
                    return;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onKeyInput(InputEvent.Key event) {
        int action = event.getAction();
        int key = event.getKey();
        int sc = event.getScanCode();
        boolean preventFurther = false;
        switch (action) {
            case 1: {
                preventFurther = this.press(key, sc);
                break;
            }
            case 0: {
                preventFurther = this.release(Keys.getKeyFromInput(key, sc));
                break;
            }
            case 2: {
                for (ExtendedKeyBind keyBind : this.ctx.getRepeatableKeyBinds()) {
                    keyBind.onRepeat();
                }
                break;
            }
        }
        if (preventFurther && action != 0) {
            KeyMapping.m_90847_();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        block6: {
            int action = event.getAction();
            int button = event.getButton();
            int key = Keys.getKeyFromMouseInput(button);
            switch (action) {
                case 1: {
                    if (this.press(key)) {
                        break;
                    }
                    break block6;
                }
                case 0: {
                    if (this.release(key)) {
                        break;
                    }
                    break block6;
                }
                default: {
                    break block6;
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        int key = Keys.getKeyFromScroll(event.getScrollDelta());
        boolean preventFurther = this.press(key, 0);
        if (preventFurther |= this.release(key)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMouseScrolledInGUI(ScreenEvent.MouseScrolled.Pre event) {
        int key = Keys.getKeyFromScroll(event.getScrollDelta());
        boolean preventFurther = this.press(key, 0);
        if (preventFurther |= this.release(key)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpenEvent(ScreenEvent.Opening event) {
        this.resetContext();
    }

    public List<ExtendedKeyBindImpl> getOverlaps(ExtendedKeyBindImpl keyBind) {
        return this.getSortedProviders().stream().flatMap(p -> StreamSupport.stream(p.getAllKeyBinds().spliterator(), false)).filter(o -> o instanceof ExtendedKeyBindImpl && keyBind != o && keyBind.overlaps((ExtendedKeyBind)o)).map(o -> (ExtendedKeyBindImpl)o).collect(Collectors.toList());
    }

    public List<ExtendedKeyBindImpl> getOverlaps(KeyBindMapping mapping) {
        return this.getSortedProviders().stream().flatMap(p -> StreamSupport.stream(p.getAllKeyBinds().spliterator(), false)).filter(o -> o instanceof ExtendedKeyBindImpl).map(o -> (ExtendedKeyBindImpl)o).filter(o -> mapping.overlaps(o.getCandidateDefinition())).collect(Collectors.toList());
    }

    public static class InputMatchingContextImpl
    implements InputMatchingContext {
        private final IntList sortedPressedKeys = new IntArrayList();
        private final IntSet pressedKeys = new IntOpenHashSet();
        private final Int2ObjectMap<String> charMap = new Int2ObjectOpenHashMap();
        private final Set<String> pressedChars = new HashSet<String>();
        private final Set<ExtendedKeyBind> repeatableKeyBinds = new HashSet<ExtendedKeyBind>();
        private boolean triggered = false;
        private boolean preventFurther = false;
        private boolean cancelled = false;

        @Override
        @NotNull
        public IntList getSortedPressedKeys() {
            return this.sortedPressedKeys;
        }

        @Override
        @NotNull
        public IntSet getPressedKeys() {
            return this.pressedKeys;
        }

        @Override
        @NotNull
        public Int2ObjectMap<String> getCharMap() {
            return this.charMap;
        }

        @Override
        @NotNull
        public Set<String> getPressedChars() {
            return this.pressedChars;
        }

        @Override
        @NotNull
        public Set<ExtendedKeyBind> getRepeatableKeyBinds() {
            return this.repeatableKeyBinds;
        }

        @Override
        public boolean isTriggered() {
            return this.triggered;
        }

        @Override
        public void setTriggered(boolean triggered) {
            this.triggered = triggered;
        }

        @Override
        public boolean isPreventFurther() {
            return this.preventFurther;
        }

        @Override
        public void setPreventFurther(boolean matched) {
            this.preventFurther = matched;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }

    private static class ExtendedKeyBindProviderTicket
    implements Comparable<ExtendedKeyBindProviderTicket> {
        private static int ID;
        private final ExtendedKeyBindProvider provider;
        private final int tieBreaker = ID++;

        private ExtendedKeyBindProviderTicket(ExtendedKeyBindProvider provider) {
            this.provider = provider;
        }

        public ExtendedKeyBindProvider getProvider() {
            return this.provider;
        }

        public int getTieBreaker() {
            return this.tieBreaker;
        }

        @Override
        public int compareTo(@NotNull ExtendedKeyBindProviderTicket o) {
            return new CompareToBuilder().append(-this.provider.getPriority(), -o.provider.getPriority()).append(this.tieBreaker, o.tieBreaker).toComparison();
        }
    }
}

