/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProvider;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.hotkey.IConfigHotKey;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class ConfigKeyBindProvider
implements ExtendedKeyBindProvider {
    public static final ConfigKeyBindProvider INSTANCE = new ConfigKeyBindProvider();
    private final ConfigHotKeyManager manager = ConfigHotKeyManager.INSTANCE;

    @Override
    @NotNull
    public Iterable<ExtendedKeyBind> getActiveKeyBinds() {
        return new ConfigKeyBindIterable(this.manager.getHotKeys().getEntries(), false);
    }

    @Override
    @NotNull
    public Iterable<ExtendedKeyBind> getAllKeyBinds() {
        return new ConfigKeyBindIterable(this.manager.getHotKeys().getEntries(), true);
    }

    public static class ConfigKeyBindIterable
    implements Iterable<ExtendedKeyBind> {
        private final List<ConfigHotKeyManager.IConfigHotKeyGroupEntry> hotKeys;
        private final boolean iterateAll;

        public ConfigKeyBindIterable(List<ConfigHotKeyManager.IConfigHotKeyGroupEntry> hotKeys, boolean iterateAll) {
            this.hotKeys = hotKeys;
            this.iterateAll = iterateAll;
        }

        @Override
        @NotNull
        public Iterator<ExtendedKeyBind> iterator() {
            return new ConfigKeyBindIterator(this.hotKeys, this.iterateAll);
        }
    }

    public static class ConfigKeyBindIterator
    implements Iterator<ExtendedKeyBind> {
        private final List<? extends IConfigHotKey> hotKeys;
        private final boolean iterateAll;
        private ConfigHotKeyManager.ConfigHotKeyGroup group = null;
        private ConfigKeyBindIterator sub = null;
        private int index = 0;

        public ConfigKeyBindIterator(List<? extends IConfigHotKey> hotKeys, boolean iterateAll) {
            this.hotKeys = hotKeys;
            this.iterateAll = iterateAll;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.hotKeys.size() || this.sub != null && this.sub.hasNext() || this.group != null && (this.iterateAll || this.group.isEnabled()) && !this.group.getEntries().isEmpty();
        }

        @Override
        public ExtendedKeyBind next() {
            IConfigHotKey hotKey;
            if (this.group != null && (this.iterateAll || this.group.isEnabled())) {
                this.sub = new ConfigKeyBindIterator(this.group.getEntries(), this.iterateAll);
                this.group = null;
            }
            if (this.sub != null) {
                if (this.sub.hasNext()) {
                    return this.sub.next();
                }
                this.sub = null;
            }
            if (this.index >= this.hotKeys.size()) {
                throw new NoSuchElementException();
            }
            if ((hotKey = this.hotKeys.get(this.index++)) instanceof ConfigHotKeyManager.ConfigHotKeyGroup) {
                this.group = (ConfigHotKeyManager.ConfigHotKeyGroup)hotKey;
            }
            return hotKey.getKeyBind();
        }
    }
}

