/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.google.common.collect.ImmutableList;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProvider;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.WidgetUtils;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.KeyBindButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.TextFieldWidgetEx;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeView;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewCaption;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewEntry;
import endorh.simpleconfig.ui.gui.widget.treeview.DragBroadcastableControl;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindDispatcher;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.SavedHotKeyGroupPickerWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigHotKeyTreeView
extends ArrangeableTreeView<ConfigHotKeyTreeViewEntry> {
    private final Supplier<IDialogCapableScreen> dialogScreenSupplier;
    private final Supplier<IOverlayCapableContainer> containerSupplier;
    @Nullable
    private String contextModId = null;
    private final BiConsumer<String, ConfigHotKey> hotKeyEditor;
    public static final DragBroadcastableControl.DragBroadcastableAction.WidgetDragBroadcastableAction<CheckboxButton> ENABLE_ACTION = (b, s) -> b.setToggle(s.getValue());
    public final CandidateHotKeyProvider provider = new CandidateHotKeyProvider();

    public ConfigHotKeyTreeView(Supplier<IDialogCapableScreen> screenSupplier, IOverlayCapableContainer overlayContainer, ConfigHotKeyManager.ConfigHotKeyGroup group2, BiConsumer<String, ConfigHotKey> hotKeyEditor) {
        super(overlayContainer, new ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry(screenSupplier, () -> overlayContainer, group2));
        this.dialogScreenSupplier = screenSupplier;
        this.containerSupplier = () -> overlayContainer;
        this.hotKeyEditor = hotKeyEditor;
        this.setCaption(new ConfigHotKeyTreeViewCaption(screenSupplier, overlayContainer, this));
        Throwable lastError = ConfigHotKeyManager.INSTANCE.getLastLoadingError();
        this.setPlaceHolder((Component)(lastError == null ? Component.m_237115_((String)"simpleconfig.ui.no_hotkeys") : Component.m_237110_((String)"simpleconfig.ui.error_loading_hotkeys", (Object[])new Object[]{lastError.getLocalizedMessage()}).m_130940_(ChatFormatting.RED)));
        ExtendedKeyBindDispatcher.registerProvider(this.provider);
    }

    public <T extends Screen> T getDialogScreen() {
        return (T)((Screen)this.dialogScreenSupplier.get());
    }

    public IOverlayCapableContainer getOverlayContainer() {
        return this.containerSupplier.get();
    }

    @Nullable
    public String getContextModId() {
        return this.contextModId;
    }

    public void setContextModId(@Nullable String contextModId) {
        this.contextModId = contextModId;
    }

    protected BiConsumer<String, ConfigHotKey> getHotKeyEditor() {
        return this.hotKeyEditor;
    }

    public void addHotKey() {
        ConfigHotKey hotKey = new ConfigHotKey();
        this.provider.getHotKeys().add(hotKey.getKeyBind());
        this.tryAddEntry(new ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewHotKeyEntry(this::getDialogScreen, this.containerSupplier, hotKey));
    }

    public void addGroup() {
        ConfigHotKeyManager.ConfigHotKeyGroup group2 = new ConfigHotKeyManager.ConfigHotKeyGroup();
        this.provider.getHotKeys().add(group2.getKeyBind());
        this.tryAddEntry(new ConfigHotKeyTreeViewEntry.ConfigHotKeyTreeViewGroupEntry(this::getDialogScreen, this.containerSupplier, group2));
    }

    public void removeCandidates() {
        this.provider.getHotKeys().clear();
        ExtendedKeyBindDispatcher.unregisterProvider(this.provider);
        ((ConfigHotKeyTreeViewEntry)this.getRoot()).removeCandidate();
    }

    public static abstract class ConfigHotKeyTreeViewEntry
    extends ArrangeableTreeViewEntry<ConfigHotKeyTreeViewEntry> {
        public ConfigHotKeyTreeView getTree() {
            return (ConfigHotKeyTreeView)super.getTree();
        }

        @Override
        public int getOwnHeight() {
            return 22;
        }

        @Override
        public int getVerticalPadding() {
            return 1;
        }

        @Override
        public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
            if (super.handleNavigationKey(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (Screen.m_96639_()) {
                ConfigHotKeyTreeView tree = this.getTree();
                if (keyCode == 260) {
                    if (Screen.m_96638_()) {
                        tree.addGroup();
                    } else {
                        tree.addHotKey();
                    }
                    return true;
                }
                if (keyCode == 261) {
                    tree.removeSelection();
                    return true;
                }
            }
            return false;
        }

        public void removeCandidate() {
        }

        public static class ConfigHotKeyTreeViewGroupEntry
        extends ConfigHotKeyTreeViewEntry {
            private final TextFieldWidgetEx textField;
            private final KeyBindButton hotKeyButton;
            private final DragBroadcastableControl.DragBroadcastableWidget<CheckboxButton> enabledCheckbox;
            private final ExtendedKeyBindImpl keyBind;

            public ConfigHotKeyTreeViewGroupEntry(Supplier<IDialogCapableScreen> screenSupplier, Supplier<IOverlayCapableContainer> containerSupplier, ConfigHotKeyManager.ConfigHotKeyGroup group2) {
                this.subEntries = group2.getEntries().stream().map(e -> {
                    if (e instanceof ConfigHotKeyManager.ConfigHotKeyGroup) {
                        return new ConfigHotKeyTreeViewGroupEntry(screenSupplier, containerSupplier, (ConfigHotKeyManager.ConfigHotKeyGroup)e);
                    }
                    if (e instanceof ConfigHotKey) {
                        return new ConfigHotKeyTreeViewHotKeyEntry(screenSupplier, containerSupplier, (ConfigHotKey)e);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                this.textField = TextFieldWidgetEx.of(group2.getName());
                this.textField.setMaxLength(256);
                this.textField.setBordered(false);
                this.textField.setEmptyHint((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.unnamed.hint"));
                this.keyBind = group2.getKeyBind();
                this.hotKeyButton = KeyBindButton.of(screenSupplier::get, containerSupplier, this.keyBind);
                this.hotKeyButton.setTooltip(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.hotkey.group.hotkey", new Object[0]));
                this.enabledCheckbox = this.draggable(ENABLE_ACTION, CheckboxButton.of(group2.isEnabled(), (Component)Component.m_237119_()));
                Stream.of(new GuiEventListener[]{this.textField, this.hotKeyButton, this.enabledCheckbox}).forEach(x$0 -> this.listeners.add(x$0));
                this.setExpanded(true, false);
            }

            public ConfigHotKeyManager.ConfigHotKeyGroup buildGroup() {
                ConfigHotKeyManager.ConfigHotKeyGroup group2 = new ConfigHotKeyManager.ConfigHotKeyGroup();
                this.subEntries.stream().map(e -> {
                    if (e instanceof ConfigHotKeyTreeViewGroupEntry) {
                        return ((ConfigHotKeyTreeViewGroupEntry)e).buildGroup();
                    }
                    if (e instanceof ConfigHotKeyTreeViewHotKeyEntry) {
                        return ((ConfigHotKeyTreeViewHotKeyEntry)e).buildHotKey();
                    }
                    return null;
                }).filter(Objects::nonNull).forEach(group2.getEntries()::add);
                group2.setName(this.textField.getValue());
                group2.setKeyMapping(this.hotKeyButton.getMapping());
                group2.setEnabled(this.enabledCheckbox.getWidget().getValue());
                return group2;
            }

            @Override
            protected void tick() {
                this.keyBind.setCandidateName((Component)Component.m_237113_((String)this.textField.getValue()));
                this.hotKeyButton.tick();
            }

            @Override
            public void removeCandidate() {
                this.keyBind.setCandidateName(null);
                this.keyBind.setCandidateDefinition(null);
                this.subEntries.forEach(ConfigHotKeyTreeViewEntry::removeCandidate);
            }

            @Override
            public boolean canBeDroppedInto(int index, List<ConfigHotKeyTreeViewEntry> selection) {
                return true;
            }

            @Override
            public boolean canBeAddedToSelection(Set<ConfigHotKeyTreeViewEntry> selection) {
                return selection.stream().allMatch(e -> e instanceof ConfigHotKeyTreeViewGroupEntry || e instanceof ConfigHotKeyTreeViewHotKeyEntry);
            }

            @Override
            public void renderContent(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
                int hotKeyButtonWidth = Math.min(140, (int)((double)w * 0.4));
                this.textField.m_264152_(x + 4, y + 6);
                this.textField.m_93674_(w - 30 - hotKeyButtonWidth);
                this.textField.setHeight(h - 10);
                this.hotKeyButton.setPosition(x + w - 24 - hotKeyButtonWidth, y, hotKeyButtonWidth);
                this.enabledCheckbox.setPosition(x + w - 22, y + 1);
                WidgetUtils.renderAll(gg, mouseX, mouseY, delta, new Renderable[]{this.textField, this.hotKeyButton, this.enabledCheckbox});
            }

            @Override
            public boolean isForceRenderAsGroup() {
                return true;
            }
        }

        public static class ConfigHotKeyTreeViewModEntry
        extends ConfigHotKeyTreeViewEntry {
            private final ConfigHotKey hotKey;
            private final String modId;
            private final MultiFunctionImageButton editButton;

            public ConfigHotKeyTreeViewModEntry(ConfigHotKey hotKey, String modId) {
                this.hotKey = hotKey;
                this.modId = modId;
                this.editButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.GEAR, MultiFunctionImageButton.ButtonAction.of(this::editHotKey));
                this.listeners.add(this.editButton);
            }

            public void editHotKey() {
                ((ConfigHotKeyTreeView)this.getTree()).getHotKeyEditor().accept(this.modId, this.hotKey);
            }

            public String getModId() {
                return this.modId;
            }

            @Override
            public boolean isSelectable() {
                return false;
            }

            @Override
            public boolean canBeDroppedInto(int index, List<ConfigHotKeyTreeViewEntry> selection) {
                return false;
            }

            @Override
            public void renderContent(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
                this.editButton.m_264152_(x + 2, y + 1);
                this.editButton.m_93674_(18);
                this.editButton.setHeight(18);
                this.editButton.m_88315_(gg, mouseX, mouseY, delta);
                int count = this.getCount();
                Font font = Minecraft.m_91087_().f_91062_;
                int textX = x + 24;
                int n = y + h / 2;
                Objects.requireNonNull(font);
                int textY = n - 9 / 2;
                gg.m_280430_(font, (Component)this.getDisplayText(), textX, textY, count == 0 ? -526344032 : -522133280);
                ArrangeableTreeView tree = this.getTree();
                if (textX <= mouseX && mouseX < tree.getArea().getMaxX() && textY <= mouseY) {
                    List<Component> tooltip;
                    Objects.requireNonNull(font);
                    if (mouseY < textY + 9 && !(tooltip = this.getResumeTooltip()).isEmpty()) {
                        ((IMultiTooltipScreen)((ConfigHotKeyTreeView)tree).getDialogScreen()).addTooltip(Tooltip.of(Point.of(mouseX, mouseY), tooltip));
                    }
                }
            }

            protected MutableComponent getDisplayText() {
                int count = this.getCount();
                ChatFormatting style = count > 0 ? ChatFormatting.WHITE : ChatFormatting.GRAY;
                ChatFormatting dim = count > 0 ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY;
                MutableComponent name = ModList.get().getMods().stream().filter(m -> this.modId.equals(m.getModId())).findFirst().map(m -> Component.m_237113_((String)m.getDisplayName()).m_130940_(style).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)("(" + this.modId + ")")).m_130940_(dim))).orElse(Component.m_237113_((String)this.modId).m_130940_(style));
                if (count > 0) {
                    name.m_7220_((Component)Component.m_237113_((String)" [").m_7220_((Component)Component.m_237113_((String)String.valueOf(count)).m_130940_(ChatFormatting.AQUA)).m_130946_("]").m_130940_(ChatFormatting.DARK_AQUA));
                }
                return name;
            }

            protected List<Component> getResumeTooltip() {
                Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions = this.hotKey.getActions();
                ArrayList<Component> tt = new ArrayList<Component>();
                for (SimpleConfig.EditType type : SimpleConfig.EditType.values()) {
                    Map<String, HotKeyAction<?>> a;
                    SimpleConfigImpl config = SimpleConfigImpl.getConfigOrNull(this.modId, type.getType());
                    if (config == null || (a = actions.get(Pair.of((Object)this.modId, (Object)((Object)type)))) == null || a.isEmpty()) continue;
                    tt.add((Component)Component.m_237115_((String)("simpleconfig.config.category." + type.getAlias())).m_130940_(ChatFormatting.BOLD));
                    a.forEach((k, v) -> tt.add((Component)this.formatAction((String)k, (HotKeyAction)v)));
                }
                return tt;
            }

            protected <T> MutableComponent formatAction(String key, HotKeyAction<T> action) {
                return Component.m_237113_((String)("[" + key + "]: ")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)this.formatAction(action.getType(), action).m_6881_().m_130940_(ChatFormatting.GRAY));
            }

            private <V, A extends HotKeyAction<V>, T extends HotKeyActionType<V, A>> Component formatAction(T type, HotKeyAction<?> action) {
                return type.formatAction(action);
            }

            protected int getCount() {
                int size = 0;
                Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions = this.hotKey.getActions();
                for (SimpleConfig.EditType type : SimpleConfig.EditType.values()) {
                    Map<String, HotKeyAction<?>> a;
                    SimpleConfigImpl config = SimpleConfigImpl.getConfigOrNull(this.modId, type.getType());
                    if (config == null || (a = actions.get(Pair.of((Object)this.modId, (Object)((Object)type)))) == null) continue;
                    size += a.size();
                }
                return size;
            }
        }

        public static class ConfigHotKeyTreeViewHotKeyEntry
        extends ConfigHotKeyTreeViewEntry {
            private final ConfigHotKey hotKey;
            private final TextFieldWidgetEx textField;
            private final KeyBindButton hotKeyButton;
            private final DragBroadcastableControl.DragBroadcastableWidget<CheckboxButton> enabledCheckbox;
            private final Map<String, ConfigHotKeyTreeViewModEntry> entries = new HashMap<String, ConfigHotKeyTreeViewModEntry>();
            private final ExtendedKeyBindImpl keyBind;
            private final Comparator<String> modOrder = (l, r) -> {
                ArrangeableTreeView tree = this.getTree();
                String contextModId = ((ConfigHotKeyTreeView)tree).getContextModId();
                return new CompareToBuilder().append(!l.equals(contextModId), !r.equals(contextModId)).append(this.entries.get(l).getCount(), this.entries.get(r).getCount()).append(l, r).build();
            };

            public ConfigHotKeyTreeViewHotKeyEntry(Supplier<IDialogCapableScreen> screenSupplier, Supplier<IOverlayCapableContainer> containerSupplier, ConfigHotKey hotKey) {
                this.keyBind = hotKey.getKeyBind();
                this.hotKey = hotKey = hotKey.copy();
                this.textField = TextFieldWidgetEx.of(hotKey.getName());
                this.textField.setMaxLength(256);
                this.textField.setBordered(false);
                this.textField.setEmptyHint((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.unnamed.hint"));
                this.hotKeyButton = KeyBindButton.of(screenSupplier::get, containerSupplier, this.keyBind);
                this.enabledCheckbox = this.draggable(ENABLE_ACTION, CheckboxButton.of(hotKey.isEnabled(), (Component)Component.m_237119_()));
                Stream.of(new GuiEventListener[]{this.hotKeyButton, this.textField, this.enabledCheckbox}).forEach(x$0 -> this.listeners.add(x$0));
                for (String id : SimpleConfigImpl.getConfigModIds()) {
                    this.entries.put(id, new ConfigHotKeyTreeViewModEntry(hotKey, id));
                }
            }

            public ConfigHotKey buildHotKey() {
                this.hotKey.setKeyMapping(this.hotKeyButton.getMapping());
                this.hotKey.setName(this.textField.getValue());
                this.hotKey.setEnabled(this.enabledCheckbox.getWidget().getValue());
                return this.hotKey;
            }

            @Override
            public void removeCandidate() {
                this.keyBind.setCandidateName(null);
                this.keyBind.setCandidateDefinition(null);
            }

            @Override
            public boolean canBeDroppedInto(int index, List<ConfigHotKeyTreeViewEntry> selection) {
                return false;
            }

            @Override
            public boolean canBeAddedToSelection(Set<ConfigHotKeyTreeViewEntry> selection) {
                return selection.stream().allMatch(e -> e instanceof ConfigHotKeyTreeViewGroupEntry || e instanceof ConfigHotKeyTreeViewHotKeyEntry);
            }

            @Override
            @Nullable
            public ComponentPath m_264064_(@NotNull FocusNavigationEvent e) {
                return super.m_264064_(e);
            }

            @Override
            protected void tick() {
                List subEntries = this.getSubEntries();
                subEntries.clear();
                this.entries.keySet().stream().sorted(this.modOrder).map(this.entries::get).forEach(subEntries::add);
                this.keyBind.setCandidateName((Component)Component.m_237113_((String)this.textField.getValue()));
                this.hotKeyButton.tick();
            }

            @Override
            public void render(GuiGraphics gg, int x, int y, int width, int mouseX, int mouseY, float delta) {
                if (((ConfigHotKeyTreeViewEntry)this.getParent()).getFocusedSubEntry() != this) {
                    this.setExpanded(false);
                }
                super.render(gg, x, y, width, mouseX, mouseY, delta);
            }

            @Override
            public void renderContent(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
                int hotKeyButtonWidth = Math.min(150, (w - 46) / 2);
                this.hotKeyButton.setPosition(x, y, hotKeyButtonWidth);
                this.textField.m_264152_(x + hotKeyButtonWidth + 4, y + 6);
                this.textField.m_93674_(w - 48 - hotKeyButtonWidth);
                this.textField.setHeight(h - 10);
                this.enabledCheckbox.setPosition(x + w - 22, y + 1);
                WidgetUtils.renderAll(gg, mouseX, mouseY, delta, new Renderable[]{this.hotKeyButton, this.textField, this.enabledCheckbox});
            }
        }
    }

    private static class CandidateHotKeyProvider
    implements ExtendedKeyBindProvider {
        private final Set<ExtendedKeyBind> hotKeys = new HashSet<ExtendedKeyBind>();

        private CandidateHotKeyProvider() {
        }

        @Override
        @NotNull
        public Iterable<ExtendedKeyBind> getActiveKeyBinds() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<ExtendedKeyBind> getAllKeyBinds() {
            return this.hotKeys;
        }

        @Override
        public int getPriority() {
            return -999;
        }

        public Set<ExtendedKeyBind> getHotKeys() {
            return this.hotKeys;
        }
    }

    public static class ConfigHotKeyTreeViewCaption
    extends ArrangeableTreeViewCaption<ConfigHotKeyTreeViewEntry> {
        private final SavedHotKeyGroupPickerWidget savedHotKeyGroupPickerWidget;
        private final Supplier<IDialogCapableScreen> screen;

        protected ConfigHotKeyTreeViewCaption(Supplier<IDialogCapableScreen> screen, IOverlayCapableContainer overlayContainer, ConfigHotKeyTreeView tree) {
            super(tree);
            this.screen = screen;
            this.addControl((AbstractWidget)MultiFunctionIconButton.of(SimpleConfigIcons.Widgets.TREE_ADD, 20, 20, MultiFunctionImageButton.ButtonAction.of(tree::addHotKey).tooltip((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.add.hotkey"), (Object)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.add.hotkey:key"))).tint(1686175616)));
            this.addControl((AbstractWidget)MultiFunctionIconButton.of(SimpleConfigIcons.Widgets.TREE_ADD_GROUP, 20, 20, MultiFunctionImageButton.ButtonAction.of(tree::addGroup).tooltip((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.add.group"), (Object)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.add.group:key"))).tint(1686175616)));
            this.addControl((AbstractWidget)MultiFunctionIconButton.of(SimpleConfigIcons.Widgets.TREE_REMOVE, 20, 20, MultiFunctionImageButton.ButtonAction.of(tree::removeSelection).tooltip((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.remove"), (Object)Component.m_237115_((String)"simpleconfig.ui.hotkey.dialog.remove:key"))).tint(1694466176).active(() -> !tree.getSelection().isEmpty())));
            this.savedHotKeyGroupPickerWidget = new SavedHotKeyGroupPickerWidget(screen, overlayContainer, tree);
            this.addRightControl(this.savedHotKeyGroupPickerWidget);
        }

        public IDialogCapableScreen getScreen() {
            IDialogCapableScreen screen = this.screen.get();
            if (screen == null) {
                throw new IllegalStateException("Cannot get screen so early.");
            }
            return screen;
        }

        @Override
        protected int getHeight() {
            return 20;
        }

        @Override
        public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
            int width = this.getTree().getWidth();
            this.savedHotKeyGroupPickerWidget.setWidth(Mth.m_14045_((int)((int)((double)width * 0.45)), (int)90, (int)300));
            super.render(gg, mouseX, mouseY, delta);
        }
    }
}

