/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.mojang.blaze3d.platform.Window;
import endorh.simpleconfig.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig")
public class ConfigHotKeyOverlay {
    private static final List<QueuedHotKeyMessage> messages = new ArrayList<QueuedHotKeyMessage>();
    private static final int FADE_OUT = 500;
    private static Component toastMessage;
    private static long toastTimestamp;

    public static void addToastMessage(String message) {
        ConfigHotKeyOverlay.addToastMessage((Component)Component.m_237113_((String)message));
    }

    public static void addToastMessage(Component message) {
        toastMessage = message;
        toastTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessage(Component title, List<Component> message) {
        QueuedHotKeyMessage m = new QueuedHotKeyMessage(title, message, System.currentTimeMillis());
        List<QueuedHotKeyMessage> list = messages;
        synchronized (list) {
            messages.add(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            GuiGraphics gg = event.getGuiGraphics();
            long time = System.currentTimeMillis();
            Component msg = toastMessage;
            if (msg != null) {
                if (time - toastTimestamp > (long)ClientConfig.hotkey_log.toast.display_time_ms) {
                    toastMessage = null;
                }
                ConfigHotKeyOverlay.renderToastMessage(gg, msg);
            }
            Window window = event.getWindow();
            int w = window.m_85445_();
            int h = window.m_85446_();
            int b = (int)((double)h * 0.9);
            int minY = (int)((double)h * 0.5);
            int maxWidth = (int)((double)w * 0.35);
            int duration = ClientConfig.hotkey_log.overlay.display_time_ms;
            List<QueuedHotKeyMessage> list = messages;
            synchronized (list) {
                if (messages.isEmpty()) {
                    return;
                }
                ListIterator<QueuedHotKeyMessage> iter = messages.listIterator(messages.size());
                while (iter.hasPrevious()) {
                    QueuedHotKeyMessage message = iter.previous();
                    if (b <= minY) {
                        message.evict();
                    }
                    b -= message.getHeight();
                    if (time - message.getTimestamp() > (long)duration) {
                        iter.remove();
                        continue;
                    }
                    message.render(gg, w, b, maxWidth);
                }
            }
        }
    }

    private static void renderToastMessage(GuiGraphics gg, Component message) {
        float alpha;
        int duration = Math.max(0, ClientConfig.hotkey_log.toast.display_time_ms - 500);
        long time = System.currentTimeMillis() - toastTimestamp;
        if (time >= (long)(duration + 500)) {
            return;
        }
        float f = alpha = time > (long)duration ? 1.0f - (float)(time - (long)duration) / 500.0f : 1.0f;
        if (alpha < 0.05f) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92852_((FormattedText)message);
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85445_();
        int screenHeight = window.m_85446_();
        int textX = screenWidth / 2 - width / 2;
        Objects.requireNonNull(font);
        int textY = (int)((float)(screenHeight - 9 - 2) * (1.0f - ClientConfig.hotkey_log.toast.relative_height));
        int opacity = (int)(255.0f * (ClientConfig.hotkey_log.toast.background_opacity * 0.9f + 0.1f));
        int backgroundColor = ConfigHotKeyOverlay.alpha(opacity << 24, alpha);
        int textColor = ConfigHotKeyOverlay.alpha(-522133280, alpha);
        Objects.requireNonNull(font);
        gg.m_280509_(textX - 2, textY - 1, textX + width + 4, textY + 9 + 2, backgroundColor);
        gg.m_280430_(font, message, textX, textY, textColor);
    }

    private static int alpha(int color, float alpha) {
        return 0xFFFFFF & color | (int)((float)(color >> 24 & 0xFF) * alpha) << 24;
    }

    public static class QueuedHotKeyMessage {
        private final Component title;
        private final List<Component> message;
        private long timestamp;

        public QueuedHotKeyMessage(Component title, List<Component> message, long timestamp) {
            this.title = title;
            this.message = message;
            this.timestamp = timestamp;
        }

        public Component getTitle() {
            return this.title;
        }

        public List<Component> getMessage() {
            return this.message;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void evict() {
            int duration = Math.max(0, ClientConfig.hotkey_log.overlay.display_time_ms - 500);
            long time = System.currentTimeMillis();
            if (time - this.timestamp < (long)duration) {
                this.timestamp = time - (long)duration;
            }
        }

        public void render(GuiGraphics gg, int r, int y, int maxWidth) {
            float alpha;
            int duration = Math.max(0, ClientConfig.hotkey_log.overlay.display_time_ms - 500);
            long time = System.currentTimeMillis() - this.getTimestamp();
            if (time >= (long)(duration + 500)) {
                return;
            }
            float f = alpha = time > (long)duration ? 1.0f - (float)(time - (long)duration) / 500.0f : 1.0f;
            if (alpha < 0.05f) {
                return;
            }
            Font font = Minecraft.m_91087_().f_91062_;
            List<Component> messages = this.getMessage();
            Component title = this.getTitle();
            int width = messages.stream().mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0) + 14;
            width = Math.max(width, font.m_92852_((FormattedText)title) + 2);
            width = Math.min(width, maxWidth);
            Objects.requireNonNull(font);
            int lH = 9 + 2;
            int h = lH * (messages.size() + 1);
            int x = r - width - 2;
            int opacity = (int)(255.0f * (ClientConfig.hotkey_log.overlay.background_opacity * 0.9f + 0.1f));
            int backgroundColor = ConfigHotKeyOverlay.alpha(opacity << 24, alpha);
            int textColor = ConfigHotKeyOverlay.alpha(-522133280, alpha);
            gg.m_280509_(x, y, r, y + h, backgroundColor);
            this.drawStringTrimmed(gg, title, width - 2, x + 1, y + 1, textColor);
            y += lH;
            x += 12;
            width -= 12;
            for (Component m : messages) {
                this.drawStringTrimmed(gg, m, width - 2, x + 1, y + 1, textColor);
                y += lH;
            }
        }

        private void drawStringTrimmed(GuiGraphics gg, Component text, int width, float x, float y, int color) {
            Font font = Minecraft.m_91087_().f_91062_;
            FormattedCharSequence line = (FormattedCharSequence)font.m_92923_((FormattedText)text, width).get(0);
            gg.m_280648_(font, line, (int)x, (int)y, color);
        }

        private int getHeight() {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int lineHeight = 9 + 2;
            return lineHeight * (this.getMessage().size() + 1);
        }
    }
}

