/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.electronwill.nightconfig.core.file.FileWatcher;
import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.core.PairList;
import endorh.simpleconfig.core.SimpleConfigPaths;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyLogger;
import endorh.simpleconfig.ui.hotkey.ConfigKeyBindProvider;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindDispatcher;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import endorh.simpleconfig.ui.hotkey.IConfigHotKey;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHotKeyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConfigHotKeyManager INSTANCE = new ConfigHotKeyManager();
    private static final int MAX_BACKUPS = 5;
    private static final String FORMAT_VERSION = "1";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("(yyyy-MM-dd HH:mm)");
    private final File configHotKeysFile = SimpleConfigPaths.CONFIG_HOTKEYS_FILE.toFile();
    private List<IConfigHotKey> hotKeys = Lists.newArrayList();
    private ConfigHotKeyGroup group = new ConfigHotKeyGroup();
    private List<ConfigHotKeyGroup> defaultGroupQueue = new ArrayList<ConfigHotKeyGroup>();
    private final Set<String> addedDefaultGroups = new HashSet<String>();
    @Nullable
    private Throwable lastLoadingError = null;

    private ConfigHotKeyManager() {
    }

    @ApiStatus.Internal
    public static void initHotKeyManager() {
        File file = ConfigHotKeyManager.INSTANCE.configHotKeysFile;
        try {
            if (!file.isFile()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileWatcher.defaultInstance().addWatch(file, () -> {
                LOGGER.info("SimpleConfigHotKeyManager: Config hotkeys file changed, reloading.");
                INSTANCE.loadHotkeys();
            });
        }
        catch (IOException e) {
            LOGGER.error("I/O Error accessing config hotkeys file \"" + file + "\"", (Throwable)e);
        }
        INSTANCE.loadHotkeys();
        List<ConfigHotKeyGroup> queue = ConfigHotKeyManager.INSTANCE.defaultGroupQueue;
        if (queue != null) {
            ConfigHotKeyManager.INSTANCE.defaultGroupQueue = null;
            queue.forEach(INSTANCE::addDefaultGroup);
        }
        ExtendedKeyBindDispatcher.registerProvider(ConfigKeyBindProvider.INSTANCE);
    }

    public void addDefaultGroup(ConfigHotKeyGroup group2) {
        if (this.defaultGroupQueue != null) {
            this.defaultGroupQueue.add(group2);
        } else {
            if (!this.addedDefaultGroups.contains(group2.getName())) {
                this.group.addEntry(group2);
                this.addedDefaultGroups.add(group2.getName());
            }
            this.saveHotkeys();
        }
    }

    public void saveHotkeys() {
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        File file = this.configHotKeysFile;
        file.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(file);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
            LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
            serialized.put("version", FORMAT_VERSION);
            serialized.put("entries", this.group.serialize().get("entries"));
            serialized.put("added_default_groups", this.addedDefaultGroups);
            writer.append("## Simple Config Hotkeys ").append(DATE_FORMAT.format(new Date())).append("\n");
            writer.append("##   It's not recommended to edit this file manually\n");
            yaml.dump(serialized, writer);
        }
        catch (IOException e) {
            LOGGER.error("I/O Error saving hotkeys to file \"" + file.getName() + "\"", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected error saving hotkeys to file \"" + file.getName() + "\"\nYou may report this bug to the Simple Config mod issue tracker", (Throwable)e);
        }
    }

    public void loadHotkeys() {
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        File file = this.configHotKeysFile;
        try (FileInputStream is = new FileInputStream(file);){
            InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
            Map map = (Map)yaml.load(reader);
            if (map == null) {
                this.updateHotKeys(new ConfigHotKeyGroup(), false);
                return;
            }
            PairList entries2 = (PairList)((Object)map.get("entries"));
            this.updateHotKeys(ConfigHotKeyGroup.deserialize("", Collections.singletonMap("entries", entries2)), false);
            Object o = map.get("added_default_groups");
            if (o instanceof Collection) {
                this.addedDefaultGroups.clear();
                ((Collection)o).stream().filter(e -> e instanceof String).forEach(e -> this.addedDefaultGroups.add((String)e));
            }
        }
        catch (IOException e2) {
            LOGGER.error("I/O Error loading hotkeys from file \"" + file.getName() + "\"", (Throwable)e2);
            this.lastLoadingError = e2;
            this.backUpHotkeys();
        }
        catch (RuntimeException e3) {
            LOGGER.error("Unexpected error loading hotkeys from file \"" + file.getName() + "\"\nEnsure the file contains valid YAML.\nOtherwise, you may report this to the Simple Config mod issue tracker", (Throwable)e3);
            this.lastLoadingError = e3;
            this.backUpHotkeys();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] dump(ConfigHotKeyGroup group2) {
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] byArray;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
                LinkedHashMap<String, String> serialized = new LinkedHashMap<String, String>();
                Object sg = group2.serialize();
                serialized.put("version", FORMAT_VERSION);
                serialized.putAll((Map<String, String>)sg);
                writer.append("## Simple Config Hotkey Group: \"").append(group2.getName()).append("\" ").append(DATE_FORMAT.format(new Date())).append("\n");
                writer.append("##   It's not recommended to edit this file manually\n");
                yaml.dump(serialized, writer);
                byArray = os.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error("I/O Error saving hotkeys to memory", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected error saving hotkeys to memory\nYou may report this bug to the Simple Config mod issue tracker", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ConfigHotKeyGroup load(String name, byte[] data) {
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            ConfigHotKeyGroup configHotKeyGroup;
            try (InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
                Map map = (Map)yaml.load(reader);
                configHotKeyGroup = ConfigHotKeyGroup.deserialize(name, map);
            }
            return configHotKeyGroup;
        }
        catch (IOException e) {
            LOGGER.error("I/O Error loading hotkeys from memory", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected error loading hotkeys from memory\nEnsure the source file contains valid YAML.\nOtherwise, you may report this to the Simple Config mod issue tracker", (Throwable)e);
            throw e;
        }
    }

    protected void backUpHotkeys() {
        String originalName = this.configHotKeysFile.getName();
        String name = FilenameUtils.removeExtension((String)originalName);
        String ext = FilenameUtils.getExtension((String)originalName) + ".bak";
        Path dir = this.configHotKeysFile.toPath().getParent();
        Path bakFile = dir.resolve(name + "-1." + ext);
        try {
            for (int i = 5; i > 0; --i) {
                Path oldBak = dir.resolve(name + "-" + i + "." + ext);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= 5) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, dir.resolve(name + "-" + (i + 1) + "." + ext), new CopyOption[0]);
            }
            Files.copy(this.configHotKeysFile.toPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to back up Hotkeys: " + this.configHotKeysFile.toPath(), (Throwable)e);
        }
    }

    public List<IConfigHotKey> getSortedHotKeys() {
        return this.hotKeys;
    }

    public ConfigHotKeyGroup getHotKeys() {
        return this.group;
    }

    @Nullable
    public Throwable getLastLoadingError() {
        return this.lastLoadingError;
    }

    public void updateHotKeys(ConfigHotKeyGroup hotKeys) {
        this.updateHotKeys(hotKeys, true);
    }

    protected void updateHotKeys(ConfigHotKeyGroup hotKeys, boolean save) {
        if (hotKeys == null) {
            hotKeys = new ConfigHotKeyGroup();
        }
        this.group = hotKeys;
        ArrayList<IConfigHotKey> keys = new ArrayList<IConfigHotKey>();
        this.updateHotKeys(keys, this.group);
        this.hotKeys = keys;
        if (save) {
            this.saveHotkeys();
        }
    }

    private void updateHotKeys(List<IConfigHotKey> keys, ConfigHotKeyGroup group2) {
        if (!group2.getKeyMapping().isUnset()) {
            keys.add(group2);
        }
        if (group2.isEnabled()) {
            for (IConfigHotKeyGroupEntry entry : group2.getEntries()) {
                ConfigHotKey hotkey;
                if (entry instanceof ConfigHotKeyGroup) {
                    this.updateHotKeys(keys, (ConfigHotKeyGroup)entry);
                    continue;
                }
                if (!(entry instanceof ConfigHotKey) || !(hotkey = (ConfigHotKey)entry).isEnabled() || hotkey.getKeyMapping().isUnset()) continue;
                keys.add(hotkey);
            }
        }
    }

    public static class ConfigHotKeyGroup
    implements IConfigHotKeyGroupEntry {
        private final ExtendedKeyBindImpl keyBind;
        private String name = "";
        private KeyBindMapping keyMapping = KeyBindMapping.unset();
        private boolean enabled = true;
        private final List<IConfigHotKeyGroupEntry> entries = new ArrayList<IConfigHotKeyGroupEntry>();

        public ConfigHotKeyGroup() {
            this.keyBind = new ExtendedKeyBindImpl((Component)Component.m_237113_((String)this.getName()), this.keyMapping, this::applyHotkey);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.keyBind.setTitle((Component)Component.m_237113_((String)name));
        }

        @Override
        public ExtendedKeyBindImpl getKeyBind() {
            return this.keyBind;
        }

        @Override
        public KeyBindMapping getKeyMapping() {
            return this.keyMapping;
        }

        public void setKeyMapping(KeyBindMapping keyMapping) {
            this.keyMapping = keyMapping;
            this.keyBind.setDefinition(keyMapping);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public List<IConfigHotKeyGroupEntry> getEntries() {
            return this.entries;
        }

        public void addEntry(IConfigHotKeyGroupEntry entry) {
            this.entries.add(entry);
        }

        @Override
        public Object getSerializationKey() {
            return "(" + this.getName() + ")";
        }

        @Override
        public void applyHotkey() {
            this.enabled = !this.enabled;
            ConfigHotKeyManager manager = INSTANCE;
            manager.updateHotKeys(manager.getHotKeys());
            ConfigHotKeyLogger.logHotKey(this.getHotkeyReport(this.enabled), Collections.emptyList());
        }

        public Component getHotkeyReport(boolean enable) {
            return Component.m_237110_((String)("simpleconfig.hotkey.group." + (enable ? "enable" : "disable")), (Object[])new Object[]{Component.m_237113_((String)this.getName()).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY);
        }

        @Override
        public Map<String, Object> serialize() {
            return (Map)Util.m_137469_(new LinkedHashMap(2), m -> {
                m.put("enabled", this.enabled);
                if (!this.keyMapping.isUnset()) {
                    m.put("key", this.keyMapping.serialize());
                }
                m.put("entries", new PairList(this.entries.stream().map(e -> Pair.of((Object)e.getSerializationKey(), (Object)e.serialize())).collect(Collectors.toList())));
            });
        }

        public static ConfigHotKeyGroup deserialize(String name, Map<?, ?> value) {
            ConfigHotKeyGroup group2 = new ConfigHotKeyGroup();
            group2.setName(name);
            if (value != null) {
                Object enabled = value.get("enabled");
                group2.setEnabled(enabled instanceof Boolean ? (Boolean)enabled : true);
                Object groupKey = value.get("key");
                group2.setKeyMapping(groupKey instanceof String ? KeyBindMapping.parse((String)groupKey) : KeyBindMapping.unset());
                Object entries2 = value.get("entries");
                if (entries2 instanceof PairList) {
                    ((PairList)((Object)entries2)).forEach((k, v) -> {
                        if (k instanceof String) {
                            String key = (String)k;
                            if (key.startsWith("(") && key.endsWith(")") && v instanceof Map) {
                                String nm = key.substring(1, key.length() - 1);
                                ConfigHotKeyGroup sub = ConfigHotKeyGroup.deserialize(nm, (Map)v);
                                group2.addEntry(sub);
                            } else {
                                KeyBindMapping keyCode = KeyBindMapping.parse(key);
                                if (v instanceof Map) {
                                    group2.addEntry(ConfigHotKey.deserialize(keyCode, (Map)v));
                                }
                            }
                        }
                    });
                }
            }
            return group2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigHotKeyGroup that = (ConfigHotKeyGroup)o;
            return this.enabled == that.enabled && this.name.equals(that.name) && this.keyMapping.equals(that.keyMapping) && this.entries.equals(that.entries);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.keyMapping, this.enabled, this.entries);
        }
    }

    public static interface IConfigHotKeyGroupEntry
    extends IConfigHotKey {
        public Object getSerializationKey();

        public Object serialize();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig")
    public static class ServerConfigHotkeyReloader {
        @SubscribeEvent
        public static void onConnectToServer(ClientPlayerNetworkEvent.LoggingIn event) {
            INSTANCE.loadHotkeys();
        }
    }
}

