/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.hotkey;

import com.electronwill.nightconfig.core.CommentedConfig;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyLogger;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConfigHotKey
implements ConfigHotKeyManager.IConfigHotKeyGroupEntry {
    private final ExtendedKeyBindImpl keyBind;
    private KeyBindMapping keyMapping;
    private String name = "";
    private boolean enabled = true;
    private Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions;
    private Map<String, Map<String, Map<String, Object>>> unknown;

    public ConfigHotKey() {
        this(KeyBindMapping.unset(), new LinkedHashMap(), new LinkedHashMap<String, Map<String, Map<String, Object>>>());
    }

    public ConfigHotKey(KeyBindMapping keyMapping, Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions, Map<String, Map<String, Map<String, Object>>> unknown) {
        this.keyMapping = keyMapping;
        this.actions = actions;
        this.unknown = unknown;
        this.keyBind = new ExtendedKeyBindImpl((Component)this.getTitle(), keyMapping, this::applyHotkey);
    }

    @Override
    public void applyHotkey() {
        Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions = this.getActions();
        HashMap<Pair, HotKeyExecutionContext> contexts = new HashMap<Pair, HotKeyExecutionContext>();
        actions.forEach((pair, configActions) -> {
            SimpleConfigImpl config = ConfigHotKey.getConfig((Pair<String, SimpleConfig.EditType>)pair);
            if (config != null) {
                HotKeyExecutionContext context = contexts.computeIfAbsent((Pair)pair, k -> new HotKeyExecutionContext(config));
                configActions.forEach((path, action) -> {
                    Component r = action.apply(config, (String)path, context.result);
                    if (r != null) {
                        context.report.add(r);
                    }
                });
            }
        });
        ArrayList<Component> messages = new ArrayList<Component>();
        contexts.forEach((pair, context) -> {
            if (((SimpleConfig.EditType)((Object)((Object)pair.getRight()))).isRemote()) {
                if (SimpleConfigNetworkHandler.applyRemoteSnapshot(context.config, context.result, context.report)) {
                    messages.addAll(context.report);
                } else {
                    messages.add((Component)Component.m_237110_((String)"simpleconfig.hotkey.no_permission", (Object[])new Object[]{Component.m_237113_((String)context.config.getModName()).m_130940_(ChatFormatting.GRAY)}));
                }
            } else {
                context.config.loadSnapshot(context.result, false, false);
                context.config.save();
                messages.addAll(context.report);
            }
        });
        ConfigHotKeyLogger.logHotKey(this.getCaption(), messages);
    }

    public MutableComponent getTitle() {
        return Component.m_237113_((String)(this.name != null ? this.name : "")).m_130940_(ChatFormatting.WHITE);
    }

    public Component getCaption() {
        return this.getTitle().m_130946_(" ").m_7220_(this.getKeyMapping().getDisplayName(ChatFormatting.GRAY));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.keyBind.setTitle((Component)this.getTitle());
    }

    @Override
    public ExtendedKeyBindImpl getKeyBind() {
        return this.keyBind;
    }

    @Override
    public KeyBindMapping getKeyMapping() {
        return this.keyMapping;
    }

    public void setKeyMapping(KeyBindMapping keyMapping) {
        this.keyMapping = keyMapping;
        this.keyBind.setDefinition(keyMapping);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> getActions() {
        return this.actions;
    }

    public void setActions(Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions) {
        this.actions = actions;
    }

    public Map<String, Map<String, Map<String, Object>>> getUnknown() {
        return this.unknown;
    }

    public void setUnknown(Map<String, Map<String, Map<String, Object>>> unknown) {
        this.unknown = unknown;
    }

    @Override
    public Object getSerializationKey() {
        return this.getKeyMapping().serialize();
    }

    @Override
    public Object serialize() {
        return Util.m_137469_(new LinkedHashMap(), m -> {
            m.put("name", this.getName());
            m.put("enabled", this.isEnabled());
            m.put("actions", this.serializeActions());
        });
    }

    private static SimpleConfigImpl getConfig(Pair<String, SimpleConfig.EditType> pair) {
        if (((SimpleConfig.EditType)((Object)pair.getRight())).isRemote() && !((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((String)pair.getLeft()).getLeft())).canEdit()) {
            return null;
        }
        return SimpleConfigImpl.getConfigOrNull((String)pair.getLeft(), ((SimpleConfig.EditType)((Object)pair.getRight())).getType());
    }

    protected Map<String, Map<String, Map<String, Object>>> serializeActions() {
        return (Map)Util.m_137469_(new LinkedHashMap(), m -> {
            this.getActions().forEach((pair, actions) -> {
                Map mm = m.computeIfAbsent((String)pair.getLeft(), k -> new LinkedHashMap()).computeIfAbsent(((SimpleConfig.EditType)((Object)((Object)((Object)pair.getRight())))).getAlias(), t -> new LinkedHashMap());
                SimpleConfigImpl config = ConfigHotKey.getConfig((Pair<String, SimpleConfig.EditType>)pair);
                if (config != null) {
                    actions.forEach((path, action) -> {
                        if (config.hasEntry((String)path)) {
                            try {
                                HotKeyActionWrapper wrapper = this.serialize(action, config.getEntry((String)path));
                                mm.put(path, wrapper);
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.getUnknown().forEach((modId, mm) -> m.computeIfAbsent(modId, k -> new LinkedHashMap()).putAll(mm));
        });
    }

    protected <V, A extends HotKeyAction<V>, E extends AbstractConfigEntry<Object, Object, V>> HotKeyActionWrapper<V, A> serialize(A action, E entry) {
        HotKeyActionType<V, ?> type = action.getType();
        Object value = type.serialize(entry, action);
        return new HotKeyActionWrapper(type, value);
    }

    public static ConfigHotKey deserialize(KeyBindMapping keyCode, Map<Object, Object> packed) {
        boolean enabled = ConfigHotKey.getAsOrElse(packed, "enabled", Boolean.class, true);
        String name = ConfigHotKey.getAsOrElse(packed, "name", String.class, "");
        Map a = ConfigHotKey.getAsOrElse(packed, "actions", Map.class, null);
        LinkedHashMap actions = new LinkedHashMap();
        LinkedHashMap<String, Map<String, Map<String, Object>>> unknown = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        a.forEach((id, s) -> {
            if (id instanceof String) {
                String modId = (String)id;
                if (s instanceof Map) {
                    ((Map)s).forEach((t, ss) -> {
                        if (t instanceof String && ss instanceof Map) {
                            SimpleConfig.EditType type = SimpleConfig.EditType.fromAlias((String)t);
                            if (type != null && SimpleConfigImpl.hasConfig(modId, type.getType())) {
                                SimpleConfigImpl config = SimpleConfigImpl.getConfig(modId, type.getType());
                                Pair pair = Pair.of((Object)modId, (Object)((Object)type));
                                Map aa = actions.computeIfAbsent(pair, cc -> new LinkedHashMap());
                                ((Map)ss).forEach((p, v) -> {
                                    if (p instanceof String) {
                                        String path = (String)p;
                                        if (v instanceof HotKeyActionWrapper) {
                                            HotKeyActionWrapper w = (HotKeyActionWrapper)v;
                                            if (config.hasEntry(path)) {
                                                try {
                                                    Object action = ConfigHotKey.deserialize(w, config.getEntry(path), w.value());
                                                    if (action != null) {
                                                        aa.put(path, action);
                                                    }
                                                }
                                                catch (ClassCastException classCastException) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                    }
                                });
                            } else {
                                Map mm = unknown.computeIfAbsent(modId, k -> new LinkedHashMap()).computeIfAbsent((String)t, k -> new LinkedHashMap());
                                ((Map)ss).forEach((p, v) -> {
                                    if (p instanceof String) {
                                        mm.put((String)p, v);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        ConfigHotKey hotKey = new ConfigHotKey(keyCode, actions, unknown);
        hotKey.setName(name);
        hotKey.setEnabled(enabled);
        return hotKey;
    }

    protected static <V, A extends HotKeyAction<V>, E extends AbstractConfigEntry<Object, Object, V>> A deserialize(HotKeyActionWrapper<V, A> wrapper, E entry, Object value) {
        return wrapper.type().deserialize(entry, value);
    }

    @Contract(value="_, _, _, !null -> !null")
    protected static <K, T> T getAsOrElse(@NotNull Map<K, ?> map, K key, @NotNull Class<T> type, T def) {
        Object o = map.get(key);
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        return def;
    }

    public ConfigHotKey copy() {
        ConfigHotKey hotKey = new ConfigHotKey();
        hotKey.setKeyMapping(this.keyMapping);
        hotKey.setName(this.name);
        hotKey.setEnabled(this.enabled);
        LinkedHashMap actions = new LinkedHashMap();
        this.actions.forEach((pair, map) -> actions.put((Pair<String, SimpleConfig.EditType>)pair, (Map<String, HotKeyAction<?>>)new LinkedHashMap(map)));
        hotKey.setActions(actions);
        LinkedHashMap<String, Map<String, Map<String, Object>>> unknown = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        this.unknown.forEach((modId, sub) -> {
            Map s = unknown.computeIfAbsent((String)modId, k -> new LinkedHashMap());
            sub.forEach((t, subSub) -> s.computeIfAbsent(t, k -> new LinkedHashMap()).putAll(subSub));
        });
        hotKey.setUnknown(unknown);
        return hotKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigHotKey that = (ConfigHotKey)o;
        return this.enabled == that.enabled && this.keyMapping.equals(that.keyMapping) && this.name.equals(that.name) && this.actions.equals(that.actions) && this.unknown.equals(that.unknown);
    }

    public int hashCode() {
        return Objects.hash(this.keyMapping, this.name, this.enabled, this.actions, this.unknown);
    }

    private static class HotKeyExecutionContext {
        public final SimpleConfigImpl config;
        public final CommentedConfig result = CommentedConfig.inMemory();
        public final List<Component> report = new ArrayList<Component>();

        private HotKeyExecutionContext(SimpleConfigImpl config) {
            this.config = config;
        }
    }
}

