/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.treeview;

import endorh.simpleconfig.ui.gui.widget.ScrollingContainerWidget;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeView;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewCaption;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ArrangeableTreeViewScroller
extends ScrollingContainerWidget {
    private final ArrangeableTreeView<?> tree;

    public ArrangeableTreeViewScroller(ArrangeableTreeView<?> tree) {
        super(tree.area.copy());
        this.tree = tree;
        this.listeners.add(tree.getRoot());
    }

    @Override
    public void renderInner(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        ArrangeableTreeView<?> tree = this.getTree();
        Object root = tree.getRoot();
        if (((ArrangeableTreeViewEntry)root).getSubEntries().isEmpty()) {
            Component placeHolder = tree.getPlaceHolder();
            if (placeHolder != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                ArrangeableTreeViewCaption<?> caption = tree.getCaption();
                int maxWidth = tree.getWidth() - 8;
                int width = font.m_92852_((FormattedText)placeHolder);
                int textX = tree.area.getCenterX() - width / 2;
                if (textX < tree.getX() + 4) {
                    textX = tree.getX() + 4;
                }
                int textY = tree.area.getCenterY() - tree.getPlaceHolderHeight() / 2;
                if (caption != null) {
                    textY += caption.getHeight() / 2;
                }
                textY = Math.max(textY, tree.area.getY() + (caption != null ? caption.getHeight() : 0) + 4);
                gg.m_280554_(font, (FormattedText)placeHolder, textX, textY, maxWidth, -522133280);
            }
        } else {
            ((ArrangeableTreeViewEntry)root).render(gg, x, y, w, mouseX, mouseY, delta);
        }
    }

    @Override
    public int getInnerHeight() {
        ArrangeableTreeView<?> tree = this.getTree();
        ArrangeableTreeViewCaption<?> caption = tree.getCaption();
        int captionHeight = caption != null ? caption.getHeight() + tree.getCaptionSeparation() : 0;
        int padding = tree.getPadding();
        return Math.max(tree.getHeight() - captionHeight - padding * 2, tree.getInnerHeight());
    }

    public ArrangeableTreeView<?> getTree() {
        return this.tree;
    }
}

