/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.treeview;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeView;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewScroller;
import endorh.simpleconfig.ui.gui.widget.treeview.DragBroadcastableControl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArrangeableTreeViewEntry<E extends ArrangeableTreeViewEntry<E>>
extends AbstractContainerEventHandlerEx {
    private static final boolean DEBUG_DRAG = false;
    private ArrangeableTreeView<E> tree;
    private E parent;
    private final Rectangle area = new Rectangle();
    protected List<E> subEntries = new ArrayList();
    protected final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    private E focusedSubEntry;
    private boolean expanded;
    private boolean awaitingSelectionMouseRelease;
    private Point clickedPos = null;
    private final ToggleAnimator expandAnimator = new ToggleAnimator();
    private final ToggleAnimator xAnimator = new ToggleAnimator();
    private final ToggleAnimator yAnimator = new ToggleAnimator();

    public ArrangeableTreeViewEntry() {
        this.cancelAnimations();
    }

    public List<E> getSubEntries() {
        return this.subEntries;
    }

    public void addSubEntry(E entry) {
        this.addSubEntry(this.getSubEntries().size(), entry);
    }

    public void addSubEntry(int pos, E entry) {
        this.subEntries.add(pos, entry);
        entry.tick(this.getTree(), (ArrangeableTreeViewEntry)this);
    }

    public void removeSubEntry(E entry) {
        this.tree.setSelected((ArrangeableTreeViewEntry<E>)entry, false);
        this.subEntries.remove(entry);
    }

    public int getOwnHeight() {
        return 24;
    }

    public int getVerticalPadding() {
        return 2;
    }

    protected final void tick(ArrangeableTreeView<E> tree, @Nullable E parent) {
        this.tree = tree;
        this.parent = parent;
        this.tick();
        for (ArrangeableTreeViewEntry e : this.getSubEntries()) {
            e.tick(tree, this);
        }
    }

    protected void tick() {
    }

    public ArrangeableTreeView<E> getTree() {
        return this.tree;
    }

    public E getParent() {
        return this.parent;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public int getTotalHeight(boolean ignoreExpanded, boolean ignoreHidden) {
        ArrangeableTreeView<E> tree = this.getTree();
        if (!ignoreHidden && this.isHidden()) {
            return 0;
        }
        return this.getOwnHeight() + (ignoreExpanded || this.expanded ? this.getSubEntries().stream().mapToInt(e -> e.getTotalHeight(ignoreExpanded, ignoreHidden)).sum() : 0) + (tree.getDraggedOver() == this && !ignoreHidden ? 20 : 0);
    }

    public int getHeight() {
        ArrangeableTreeView<E> tree = this.getTree();
        if (this.isHidden()) {
            return 0;
        }
        return this.getOwnHeight() + (this.expanded ? this.subEntries.stream().mapToInt(ArrangeableTreeViewEntry::getHeight).sum() : 0) + (tree.getDraggedOver() == this ? 20 : 0);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, true);
    }

    public void setExpanded(boolean expanded, boolean animated) {
        if (this.getParent() == null) {
            expanded = true;
            animated = false;
        }
        this.expanded = expanded;
        if (animated) {
            this.expandAnimator.resetTarget(expanded);
            this.expandAnimator.setOutputRange(0.0f, 1.0f);
        } else {
            float p = expanded ? 1.0f : 0.0f;
            this.expandAnimator.setOutputRange(p, p);
        }
    }

    public boolean isHidden() {
        ArrangeableTreeView<E> tree = this.getTree();
        return tree.isDraggingEntries() && tree.isSelected(this);
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean canBeAddedToSelection(Set<E> selection) {
        return selection.isEmpty();
    }

    public boolean canBeDroppedInto(int index, List<E> selection) {
        return selection.size() == 1 ? this.getSubEntries().contains(selection.get(0)) : new HashSet<E>(this.getSubEntries()).containsAll(selection);
    }

    public E getFocusedSubEntry() {
        return this.focusedSubEntry;
    }

    public void expandParents() {
        E p = this.getParent();
        if (p != null) {
            ((ArrangeableTreeViewEntry)p).setExpanded(true);
            ((ArrangeableTreeViewEntry)p).expandParents();
        }
    }

    public int getRelY() {
        ArrangeableTreeViewEntry e;
        E p = this.getParent();
        if (p == null) {
            return 0;
        }
        int y = ((ArrangeableTreeViewEntry)p).getRelY();
        if (p != this.tree.getRoot()) {
            y += ((ArrangeableTreeViewEntry)p).getOwnHeight();
        }
        Iterator<E> iterator = ((ArrangeableTreeViewEntry)p).getSubEntries().iterator();
        while (iterator.hasNext() && (e = (ArrangeableTreeViewEntry)iterator.next()) != this) {
            y += e.getTotalHeight(false, false);
        }
        return y;
    }

    protected Point interpolatePosition(int x, int y) {
        ArrangeableTreeView<E> tree = this.getTree();
        ArrangeableTreeViewScroller scroller = tree.scroller;
        int treeX = tree.getX();
        int treeY = (int)((double)scroller.getY() - scroller.scrollAmount);
        int relX = x - treeX;
        int relY = y - treeY;
        if (relY != (int)this.yAnimator.getRangeMax()) {
            this.yAnimator.setOutputRange(this.yAnimator.getRangeMin() == -1.0f ? (float)relY : this.yAnimator.getEaseOut(), relY);
            this.yAnimator.resetTarget();
        }
        if (relX != (int)this.xAnimator.getRangeMax()) {
            this.xAnimator.setOutputRange(this.xAnimator.getRangeMin() == -1.0f ? (float)relX : this.xAnimator.getEaseOut(), relX);
            this.xAnimator.resetTarget();
        }
        return Point.of(treeX + Math.round(this.xAnimator.getEaseOut()), treeY + Math.round(this.yAnimator.getEaseOut()));
    }

    protected void cancelAnimations() {
        this.xAnimator.setOutputRange(-1.0f, -1.0f);
        this.yAnimator.setOutputRange(-1.0f, -1.0f);
        this.getSubEntries().forEach(ArrangeableTreeViewEntry::cancelAnimations);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean alt = Screen.m_96639_();
        return alt && this.handleNavigationKey(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers) || !alt && this.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        boolean select;
        E focused = this.focusedSubEntry;
        if (focused != null) {
            return ((ArrangeableTreeViewEntry)focused).handleNavigationKey(keyCode, scanCode, modifiers);
        }
        boolean shift = Screen.m_96638_();
        boolean ctrl = Screen.m_96637_();
        boolean clear = !shift && !ctrl;
        boolean bl = select = shift || !ctrl;
        if (keyCode == 263) {
            if (this.isExpanded()) {
                this.setExpanded(false);
            } else {
                E p = this.getParent();
                if (p != null) {
                    ((ArrangeableTreeViewEntry)p).focusAndSelect(clear, select, shift, null);
                }
            }
            return true;
        }
        if (keyCode == 262) {
            if (!this.isExpanded()) {
                this.setExpanded(true);
            } else {
                Optional first = this.getSubEntries().stream().findFirst();
                if (first.isPresent()) {
                    ((ArrangeableTreeViewEntry)first.get()).focusAndSelect(clear, select, shift, null);
                } else {
                    this.handleNavigationKey(264, scanCode, modifiers);
                }
            }
            return true;
        }
        if (keyCode == 265 || keyCode == 264) {
            return this.handleArrowKeys(keyCode == 264, null);
        }
        if (keyCode == 32 && ctrl) {
            ArrangeableTreeView<E> tree;
            tree.setSelected(this, !(tree = this.getTree()).isSelected(this));
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (Screen.m_96639_() && Screen.m_96637_() && (codePoint == ' ' || codePoint == '\u00a0')) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    protected boolean handleArrowKeys(boolean forwards, ArrangeableTreeViewEntry<E> redirect) {
        boolean shift = Screen.m_96638_();
        boolean ctrl = Screen.m_96637_();
        boolean clear = !shift && !ctrl;
        boolean select = shift || !ctrl;
        List<E> subEntries = this.getSubEntries();
        boolean hasChildren = this.isExpanded() && !subEntries.isEmpty();
        E p = this.getParent();
        if (p != null) {
            if (redirect != null && !forwards) {
                if (hasChildren) {
                    ((ArrangeableTreeViewEntry)subEntries.get(subEntries.size() - 1)).handleArrowKeys(false, redirect);
                } else {
                    this.focusAndSelect(clear, select, shift, redirect);
                }
                return true;
            }
            if (hasChildren && forwards && redirect == null) {
                ((ArrangeableTreeViewEntry)subEntries.get(0)).focusAndSelect(clear, select, shift, this);
                return true;
            }
            List<E> siblings = ((ArrangeableTreeViewEntry)p).getSubEntries();
            int step = forwards ? 1 : -1;
            int index = siblings.indexOf(this);
            if (index == -1) {
                return false;
            }
            if ((index += step) < 0) {
                if (((ArrangeableTreeViewEntry)p).getParent() == null) {
                    return ((ArrangeableTreeViewEntry)p).handleArrowKeys(false, this);
                }
                ((ArrangeableTreeViewEntry)p).focusAndSelect(clear, select, shift, this);
            } else if (index >= siblings.size()) {
                ((ArrangeableTreeViewEntry)p).m_7522_(null);
                ((ArrangeableTreeViewEntry)p).handleArrowKeys(true, this);
            } else {
                ArrangeableTreeViewEntry entry = (ArrangeableTreeViewEntry)siblings.get(index);
                if (forwards) {
                    entry.focusAndSelect(clear, select, shift, redirect != null ? redirect : this);
                } else {
                    entry.handleArrowKeys(false, this);
                }
            }
        } else if (forwards) {
            ((ArrangeableTreeViewEntry)subEntries.get(0)).focusAndSelect(clear, select, shift, redirect);
        } else {
            ((ArrangeableTreeViewEntry)subEntries.get(subEntries.size() - 1)).handleArrowKeys(false, redirect);
        }
        return true;
    }

    @Override
    public void m_7522_(@Nullable GuiEventListener listener) {
        this.setFocused(listener, true);
    }

    public void setFocused(@Nullable GuiEventListener listener, boolean scroll) {
        super.m_7522_(listener);
        if (this.focusedSubEntry != null && this.focusedSubEntry != listener) {
            ((ArrangeableTreeViewEntry)this.focusedSubEntry).unFocus();
        }
        if (this.getSubEntries().contains(listener)) {
            ArrangeableTreeViewEntry entry = (ArrangeableTreeViewEntry)listener;
            this.focusedSubEntry = entry;
            if (scroll && entry != null && entry.getFocusedSubEntry() == null) {
                entry.ensureVisible();
            }
        } else {
            this.focusedSubEntry = null;
        }
    }

    public void m_93692_(boolean focus) {
        ArrangeableTreeView<E> tree = this.getTree();
        E focused = this.getFocusedSubEntry();
        if (focus && focused != null && ((ArrangeableTreeViewEntry)focused).getFocusedSubEntry() == null) {
            tree.clearSelection();
            tree.setSelected((ArrangeableTreeViewEntry<E>)focused, true);
        }
    }

    protected void focusAndSelect(boolean clearSelection, boolean select, boolean retract, @Nullable ArrangeableTreeViewEntry<E> remove) {
        this.focus();
        ArrangeableTreeView<E> tree = this.getTree();
        E parent = this.getParent();
        if (select && !this.isSelectable() && !((ArrangeableTreeViewEntry)parent).isSelectable()) {
            select = false;
        }
        ArrangeableTreeViewEntry self = this;
        if (clearSelection) {
            tree.clearSelection();
        } else if (retract && remove != null && tree.getSelection().contains(self)) {
            tree.setSelected(remove, false);
        }
        if (select) {
            tree.setSelected(this.isSelectable() ? this : parent, true);
        }
    }

    protected void focus() {
        this.focus(true);
    }

    protected void focus(boolean scroll) {
        E parent = this.getParent();
        if (parent != null) {
            ((ArrangeableTreeViewEntry)parent).focus(false);
            ((ArrangeableTreeViewEntry)parent).setFocused((GuiEventListener)this, false);
        }
        List<GuiEventListener> listeners = this.m_6702_();
        GuiEventListener first = listeners.stream().findFirst().filter(l -> !(l instanceof ArrangeableTreeViewEntry)).orElse(null);
        this.m_7522_(first);
        if (scroll) {
            this.ensureVisible();
        }
    }

    protected void ensureVisible() {
        int relY = this.getRelY();
        this.getTree().scroller.scrollToShow(relY, relY + this.getOwnHeight());
    }

    protected void unFocus() {
        GuiEventListener listener = this.m_7222_();
        this.m_7522_(null);
        if (listener instanceof ArrangeableTreeViewEntry) {
            ((ArrangeableTreeViewEntry)listener).unFocus();
        } else if (listener != null) {
            listener.m_93692_(false);
        }
    }

    public void updateDraggingPos(int x, int y, int mouseX, int mouseY, int insertPos, boolean lastSibling) {
        ArrangeableTreeView tree = this.getTree();
        if (tree.isSelected(this)) {
            return;
        }
        E p = this.getParent();
        int h = this.getOwnHeight();
        int yy = p != null ? y + h : y;
        ArrangeableTreeViewEntry self = this;
        int dragY = mouseY + tree.getDragOffsetY();
        int indent = tree.getIndent();
        int halfIndent = indent / 2;
        if (p == null || dragY >= y + h / 2) {
            tree.setDraggedOver(self);
            int dragX = mouseX + tree.getDragOffsetX();
            List<E> subEntries = this.getSubEntries();
            Optional<ArrangeableTreeViewEntry> first = subEntries.stream().filter(e -> !tree.isSelected((ArrangeableTreeViewEntry)e)).findFirst();
            boolean empty = first.isEmpty();
            List<E> draggedEntries = tree.getDraggedEntries();
            if (this.isExpanded() && (empty || dragY < yy + first.get().getOwnHeight() / 2) && this.canBeDroppedInto(0, draggedEntries) && (dragX >= x + halfIndent || !empty) || p == null) {
                tree.setDraggedOverParent(self);
            } else if (((ArrangeableTreeViewEntry)p).canBeDroppedInto(insertPos, draggedEntries) && (dragX >= x - halfIndent || !lastSibling)) {
                tree.setDraggedOverParent((ArrangeableTreeViewEntry<E>)p);
            }
            if (this.isExpanded()) {
                int inPos = 0;
                int lastY = yy;
                ArrangeableTreeViewEntry last = null;
                boolean isLast = true;
                for (ArrangeableTreeViewEntry sub : subEntries) {
                    if (dragY >= yy + sub.getOwnHeight() / 2) {
                        if (tree.isSelected(sub)) continue;
                        last = sub;
                        ++inPos;
                        lastY = yy;
                        yy += sub.getHeight();
                        continue;
                    }
                    if (!tree.isSelected(sub)) {
                        isLast = false;
                        break;
                    }
                    yy += sub.getHeight();
                }
                if (last != null) {
                    last.updateDraggingPos(x + indent, lastY, mouseX, mouseY, inPos, isLast);
                }
            }
        }
    }

    public void renderBackground(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        ArrangeableTreeView<E> tree = this.getTree();
        if (tree.isDraggingEntries() && tree.isSelected(this)) {
            gg.m_280509_(x, y, x + w, y + h, 1684300928);
            return;
        }
        E parent = this.getParent();
        int l = tree.getX();
        int r = tree.getX() + tree.getWidth();
        int b = y + h;
        if (tree.isSelected(this)) {
            gg.m_280509_(l, y, r, b, 1684300928);
        }
        if (parent != null && ((ArrangeableTreeViewEntry)parent).getFocusedSubEntry() == this && this.getFocusedSubEntry() == null) {
            AbstractConfigScreen.drawBorderRect(gg, l, y, r, b, 1, -2139062144, 0);
        }
    }

    public void render(GuiGraphics gg, int x, int y, int width, int mouseX, int mouseY, float delta) {
        boolean hasDragPreview;
        Point pos = this.interpolatePosition(x, y);
        int ix = pos.getX();
        int iy = pos.getY();
        int height = this.getOwnHeight();
        this.renderBackground(gg, ix, iy, width, height, mouseX, mouseY, delta);
        if (!this.subEntries.isEmpty() && height < 10) {
            height = 10;
        }
        this.area.setBounds(ix, iy, width, height);
        E p = this.getParent();
        int yy = y;
        if (p != null) {
            if (!this.subEntries.isEmpty() || this.isForceRenderAsGroup()) {
                SimpleConfigIcons.Widgets.TREE_ARROW.renderCentered(gg, ix, iy, 16, height, this.isExpanded() ? 1 : 0);
            }
            if (this.isSelectable()) {
                SimpleConfigIcons.Widgets.TREE_DRAG_HANDLE.renderCentered(gg, ix + 16, iy, 8, height);
            }
            int padding = this.getVerticalPadding();
            this.renderContent(gg, ix + 24, iy + padding, width - 24, height - 2 * padding, mouseX, mouseY, delta);
            yy += height;
        }
        ArrangeableTreeView<E> tree = this.getTree();
        int indent = tree.getIndent();
        boolean bl = hasDragPreview = tree.isDraggingEntries() && tree.getDraggedOver() == this;
        if (this.isExpanded() && !this.subEntries.isEmpty()) {
            float e = this.expandAnimator.getEaseOut();
            if (e < 1.0f) {
                ScissorsHandler.INSTANCE.pushScissor(new Rectangle(tree.getX(), y, tree.getWidth(), (int)(e * (float)this.getTotalHeight(false, false))));
            }
            if (hasDragPreview && tree.getDraggedOverParent() == this) {
                this.renderDragPreview(gg, yy);
                yy += 20;
                hasDragPreview = false;
            }
            for (ArrangeableTreeViewEntry subCell : this.subEntries) {
                if (subCell.isHidden() && !this.isHidden()) continue;
                subCell.render(gg, x + indent, yy, width - indent, mouseX, mouseY, delta);
                yy += subCell.getTotalHeight(false, false);
            }
            if (e < 1.0f) {
                ScissorsHandler.INSTANCE.popScissor();
            }
        }
        if (hasDragPreview) {
            this.renderDragPreview(gg, yy);
        }
    }

    protected void renderDragPreview(GuiGraphics gg, int y) {
        ArrangeableTreeView<E> tree = this.getTree();
        int destX = ((ArrangeableTreeViewEntry)tree.getDraggedOverParent()).getArea().x + tree.getIndent();
        AbstractConfigScreen.drawBorderRect(gg, destX, y, tree.area.getMaxX(), y + 20, 1, -2139053825, 1684308223);
        SimpleConfigIcons.Widgets.TREE_DRAG_HANDLE.renderCentered(gg, destX + 16, y, 8, 20);
    }

    public abstract void renderContent(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    public boolean isForceRenderAsGroup() {
        return false;
    }

    public boolean isMouseOverSelf(double mouseX, double mouseY) {
        ArrangeableTreeView<E> tree = this.getTree();
        int x = tree.getX();
        return (double)x <= mouseX && mouseX < (double)(x + tree.getWidth()) && (double)this.area.y <= mouseY && mouseY < (double)this.area.getMaxY();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        ArrangeableTreeView<E> tree = this.getTree();
        int x = tree.getX();
        return (double)x <= mouseX && mouseX < (double)(x + tree.getWidth()) && (double)this.area.y <= mouseY && mouseY < (double)(this.area.y + this.getHeight());
    }

    public boolean isMouseOverArrow(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY) && mouseX < (double)(this.area.x + 16);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ArrangeableTreeView<E> tree = this.getTree();
        E p = this.getParent();
        this.clickedPos = Point.of(mouseX, mouseY);
        if (p != null && this.area.contains(mouseX, mouseY) && this.isSelectable()) {
            E focused = ((ArrangeableTreeViewEntry)p).getFocusedSubEntry();
            boolean isSelected = tree.isSelected(this);
            if (Screen.m_96638_() && focused != null && focused != this) {
                List<E> siblings = ((ArrangeableTreeViewEntry)p).getSubEntries();
                int selfPos = siblings.indexOf(this);
                int focPos = siblings.indexOf(focused);
                tree.setSelected(this, true);
                for (int i = Math.min(selfPos, focPos); i <= Math.max(selfPos, focPos); ++i) {
                    tree.setSelected((ArrangeableTreeViewEntry)siblings.get(i), true);
                }
                return true;
            }
            if (Screen.m_96637_() && (isSelected || this.canBeAddedToSelection(tree.getSelection()))) {
                tree.setSelected(this, !isSelected);
                return true;
            }
            if (!isSelected) {
                tree.clearSelection();
                tree.setSelected(this, true);
            } else {
                this.awaitingSelectionMouseRelease = true;
            }
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.isMouseOverArrow(mouseX, mouseY)) {
            this.setExpanded(!this.isExpanded());
            tree.startExpandDrag(this.isExpanded());
            return true;
        }
        this.m_7522_(null);
        return this.area.contains(mouseX, mouseY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        ArrangeableTreeView<E> tree = this.getTree();
        if (this.awaitingSelectionMouseRelease) {
            tree.clearSelection();
            tree.setSelected(this, true);
            this.awaitingSelectionMouseRelease = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        ArrangeableTreeView<E> tree = this.getTree();
        if (!tree.isDraggingEntries() && tree.isSelected(this) && (this.clickedPos == null || this.clickedPos.distance(mouseX, mouseY) > 8.0)) {
            this.awaitingSelectionMouseRelease = false;
            tree.startDrag((int)((double)this.area.x - mouseX), (int)((double)this.area.y - mouseY), button);
            return false;
        }
        return false;
    }

    @NotNull
    public List<GuiEventListener> m_6702_() {
        if (this == this.tree.getRoot()) {
            return Lists.newArrayList(this.subEntries);
        }
        return this.isExpanded() ? Stream.concat(this.listeners.stream(), this.subEntries.stream()).collect(Collectors.toList()) : this.listeners;
    }

    public <W extends IPositionableRenderable> DragBroadcastableControl<W> draggable(DragBroadcastableControl.DragBroadcastableAction<W> action, W widget) {
        return new DragBroadcastableControl<W>(this::getTree, action, widget);
    }

    public <W extends AbstractWidget> DragBroadcastableControl.DragBroadcastableWidget<W> draggable(DragBroadcastableControl.DragBroadcastableAction.WidgetDragBroadcastableAction<W> action, W widget) {
        return new DragBroadcastableControl.DragBroadcastableWidget<W>(this::getTree, action, widget);
    }
}

