/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.treeview;

import com.google.common.collect.Lists;
import endorh.simpleconfig.ui.api.AbstractContainerEventHandlerEx;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeView;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArrangeableTreeViewCaption<E extends ArrangeableTreeViewEntry<E>>
extends AbstractContainerEventHandlerEx {
    private final ArrangeableTreeView<E> tree;
    protected List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    protected List<IPositionableRenderable> controls = new ArrayList<IPositionableRenderable>();
    protected List<IPositionableRenderable> rightControls = new ArrayList<IPositionableRenderable>();
    private Component title = Component.m_237119_();
    private int titleColor = -522133280;

    protected ArrangeableTreeViewCaption(ArrangeableTreeView<E> tree) {
        this.tree = tree;
    }

    public ArrangeableTreeView<E> getTree() {
        return this.tree;
    }

    protected void addControl(AbstractWidget control) {
        this.addControl(this.controls.size(), control);
    }

    protected void addControl(int pos, AbstractWidget control) {
        this.addControl(pos, IPositionableRenderable.wrap(control));
    }

    protected void addControl(IPositionableRenderable control) {
        this.addControl(this.controls.size(), control);
    }

    protected void addControl(int pos, IPositionableRenderable control) {
        this.controls.add(pos, control);
        this.listeners.add(pos, control);
    }

    protected void addRightControl(AbstractWidget control) {
        this.addRightControl(this.rightControls.size(), control);
    }

    protected void addRightControl(int pos, AbstractWidget control) {
        this.addControl(pos, IPositionableRenderable.wrap(control));
    }

    protected void addRightControl(IPositionableRenderable control) {
        this.addRightControl(this.rightControls.size(), control);
    }

    protected void addRightControl(int pos, IPositionableRenderable control) {
        this.rightControls.add(pos, control);
        this.listeners.add(pos + this.controls.size(), control);
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(@NotNull FocusNavigationEvent e) {
        return super.m_264064_(e);
    }

    protected int getHeight() {
        return 24;
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        ArrangeableTreeView<E> tree = this.getTree();
        int pad = tree.getPadding();
        int x = tree.getX() + pad;
        int y = tree.getY() + pad;
        int height = this.getHeight();
        boolean focused = tree.isFocusedCaption();
        Font font = Minecraft.m_91087_().f_91062_;
        for (IPositionableRenderable control : this.controls) {
            if (!focused || control != this.m_7222_()) {
                control.m_93692_(false);
            }
            control.setPosition(x, y);
            control.m_88315_(gg, mouseX, mouseY, delta);
            x += control.getWidth() + 2;
        }
        int minX = x;
        x = tree.getX() + tree.getWidth() - pad + 2;
        boolean skip = false;
        for (IPositionableRenderable control : Lists.reverse(this.rightControls)) {
            x = Math.max(x - control.getWidth() - 2, minX);
            if (!skip) {
                if (!focused || control != this.m_7222_()) {
                    control.m_93692_(false);
                }
                control.setPosition(x, y);
                control.m_88315_(gg, mouseX, mouseY, delta);
                if (x > minX) continue;
                skip = true;
                continue;
            }
            control.m_93692_(false);
            control.setPosition(0, 0, 0, 0);
        }
        int maxX = x;
        if (maxX - minX > 16) {
            Component component = this.getTitle();
            Objects.requireNonNull(font);
            gg.m_280554_(font, (FormattedText)component, minX + 4, y + (height - 9) / 2, maxX - minX - 8, this.getTitleColor());
        }
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }
}

