/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.treeview;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.widget.IPositionableRenderable;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewCaption;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewEntry;
import endorh.simpleconfig.ui.gui.widget.treeview.ArrangeableTreeViewScroller;
import endorh.simpleconfig.ui.gui.widget.treeview.DragBroadcastableControl;
import endorh.simpleconfig.ui.gui.widget.treeview.IDragBroadcastableControlContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangeableTreeView<E extends ArrangeableTreeViewEntry<E>>
extends AbstractContainerEventHandler
implements IOverlayCapableContainer.IOverlayRenderer,
IPositionableRenderable.IRectanglePositionableRenderable,
IDragBroadcastableControlContainer {
    private final IOverlayCapableContainer overlayContainer;
    private final E root;
    @Nullable
    private ArrangeableTreeViewCaption<E> caption = null;
    private final RedirectGuiEventListener captionReference = new RedirectGuiEventListener(null);
    private int indent = 12;
    private Component placeHolder = Component.m_237115_((String)"simpleconfig.ui.nothing_here_yet");
    protected final Rectangle area = new Rectangle();
    protected final Rectangle overlayArea = new Rectangle();
    protected final ArrangeableTreeViewScroller scroller;
    protected List<GuiEventListener> listeners;
    private boolean transparent = false;
    private int borderColor = -2139062144;
    private int fillColor = 0x32242424;
    private Pair<Integer, GuiEventListener> dragged;
    private final Set<E> selection = new HashSet();
    private List<E> draggedEntries;
    private long lastAutoDrag = 0L;
    private int dragOffsetX;
    private int dragOffsetY;
    private E draggedOver;
    private E draggedOverParent = null;
    private DragBroadcastableControl.DragBroadcastableAction<?> dragBroadcastableAction = null;
    private DragBroadcastableControl<?> dragBroadcastableSource = null;
    @Nullable
    private Boolean draggedExpandState = null;

    public ArrangeableTreeView(IOverlayCapableContainer overlayContainer, E root) {
        this.overlayContainer = overlayContainer;
        this.root = root;
        ((ArrangeableTreeViewEntry)root).setExpanded(true);
        this.tick();
        this.scroller = new ArrangeableTreeViewScroller(this);
        this.listeners = Lists.newArrayList((Object[])new GuiEventListener[]{this.captionReference, this.scroller});
    }

    public void tick() {
        this.getRoot().tick(this, null);
    }

    public E getRoot() {
        return this.root;
    }

    @Nullable
    public ArrangeableTreeViewCaption<E> getCaption() {
        return this.caption;
    }

    public void setCaption(@Nullable ArrangeableTreeViewCaption<E> caption) {
        this.caption = caption;
        this.captionReference.setTarget((GuiEventListener)caption);
    }

    public Component getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(Component placeHolder) {
        this.placeHolder = placeHolder;
    }

    protected boolean isFocusedCaption() {
        return this.m_7222_() == this.captionReference;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    @Override
    public Rectangle getArea() {
        return this.area;
    }

    public int getPlaceHolderHeight() {
        Component placeHolder = this.getPlaceHolder();
        if (placeHolder != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            int n = font.m_92923_((FormattedText)placeHolder, this.getWidth() - 8).size();
            Objects.requireNonNull(font);
            return n * 9;
        }
        return 0;
    }

    public int getInnerHeight() {
        E root = this.getRoot();
        int placeHolderHeight = 0;
        if (((ArrangeableTreeViewEntry)root).getSubEntries().isEmpty()) {
            placeHolderHeight = this.getPlaceHolderHeight();
        }
        return Math.max(placeHolderHeight, ((ArrangeableTreeViewEntry)root).getTotalHeight(false, true) - ((ArrangeableTreeViewEntry)root).getOwnHeight());
    }

    public int getTotalInnerHeight() {
        E root = this.getRoot();
        int placeHolderHeight = 0;
        if (((ArrangeableTreeViewEntry)root).getSubEntries().isEmpty()) {
            placeHolderHeight = this.getPlaceHolderHeight();
        }
        return Math.max(placeHolderHeight, ((ArrangeableTreeViewEntry)root).getTotalHeight(true, true) - ((ArrangeableTreeViewEntry)root).getOwnHeight());
    }

    public int getPreferredHeight() {
        ArrangeableTreeViewCaption<E> caption = this.getCaption();
        return this.getTotalInnerHeight() + (caption != null ? caption.getHeight() + this.getCaptionSeparation() : 0) + this.getPadding() * 2;
    }

    public void setSelected(ArrangeableTreeViewEntry<E> entry, boolean selected) {
        if (entry.isSelectable() && selected) {
            if (entry.canBeAddedToSelection(this.selection) && entry != this.getRoot()) {
                this.selection.add(entry);
            }
        } else {
            this.selection.remove(entry);
        }
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public boolean isSelected(ArrangeableTreeViewEntry<E> entry) {
        E p = entry.getParent();
        return this.selection.contains(entry) || p != null && this.isSelected((ArrangeableTreeViewEntry<E>)p);
    }

    public boolean isDraggingEntries() {
        return this.draggedEntries != null;
    }

    public Set<E> getSelection() {
        return this.selection;
    }

    public List<E> getSortedSelection() {
        ArrayList sorted = new ArrayList();
        for (ArrangeableTreeViewEntry entry : ((ArrangeableTreeViewEntry)this.getRoot()).getSubEntries()) {
            this.addSelected(sorted, entry);
        }
        return sorted;
    }

    private void addSelected(List<E> list, E entry) {
        if (this.isSelected((ArrangeableTreeViewEntry<E>)entry)) {
            list.add(entry);
        } else {
            for (ArrangeableTreeViewEntry child : ((ArrangeableTreeViewEntry)entry).getSubEntries()) {
                this.addSelected(list, child);
            }
        }
    }

    public void startDrag(int dragOffsetX, int dragOffsetY, int button) {
        this.setDragged((Pair<Integer, GuiEventListener>)Pair.of((Object)button, null));
        this.draggedEntries = this.getSortedSelection();
        this.dragOffsetX = dragOffsetX;
        this.dragOffsetY = dragOffsetY;
        this.draggedOver = null;
        this.draggedOverParent = null;
        this.overlayArea.setBounds(this.area.x - 128, this.area.y - 128, this.area.width + 256, this.area.height + 256);
        this.overlayContainer.addOverlay(this.overlayArea, this);
    }

    public void cancelDragging() {
        this.dragged = null;
        this.draggedEntries = null;
        this.draggedOver = null;
        this.draggedOverParent = null;
        this.lastAutoDrag = 0L;
    }

    public E getFocusedEntry() {
        E entry = this.getRoot();
        while (((ArrangeableTreeViewEntry)entry).getFocusedSubEntry() != null) {
            entry = ((ArrangeableTreeViewEntry)entry).getFocusedSubEntry();
        }
        return entry;
    }

    public void setFocusedEntry(E entry) {
        E focused = this.getFocusedEntry();
        ((ArrangeableTreeViewEntry)focused).unFocus();
        ((ArrangeableTreeViewEntry)entry).focus();
    }

    public boolean tryAddEntry(E entry) {
        E focused = this.getFocusedEntry();
        List<E> s = Collections.singletonList(entry);
        int index = 0;
        while (focused != null && !((ArrangeableTreeViewEntry)focused).canBeDroppedInto(index, s)) {
            Object parent = ((ArrangeableTreeViewEntry)focused).getParent();
            index = ((ArrangeableTreeViewEntry)parent).getSubEntries().indexOf(focused) + 1;
            focused = parent;
        }
        if (focused != null) {
            ((ArrangeableTreeViewEntry)focused).addSubEntry(index, entry);
            ((ArrangeableTreeViewEntry)entry).focusAndSelect(true, true, true, null);
        }
        return focused != null;
    }

    public void removeSelection() {
        List<E> sortedSelection = this.getSortedSelection();
        ArrangeableTreeViewEntry last = null;
        for (ArrangeableTreeViewEntry entry : sortedSelection) {
            ArrangeableTreeViewEntry parent = entry.getParent();
            if (parent == null) continue;
            List siblings = parent.getSubEntries();
            int size = siblings.size();
            if (size == 1) {
                last = parent;
            } else {
                int index = siblings.indexOf(entry);
                index = index == size - 1 ? index - 1 : index + 1;
                last = index >= 0 && index < size ? (ArrangeableTreeViewEntry)siblings.get(index) : parent;
            }
            parent.removeSubEntry((ArrangeableTreeViewEntry)entry);
        }
        if (last != null) {
            last.focusAndSelect(true, true, true, null);
        }
    }

    @Nullable
    public E getEntryAtPos(double mouseX, double mouseY) {
        return this.getEntryAtPos(mouseX, mouseY, true);
    }

    @Nullable
    public E getEntryAtPos(double mouseX, double mouseY, boolean ignoreIndent) {
        E root;
        Object entry = root = this.getRoot();
        block0: while (entry == root || !((ArrangeableTreeViewEntry)entry).isMouseOverSelf(mouseX, mouseY)) {
            if (!((ArrangeableTreeViewEntry)entry).m_5953_(mouseX, mouseY)) {
                return null;
            }
            List subEntries = ((ArrangeableTreeViewEntry)entry).getSubEntries();
            for (ArrangeableTreeViewEntry sub : subEntries) {
                if (!sub.m_5953_(mouseX, mouseY)) continue;
                entry = sub;
                continue block0;
            }
            return null;
        }
        return (E)(ignoreIndent || (double)((ArrangeableTreeViewEntry)entry).getArea().x <= mouseX ? entry : null);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isExpandDragging()) {
            Object entry = this.getEntryAtPos(mouseX, mouseY);
            boolean state = this.getExpandDragState();
            if (entry != null && ((ArrangeableTreeViewEntry)entry).isExpanded() != state && !((ArrangeableTreeViewEntry)entry).getSubEntries().isEmpty()) {
                ((ArrangeableTreeViewEntry)entry).setExpanded(state);
                if (!state) {
                    ((ArrangeableTreeViewEntry)entry).focusAndSelect(true, true, true, null);
                }
            }
            return true;
        }
        return IDragBroadcastableControlContainer.super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void endDrag(double mouseX, double mouseY, int button) {
        if (this.isExpandDragging()) {
            this.endExpandDrag();
        }
        if (this.isDraggingEntries()) {
            if (this.draggedOver != null && this.draggedOverParent != null) {
                E entry;
                List parentSubEntries = ((ArrangeableTreeViewEntry)this.draggedOverParent).getSubEntries();
                for (entry = this.draggedOver; entry != null && this.draggedOverParent != entry && !parentSubEntries.contains(entry); entry = ((ArrangeableTreeViewEntry)entry).getParent()) {
                }
                int index = parentSubEntries.indexOf(entry) + 1;
                if (((ArrangeableTreeViewEntry)this.draggedOverParent).canBeDroppedInto(index, this.draggedEntries)) {
                    for (ArrangeableTreeViewEntry dragged : this.draggedEntries) {
                        ArrangeableTreeViewEntry p = dragged.getParent();
                        p.removeSubEntry((ArrangeableTreeViewEntry)dragged);
                    }
                    index = parentSubEntries.indexOf(entry) + 1;
                    for (ArrangeableTreeViewEntry dragged : this.draggedEntries) {
                        this.draggedOverParent.addSubEntry(index++, (ArrangeableTreeViewEntry)dragged);
                    }
                }
            }
            this.cancelDragging();
        }
        IDragBroadcastableControlContainer.super.endDrag(mouseX, mouseY, button);
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        ArrangeableTreeViewCaption<E> caption = this.getCaption();
        this.area.setBounds(x, y, w, h);
        int pad = this.getPadding();
        if (!this.transparent) {
            this.renderLayout(gg, mouseX, mouseY, delta);
        }
        int captionHeight = caption != null ? caption.getHeight() + this.getCaptionSeparation() : 0;
        this.scroller.area.setBounds(x + pad, y + pad + captionHeight, w - pad * 2, h - captionHeight - pad * 2);
        if (caption != null) {
            caption.render(gg, mouseX, mouseY, delta);
        }
        this.scroller.m_88315_(gg, mouseX, mouseY, delta);
    }

    public int getPadding() {
        return this.transparent ? 0 : 1;
    }

    public int getCaptionSeparation() {
        return 1;
    }

    public void renderLayout(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        Rectangle area = this.getArea();
        gg.m_280509_(area.x, area.y, area.getMaxX(), area.getMaxY(), this.fillColor);
        AbstractConfigScreen.drawBorderRect(gg, area.x, area.y, area.getMaxX(), area.getMaxY(), 1, this.borderColor, 0);
        ArrangeableTreeViewCaption<E> caption = this.getCaption();
        if (caption != null) {
            int h = caption.getHeight();
            gg.m_280509_(area.x + 1, area.y + h + 1, area.getMaxX() - 1, area.y + h + 2, this.borderColor);
        }
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        this.overlayArea.setBounds(area.x - 128, area.y - 128, area.width + 256, area.height + 256);
        if (!this.isDraggingEntries() || area != this.overlayArea) {
            return false;
        }
        E root = this.getRoot();
        Rectangle rootArea = ((ArrangeableTreeViewEntry)root).getArea();
        ((ArrangeableTreeViewEntry)root).updateDraggingPos(rootArea.x, rootArea.y, mouseX, mouseY, 0, false);
        if (this.draggedOverParent == null) {
            this.draggedOver = null;
        }
        int draggedWidth = (int)((double)this.area.getWidth() * 0.8);
        int draggedHeight = 48;
        int dragX = Mth.m_14045_((int)(mouseX + this.getDragOffsetX()), (int)this.overlayArea.x, (int)(this.overlayArea.getMaxX() - draggedWidth));
        int dragY = Mth.m_14045_((int)(mouseY + this.getDragOffsetY()), (int)this.overlayArea.y, (int)(this.overlayArea.getMaxY() - draggedHeight));
        this.renderDragged(gg, dragX, dragY, draggedWidth, mouseX, mouseY, delta);
        double autoScroll = 0.0;
        int top = this.getY();
        int bottom = top + this.getHeight();
        if (mouseY < top + 24 || mouseY >= bottom - 24) {
            long t = System.currentTimeMillis();
            long dragTime = this.lastAutoDrag == 0L ? 0L : t - this.lastAutoDrag;
            this.lastAutoDrag = t;
            float dragMultiplier = (float)(mouseY < top + 24 ? mouseY - (top + 24) : mouseY - (bottom - 24)) * 0.01f;
            autoScroll = dragMultiplier * (float)dragTime;
        }
        if (autoScroll != 0.0) {
            this.scroller.scrollBy(autoScroll, true);
        }
        return true;
    }

    public void renderDragged(GuiGraphics gg, int x, int y, int w, int mouseX, int mouseY, float delta) {
        if (this.isDraggingEntries()) {
            int yy = y;
            boolean i = false;
            for (ArrangeableTreeViewEntry cell : this.getDraggedEntries()) {
                boolean expanded = cell.isExpanded();
                cell.setExpanded(false, false);
                cell.cancelAnimations();
                cell.render(gg, x, yy, w, mouseX, mouseY, delta);
                yy += cell.getTotalHeight(false, true);
                cell.setExpanded(expanded, false);
            }
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isDraggingEntries()) {
            return true;
        }
        return IDragBroadcastableControlContainer.super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isDraggingEntries()) {
            return true;
        }
        boolean r = super.m_7933_(keyCode, scanCode, modifiers);
        if (!(r || keyCode != 265 && keyCode != 264)) {
            this.m_7522_((GuiEventListener)this.root);
            return ((ArrangeableTreeViewEntry)this.root).handleNavigationKey(keyCode, scanCode, modifiers);
        }
        return r;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.isDraggingEntries()) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return IDragBroadcastableControlContainer.super.m_6348_(mouseX, mouseY, button);
    }

    protected List<E> getDraggedEntries() {
        return this.draggedEntries;
    }

    protected int getDragOffsetX() {
        return this.dragOffsetX;
    }

    protected int getDragOffsetY() {
        return this.dragOffsetY;
    }

    protected E getDraggedOver() {
        return this.draggedOver;
    }

    protected void setDraggedOver(E draggedOver) {
        this.draggedOver = draggedOver;
    }

    protected E getDraggedOverParent() {
        return this.draggedOverParent;
    }

    protected void setDraggedOverParent(E draggedOverParent) {
        this.draggedOverParent = draggedOverParent;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    @Override
    public Pair<Integer, GuiEventListener> getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(Pair<Integer, GuiEventListener> dragged) {
        this.dragged = dragged;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public <W extends IPositionableRenderable> void setDragBroadcastableAction(DragBroadcastableControl.DragBroadcastableAction<W> action, DragBroadcastableControl<W> source) {
        this.dragBroadcastableAction = action;
        this.dragBroadcastableSource = source;
    }

    @Override
    public DragBroadcastableControl.DragBroadcastableAction<?> getDragBroadcastableAction() {
        return this.dragBroadcastableAction;
    }

    @Override
    public DragBroadcastableControl<?> getDragBroadcastableSource() {
        return this.dragBroadcastableSource;
    }

    public void startExpandDrag(boolean expand) {
        this.draggedExpandState = expand;
    }

    public void endExpandDrag() {
        this.draggedExpandState = null;
    }

    public boolean isExpandDragging() {
        return this.draggedExpandState != null;
    }

    public boolean getExpandDragState() {
        return this.draggedExpandState != null ? this.draggedExpandState : false;
    }
}

