/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.combobox.wrapper;

import com.mojang.blaze3d.vertex.PoseStack;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeWrapper<T> {
    public static final Icon ICON_ERROR = SimpleConfigIcons.ComboBox.ERROR;
    public static final Icon ICON_UNKNOWN = SimpleConfigIcons.ComboBox.UNKNOWN;
    @ApiStatus.Internal
    public static final Pattern STYLE_ESCAPE = Pattern.compile("\u00a7[\\da-f]");

    default public boolean hasIcon() {
        return false;
    }

    default public int getIconHeight() {
        return 20;
    }

    default public int getIconWidth() {
        return this.getIconHeight();
    }

    default public void renderIcon(@Nullable T element, String text, @NotNull GuiGraphics gg, int x, int y, int w, int h, int blitOffset, int mouseX, int mouseY, float delta) {
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        mStack.m_85837_(0.0, 0.0, (double)blitOffset);
        Optional<Icon> opt = this.getIcon(element, text);
        opt.ifPresent(i -> i.renderCentered(gg, x, y, w, h));
        mStack.m_85849_();
    }

    default public Optional<Icon> getIcon(@Nullable T element, String text) {
        return Optional.empty();
    }

    public Pair<Optional<T>, Optional<Component>> parseElement(@NotNull String var1);

    public Component getDisplayName(@NotNull T var1);

    default public List<Component> getHelpTooltip(@NotNull T element) {
        return Collections.emptyList();
    }

    default public String getName(@NotNull T element) {
        return STYLE_ESCAPE.matcher(this.getDisplayName(element).getString()).replaceAll("");
    }

    @Nullable
    default public TextFormatter getTextFormatter() {
        return null;
    }
}

