/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.combobox.wrapper;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLocationTypeWrapper
implements TypeWrapper<ResourceLocation> {
    boolean hasIcon = false;
    int iconHeight = 20;
    int iconWidth = 20;

    public ResourceLocationTypeWrapper() {
    }

    protected ResourceLocationTypeWrapper(int iconSize) {
        this(iconSize, iconSize);
    }

    protected ResourceLocationTypeWrapper(int iconWidth, int iconHeight) {
        this.hasIcon = true;
        this.iconHeight = iconHeight;
        this.iconWidth = iconWidth;
    }

    @Override
    public boolean hasIcon() {
        return this.hasIcon;
    }

    @Override
    public int getIconHeight() {
        return this.hasIcon ? this.iconHeight : TypeWrapper.super.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.hasIcon ? this.iconWidth : TypeWrapper.super.getIconWidth();
    }

    @Override
    public Pair<Optional<ResourceLocation>, Optional<Component>> parseElement(@NotNull String text) {
        try {
            return Pair.of(Optional.of(new ResourceLocation(text)), Optional.empty());
        }
        catch (ResourceLocationException e) {
            return Pair.of(Optional.empty(), Optional.of(Component.m_237113_((String)e.getLocalizedMessage())));
        }
    }

    @Override
    public Component getDisplayName(@NotNull ResourceLocation element) {
        if (element.m_135827_().equals("minecraft")) {
            return Component.m_237113_((String)element.m_135815_());
        }
        return Component.m_237113_((String)element.m_135827_()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)":").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)element.m_135815_()).m_130940_(ChatFormatting.WHITE));
    }

    @Override
    public String getName(@NotNull ResourceLocation element) {
        return element.m_135827_().equals("minecraft") ? element.m_135815_() : element.toString();
    }

    @Override
    @Nullable
    public TextFormatter getTextFormatter() {
        return TextFormatter.forResourceLocation();
    }
}

