/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.widget.combobox.wrapper;

import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryObjectTypeWrapper<T>
implements TypeWrapper<T> {
    protected boolean hasIcon = false;
    protected int iconSize = 20;

    protected RegistryObjectTypeWrapper() {
    }

    protected RegistryObjectTypeWrapper(int iconSize) {
        this.hasIcon = true;
        this.iconSize = iconSize;
    }

    @Override
    public boolean hasIcon() {
        return this.hasIcon;
    }

    @Override
    public int getIconHeight() {
        return this.iconSize;
    }

    protected abstract ResourceLocation getRegistryName(@NotNull T var1);

    @Nullable
    protected abstract T getFromRegistryName(@NotNull ResourceLocation var1);

    protected abstract Component getUnknownError(ResourceLocation var1);

    @Override
    public String getName(@NotNull T element) {
        ResourceLocation name = this.getRegistryName(element);
        return name.m_135827_().equals("minecraft") ? name.m_135815_() : name.toString();
    }

    @Override
    public Pair<Optional<T>, Optional<Component>> parseElement(@NotNull String text) {
        try {
            ResourceLocation name = new ResourceLocation(text);
            T element = this.getFromRegistryName(name);
            if (element != null) {
                return Pair.of(Optional.of(element), Optional.empty());
            }
            return Pair.of(Optional.empty(), Optional.of(this.getUnknownError(name)));
        }
        catch (ResourceLocationException e) {
            return Pair.of(Optional.empty(), Optional.of(Component.m_237113_((String)e.getLocalizedMessage())));
        }
    }

    @Override
    public Component getDisplayName(@NotNull T element) {
        ResourceLocation name = this.getRegistryName(element);
        if (name.m_135827_().equals("minecraft")) {
            return Component.m_237113_((String)name.m_135815_());
        }
        return Component.m_237113_((String)name.m_135827_()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)":").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)name.m_135815_()).m_130940_(ChatFormatting.WHITE));
    }

    @Override
    @Nullable
    public TextFormatter getTextFormatter() {
        return TextFormatter.forResourceLocation();
    }
}

